let jwt = require('jsonwebtoken');
var appvers = require('../models/appvers');
const { body, validationResult } = require('express-validator');
var feteam= require('../models/feteam');

exports.getCheck =  async (req, res, next) => {
    try{
        const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(500).json({ errors: errors.array() });
    }
        // const user = await appvers.findOne({version:req.body.version}).exec();
        
        if(req.body.version === null || req.body.version === ''){
            return res.status(500).json({ errors: 'Version Not Found' });
        }
        // else if (req.body.version == '0.0.2') {
        //     return res.status(500).json({ errors: 'You App Version Blocked, Update App or Contact Operation Team' });
        // }
        else{
            return res.status(200).json({ success: 'Version Found' });
        }
      }catch(err){
        return res.status(500).json({ errors: err });
      }
};

exports.login = async (req, res, next) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(500).json({ errors: errors.array() });
    }
    let userdata = {
    username: parseInt(req.body.fecontact),
    password: req.body.password,
    };
 
    const user = await feteam.findOne({contact:userdata.username, password:userdata.password},{_id: 1, status: 1, contact: 1, name: 1,email: 1,alternative_contact: 1,address: 1,profile: 1,digitalid: 1, admin_id: 1}).exec();

    if(user){
        if(user.status =='Active'){
            let token = jwt.sign({ id: user._id,username: user.contact,password: user.password,fename: user.name,email: user.email,adminid:user.admin_id}, global.config.secretKey, {
            algorithm: global.config.algorithm,
            expiresIn: '7d'
            });
            const updateData= await feteam.findOneAndUpdate({'_id':user._id}, {'jwttoken':token,'login':'Yes'});
            res.status(200).json({
            message: 'Login Successful',
            jwtoken: token,
            data:user
            });
        } else {
            res.status(500).json({
            message: 'Login Failed, User Blocked'
            });
        }
    
    }
    else {
    res.status(500).json({
    message: 'Login Failed, Invalid Contact or Password'
    });
    }
 };