let jwt = require('jsonwebtoken');
let verifyToken = require('../middleware/apis/verifytoken');
const { body, validationResult } = require('express-validator');
var feteam= require('../models/feteam');
var feattendence= require('../models/feattendence');
var verificationModel= require('../models/physicalverification/caselist');

exports.updatetoken = async (req, res, next) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    try{
        const a1= await feteam.findByIdAndUpdate(req.decoded.id, {
            fcmToken: req.body.fcmToken,
          });
        if(a1 == null || a1 == ''){
            return res.status(500).json({ errors: 'Inavlid Credentials' });
        }else{
            return res.status(200).json({ success: 'Token Updated' });
        }
      }catch(err){
        return res.status(500).json({ errors: err });
      }
};


exports.attendencestart = async (req, res, next) => {
    console.log(req)
    const today = new Date();
    const datefolder = today.toDateString();
    const startdate = new Date();
    var start = today.setHours(0,0,0,0);
    var end = today.setHours(23,55,0,0);
    try{
    const lastatten = await feattendence.findOne({ 'feid':req.decoded.id, starttime: {$gt: start, $lte: end}}).sort({_id:-1}).limit(1);
        if(!lastatten){
            const data = new feattendence({
                "photo":`images/uploads/cases/uploads/${req.decoded.adminid}/FE/${datefolder}/${req.file.filename}`,
                "name":req.decoded.fename,
                "feid": req.decoded.id,
                "starttime": startdate,
            });
            const add = await data.save().catch(err => {
            res.status(500).json({
                error: err
            })
            });
            return res.status(200).json({ success: 'Upload', data:add });
        } else{
           return res.status(400).json({ success: 'running', data:lastatten });
        }
    }catch(err){
        return res.status(500).json({ errors: err });
    }
};
exports.runningattendence = async (req, res, next) => {
    const today = new Date();
    var start = today.setHours(0,0,0,0);
    var end = today.setHours(23,55,0,0);
    const lastatten = await feattendence.findOne({ 'feid':req.decoded.id, starttime: {$gt: start, $lte: end}}).sort({_id:-1}).limit(1);
  if(!lastatten){
    return res.status(400).json({ success: 'Upload',data:"Start Attendence" });
  } else{
      if(!lastatten.endtime){
       return res.status(200).json({ success: 'running', data:lastatten });
      } else{
          return res.status(200).json({ success: 'stop', data:lastatten });
      }
  }
 return res.status(500).json({ errors: err });
     
};
exports.stopattendence = async (req, res, next) => {
    const today = new Date();
     const datefolder = today.toDateString();
    const enddate = new Date();
    var start = today.setHours(0,0,0,0);
    var end = today.setHours(23,55,0,0);
    try{
    const lastatten = await feattendence.findOne({ 'feid':req.decoded.id, starttime: {$gt: start, $lte: end}}).sort({_id:-1}).limit(1);
        if(lastatten){
            if(!lastatten.endtime){
            const diff = Math.abs(enddate - lastatten.starttime);
            const tat = Math.floor(diff / (1000 * 60));
            await feattendence.findByIdAndUpdate(lastatten._id,{ endtime:enddate,  tat:tat, endphoto:`images/uploads/cases/uploads/${req.decoded.adminid}/FE/${datefolder}/${req.file.filename}`}).exec();
            }
            const stopdata = await feattendence.findOne({ '_id':lastatten._id, });
            return res.status(200).json({ success: 'Stop', data:stopdata });
        } else{
           return res.status(400).json({ success: 'No data found'});
        }
    }catch(err){
        return res.status(500).json({ errors: err });
    }
};

exports.monthattendence = async (req, res, next) => {
    var cmonth = parseInt(req.body.month) -1;
    var cyear = parseInt(req.body.year);
    const start = new Date(cyear, cmonth, 1).setHours(0, 0, 1);
    const end = new Date(cyear, cmonth + 1, 0).setHours(23, 59, 59);
    try{
        const monthattendence = await feattendence.find({ 'feid':req.decoded.id,'tat':{ $gt: 1},'createdAt': { $gt:start.toString(), $lt:end.toString()}},{'feid':1,'name':1,'createdAt':1,'tat':1}).catch(err => {
            res.status(500).json({
                error: err
            });
        });
        
        return res.status(200).json({ success: 'Data Found', data:monthattendence });
      }catch(err){
        return res.status(500).json({ errors: err });
      }
};

exports.getprofile = async (req, res, next) => {
    try{
        const data= await feteam.findOne({_id:req.decoded.id},{ contact: 1, name: 1,email: 1,alternative_contact: 1,address: 1,profile: 1,digitalid: 1}).exec();
        return res.status(200).json({ success: 'Data Found', data:data });
      }catch(err){
        return res.status(500).json({ errors: err });
      }
};
exports.updateprofile = async (req, res, next) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        var getData = await feteam.findOne({'_id':req.decoded.id},{_id: 1,profile: 1,digitalid: 1}).exec();
        if(typeof req.file === 'undefined'){
          profileimg= getData.profile;
        }else{
          profileimg=`images/uploads/cases/uploads/${req.decoded.adminid}/FE/${datefolder}/${req.file.filename}`
          if(getData.profile != '' && getData.profile != null && getData.profile != undefined){
            if (fs.existsSync(imageBaseDir+getData.profile)) {
              fs.unlinkSync(imageBaseDir+getData.profile);
            }
         }
        }
        await feteam.findByIdAndUpdate(req.decoded.id,{ 'name':req.body.name ,'alternative_contact':req.body.alternative_contact ,'address':req.body.address ,'profile':profileimg }).exec();
        const updateddata= await feteam.findOne({_id:req.decoded.id},{ contact: 1, name: 1,email: 1,alternative_contact: 1,address: 1,profile: 1,digitalid: 1}).exec();
        return res.status(200).json({ success: 'Profile Updated', data:updateddata });
    }catch(err){
        return res.status(500).json({ errors: err });
    }
};

exports.index = async (req, res, next) => {
   try{
        var data =await verificationModel.find({status : { $lte: 4}, 'adminid':req.decoded.adminid, 'feid':req.decoded.id},{status:1}).exec();

        var requestdata = data.filter(a => a.status == 1);
        var assigndata = data.filter(a => a.status == 2);
        var starteddata = data.filter(a => a.status == 3);
        
        objDef = {
        request: requestdata.length,
        assign: assigndata.length,
        started: starteddata.length,
        }
        return res.status(200).json({ success: 'Data Found', data:objDef });
    }catch(err){
        return res.status(500).json({ errors: err });
    };
};
exports.request = async (req, res, next) => {
   try{
        var skip = parseInt(req.body.skip);
        var size = parseInt(req.body.size);
        if (!skip) {
            skip = 0;
        }
        if (!size) {
            size = 10;
        }
       var data =await verificationModel.find({'adminid':req.decoded.adminid, 'status':1},{leadid:1,applicantname:1,contact:1,officename:1,permanentaddress:1,co_applicantname:1,guarantorname:1,typeofloan:1,permanentpincode:1,city:1,statementyear:1,applicantbankname:1,applicantbankaddress:1,totalincome:1,bankname:1,formtype:1,casetype:1,createdAt:1}).limit(size).skip(skip).exec();
        return res.status(200).json({ success: 'Data Found', data:data, skip, size });
    }catch(err){
        return res.status(500).json({ errors: err });
    };
};
exports.accept = async (req, res, next) => {
   try{
       var casecheck =await verificationModel.findOne({'_id':req.body.caseid, 'adminid':req.decoded.adminid, 'status':1},{feid:1}).exec();
       if(casecheck ==null || casecheck == ''){
           return res.status(500).json({ errors: 'wrong id' });
       } else {
           await verificationModel.findByIdAndUpdate(req.body.caseid,{'status':2,'feid':req.decoded.id,'fename':req.decoded.fename}).exec();
           return res.status(200).json({ success: 'Case accepted' });
       }
    }catch(err){
        return res.status(500).json({ errors: err });
    };
};


exports.assign = async (req, res, next) => {
   try{
       var skip = parseInt(req.body.skip);
        var size = parseInt(req.body.size);
        if (!skip) {
            skip = 0;
        }
        if (!size) {
            size = 10;
        }
       var data =await verificationModel.find({'adminid':req.decoded.adminid, 'feid':req.decoded.id, 'status':2},{leadid:1,co_applicantname:1,typeofloan:1,applicantname:1,guarantorname:1,officename:1,contact:1,permanentaddress:1,applicantbankname:1,statementyear:1,applicantbankaddress:1,permanentpincode:1,city:1,totalincome:1,bankname:1,formtype:1,casetype:1,createdAt:1}).limit(size).skip(skip).exec();
        return res.status(200).json({ success: 'Data Found', data:data, skip, size });
    }catch(err){
        return res.status(500).json({ errors: err });
    };
};

exports.start = async (req, res, next) => {
   try{
       var casecheck =await verificationModel.findOne({'_id':req.body.caseid, 'adminid':req.decoded.adminid,'feid':req.decoded.id, 'status':2},{feid:1}).exec();
       if(casecheck ==null || casecheck == ''){
           return res.status(500).json({ errors: 'wrong id' });
       } else {
           await verificationModel.findByIdAndUpdate(req.body.caseid,{'status':3,'feid':req.decoded.id,'fename':req.decoded.fename}).exec();
           return res.status(200).json({ success: 'Case Started' });
       }
    }catch(err){
        return res.status(500).json({ errors: err });
    };
};
exports.started = async (req, res, next) => {
   try{
       var skip = parseInt(req.body.skip);
        var size = parseInt(req.body.size);
        if (!skip) {
            skip = 0;
        }
        if (!size) {
            size = 10;
        }
       var data =await verificationModel.find({'adminid':req.decoded.adminid, 'feid':req.decoded.id, 'status':3},{bankid:1,leadid:1,officename:1,applicantname:1,co_applicantname:1,guarantorname:1,typeofloan:1,contact:1,permanentaddress:1,permanentpincode:1,city:1,statementyear:1,applicantbankname:1,applicantbankaddress:1,totalincome:1,grosstotal:1,bankname:1,formtype:1,casetype:1,status:1,createdAt:1}).limit(size).skip(skip).exec();
        var totalrecord =await verificationModel.find({'adminid':req.decoded.adminid, 'feid':req.decoded.id, 'status':3}).countDocuments();
        return res.status(200).json({ success: 'Data Found', data:data, skip, size, totalrecord });
    }catch(err){
        return res.status(500).json({ errors: err });
    };
};

exports.completed = async (req, res, next) => {
   try{
       var skip = parseInt(req.body.skip);
        var size = parseInt(req.body.size);
        if (!skip) {
            skip = 0;
        }
        if (!size) {
            size = 10;
        }
       var data =await verificationModel.find({'adminid':req.decoded.adminid, 'feid':req.decoded.id, 'status': { $gt: 3, $lt:7}},{fedonedate:1,bankid:1,leadid:1,officename:1,applicantname:1,contact:1,co_applicantname:1,guarantorname:1,typeofloan:1,permanentaddress:1,permanentpincode:1,city:1,statementyear:1,applicantbankname:1,applicantbankaddress:1,totalincome:1,bankname:1,formtype:1,casetype:1,status:1,createdAt:1}).sort( { "fedonedate": 1 }).limit(size).skip(skip).exec();
        var totalrecord =await verificationModel.find({'adminid':req.decoded.adminid, 'feid':req.decoded.id, 'status': { $gt: 3, $lt:7}}).countDocuments();
        return res.status(200).json({ success: 'Data Found', data:data, skip, size, totalrecord });
    }catch(err){
        return res.status(500).json({ errors: err });
    };
};
       