// import express router
const express = require("express");
const router = express.Router();
let jwt = require('jsonwebtoken');
const { body, validationResult } = require('express-validator');
let verifyToken = require('../middleware/apis/verifytoken');
var feteam = require('../models/feteam');
var verificationModel= require('../models/physicalverification/caselist');
var resiverificationModel= require('../models/physicalverification/residencecases');
var resiimagesModel= require('../models/physicalverification/resiimages');
var officeverificationmodel = require('../models/physicalverification/officecases');
var bankstatementverificationmodel = require('../models/physicalverification/bankstatement');
var form16payslipverificationmodel = require('../models/physicalverification/form16payslip');
var officeimagesModel= require('../models/physicalverification/officeimages');
var otherimagesimagesModel= require('../models/physicalverification/otherimages');

const fs = require('fs');

// multer start
const multer = require("multer");
let storage = multer.diskStorage({
  destination: function (req, file, cb) {
    var adminID = req.decoded.adminid;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/physicalcases/'+file.fieldname+'/'+datefolder;
    fs.mkdirSync(dest, { recursive: true })
        cb(null, dest);
  },
  filename: function (req, file, cb) {
    let extArray = file.mimetype.split("/");
    let extension = extArray[extArray.length - 1];
    cb(null, file.fieldname + '-' + Date.now()+ '.' +extension)
  }
});
const upload = multer({ storage: storage });
// multer end


// fe residence
router.post("/residence", verifyToken, upload.fields([{ name: 'signature', maxCount: 1 },{ name: 'residence', maxCount: 14 }]),body('caseid').not().isEmpty().withMessage('caseid Required'), body('bankID').not().isEmpty().withMessage('bankID Required'), async function(req, res, next){
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    
     const olddata = await resiverificationModel.find({'caseid': req.body.caseid, 'fename': req.decoded.id, 'adminid': req.decoded.adminid});
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await resiverificationModel.findByIdAndDelete(olddata._id);
            const imgolddata = await resiimagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await resiimagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                return res.status(500).json({ errors: err });
            }
            else{
                const residata = new resiverificationModel({ 
                    leadid: docs.leadid,
                    caseid: docs._id,
                    applicantname: docs.applicantname,
                    contact: docs.contact,
                    permanentaddress: docs.permanentaddress,
                    landmark: docs.permanentaddress,
                    co_applicantname: docs.co_applicantname,
                    adminid: docs.adminid,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                    location: docs.location,
                    city: docs.city,
                    ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                    applicantemail: docs.applicantemail,
                    presentaddress: docs.presentaddress,
                    formtype: docs.formtype,
                    fename: req.decoded.fename,
                    feid: req.decoded.id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven: req.body.ufeleven,
                    uftwelve: req.body.uftwelve,
                    ufthirteen: req.body.ufthirteen,
                    uffourteen: req.body.uffourteen,
                    uffifteen: req.body.uffifteen,
                    ufsixteen: req.body.ufsixteen,
                    ufseventeen: req.body.ufseventeen,
                    ufeighteen: req.body.ufeighteen,
                    ufnineteen: req.body.ufnineteen,
                    uftwenty: req.body.uftwenty,
                    uftwentyone: req.body.uftwentyone,
                    uftwentytwo: req.body.uftwentytwo,
                    uftwentythree: req.body.uftwentythree,
                    uftwentyfour: req.body.uftwentyfour,
                    uftwentyfive: req.body.uftwentyfive,
                    uftwentysix: req.body.uftwentysix,
                    uftwentyseven: req.body.uftwentyseven,
                    uftwentyeight: req.body.uftwentyeight,
                    uftwentynine: req.body.uftwentynine,
                    ufthirty: req.body.ufthirty,
                    ufthirtyone: req.body.ufthirtyone,
                    ufthirtytwo: req.body.ufthirtytwo,
                    ufthirtythree: req.body.ufthirtythree,
                    ufthirtyfour: req.body.ufthirtyfour,
                    ufthirtyfive: req.body.ufthirtyfive,
                    ufthirtysix: req.body.ufthirtysix,
                    ufthirtyseven: req.body.ufthirtyseven,
                    ufthirtyeight: req.body.ufthirtyeight,
                    ufthirtynine: req.body.ufthirtynine,
                    ufforty: req.body.ufforty,
                    uffortyone: req.body.uffortyone,
                    uffortytwo: req.body.uffortytwo,
                    uffortythree: req.body.uffortythree,
                    uffortyfour:req.body.uffortyfour,
                    uffortyfive:req.body.uffortyfive,
                    uffortysix:req.body.uffortysix,
                    uffortyseven:req.body.uffortyseven,
                    uffortyeight:req.body.uffortyeight,
                    uffortynine:req.body.uffortynine,
                    uffifty:req.body.uffifty,
                    uffiftyone:req.body.uffiftyone,
                    uffiftytwo:req.body.uffiftytwo,
                    feremark:req.body.feremark,
                });
                const resisaveddata =await residata.save();
                    req.files.residence.map((cv, ind, arr)=>{
                    req.files.residence[ind].caseid=req.body.caseid;
                    req.files.residence[ind].fecode=req.decoded.id;
                    req.files.residence[ind].reportid=resisaveddata._id;
                    req.files.residence[ind].image=`images/uploads/cases/uploads/${req.decoded.adminid}/physicalcases/residence/${datefolder}/${arr[ind].filename}`;
                    });
                    resiimagesModel.insertMany(req.files.residence);
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'4',fedonedate:new Date(),});
            }
        });
        return res.status(200).json({ success: 'Case Completed' });
      }catch(err){
        return res.status(500).json({ errors: err });
      }  
});

// fe office
router.post("/office", verifyToken, upload.fields([{ name: 'signature', maxCount: 1 },{ name: 'office', maxCount: 14 }]),body('caseid').not().isEmpty().withMessage('caseid Required'), body('bankID').not().isEmpty().withMessage('bankID Required'), async function(req, res, next){
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    
     const olddata = await officeverificationmodel.find({'caseid': req.body.caseid, 'fename': req.decoded.id, 'adminid': req.decoded.adminid});
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await officeverificationmodel.findByIdAndDelete(olddata._id);
            const imgolddata = await officeimagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await officeimagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                return res.status(500).json({ errors: err });
            }
            else{
                const residata = new officeverificationmodel({ 
                    leadid: docs.leadid,
                    caseid: docs._id,
                    ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                    applicantemail: docs.applicantemail,
                    presentaddress: docs.presentaddress,
                    applicantname: docs.applicantname,
                    contact: docs.contact,
                    officename: docs.officename,
                    officeaddress: docs.permanentaddress,
                    landmark: docs.permanentaddress,
                    co_applicantname: docs.co_applicantname,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                    adminid: docs.adminid,
                    city: docs.city,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    formtype: docs.formtype,
                    fename: req.decoded.fename,
                    feid: req.decoded.id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven: req.body.ufeleven,
                    uftwelve: req.body.uftwelve,
                    ufthirteen: req.body.ufthirteen,
                    uffourteen: req.body.uffourteen,
                    uffifteen: req.body.uffifteen,
                    ufsixteen: req.body.ufsixteen,
                    ufseventeen: req.body.ufseventeen,
                    ufeighteen: req.body.ufeighteen,
                    ufnineteen: req.body.ufnineteen,
                    uftwenty: req.body.uftwenty,
                    uftwentyone: req.body.uftwentyone,
                    uftwentytwo: req.body.uftwentytwo,
                    uftwentythree: req.body.uftwentythree,
                    uftwentyfour: req.body.uftwentyfour,
                    uftwentyfive: req.body.uftwentyfive,
                    uftwentysix: req.body.uftwentysix,
                    uftwentyseven: req.body.uftwentyseven,
                    uftwentyeight: req.body.uftwentyeight,
                    uftwentynine: req.body.uftwentynine,
                    ufthirty: req.body.ufthirty,
                    ufthirtyone: req.body.ufthirtyone,
                    ufthirtytwo: req.body.ufthirtytwo,
                    ufthirtythree: req.body.ufthirtythree,
                    ufthirtyfour: req.body.ufthirtyfour,
                    ufthirtyfive: req.body.ufthirtyfive,
                    ufthirtysix: req.body.ufthirtysix,
                    ufthirtyseven: req.body.ufthirtyseven,
                    ufthirtyeight: req.body.ufthirtyeight,
                    ufthirtynine: req.body.ufthirtynine,
                    ufforty: req.body.ufforty,
                    uffortyone: req.body.uffortyone,
                    uffortytwo: req.body.uffortytwo,
                    uffortythree: req.body.uffortythree,
                    uffortyfour:req.body.uffortyfour,
                    uffortyfive:req.body.uffortyfive,
                    uffortysix:req.body.uffortysix,
                    uffortyseven:req.body.uffortyseven,
                    uffortyeight:req.body.uffortyeight,
                    uffortynine:req.body.uffortynine,
                    uffifty:req.body.uffifty,
                    uffiftyone:req.body.uffiftyone,
                    uffiftytwo:req.body.uffiftytwo,
                    feremark:req.body.feremark,
                   
                });
                const resisaveddata =await residata.save();
                    req.files.office.map((cv, ind, arr)=>{
                    req.files.office[ind].caseid=req.body.caseid;
                    req.files.office[ind].fecode=req.decoded.id;
                    req.files.office[ind].reportid=resisaveddata._id;
                    req.files.office[ind].image=`images/uploads/cases/uploads/${req.decoded.adminid}/physicalcases/office/${datefolder}/${arr[ind].filename}`;
                    });
                    officeimagesModel.insertMany(req.files.office);
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'4',fedonedate:new Date(),});
            }
        });
        return res.status(200).json({ success: 'Case Completed' });
      }catch(err){
        return res.status(500).json({ errors: err });
      }  
});

// fe business
router.post("/business", verifyToken, upload.fields([{ name: 'signature', maxCount: 1 },{ name: 'business', maxCount: 14 }]),body('caseid').not().isEmpty().withMessage('caseid Required'), body('bankID').not().isEmpty().withMessage('bankID Required'), async function(req, res, next){
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    
     const olddata = await officeverificationmodel.find({'caseid': req.body.caseid, 'fename': req.decoded.id, 'adminid': req.decoded.adminid});
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await officeverificationmodel.findByIdAndDelete(olddata._id);
            const imgolddata = await officeimagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await officeimagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                return res.status(500).json({ errors: err });
            }
            else{
                const residata = new officeverificationmodel({ 
                    leadid: docs.leadid,
                    caseid: docs._id,
                    ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                    applicantemail: docs.applicantemail,
                    presentaddress: docs.presentaddress,
                    applicantname: docs.applicantname,
                    contact: docs.contact,
                   officename: docs.officename,
                    officeaddress: docs.permanentaddress,
                    landmark: docs.permanentaddress,
                    co_applicantname: docs.co_applicantname,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                    city: docs.city,
                    adminid: docs.adminid,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    formtype: docs.formtype,
                    fename: req.decoded.fename,
                    feid: req.decoded.id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven: req.body.ufeleven,
                    uftwelve: req.body.uftwelve,
                    ufthirteen: req.body.ufthirteen,
                    uffourteen: req.body.uffourteen,
                    uffifteen: req.body.uffifteen,
                    ufsixteen: req.body.ufsixteen,
                    ufseventeen: req.body.ufseventeen,
                    ufeighteen: req.body.ufeighteen,
                    ufnineteen: req.body.ufnineteen,
                    uftwenty: req.body.uftwenty,
                    uftwentyone: req.body.uftwentyone,
                    uftwentytwo: req.body.uftwentytwo,
                    uftwentythree: req.body.uftwentythree,
                    uftwentyfour: req.body.uftwentyfour,
                    uftwentyfive: req.body.uftwentyfive,
                    uftwentysix: req.body.uftwentysix,
                    uftwentyseven: req.body.uftwentyseven,
                    uftwentyeight: req.body.uftwentyeight,
                    uftwentynine: req.body.uftwentynine,
                    ufthirty: req.body.ufthirty,
                    ufthirtyone: req.body.ufthirtyone,
                    ufthirtytwo: req.body.ufthirtytwo,
                    ufthirtythree: req.body.ufthirtythree,
                    ufthirtyfour: req.body.ufthirtyfour,
                    ufthirtyfive: req.body.ufthirtyfive,
                    ufthirtysix: req.body.ufthirtysix,
                    ufthirtyseven: req.body.ufthirtyseven,
                    ufthirtyeight: req.body.ufthirtyeight,
                    ufthirtynine: req.body.ufthirtynine,
                    ufforty: req.body.ufforty,
                    uffortyone: req.body.uffortyone,
                    uffortytwo: req.body.uffortytwo,
                    uffortythree: req.body.uffortythree,
                    uffortyfour:req.body.uffortyfour,
                    uffortyfive:req.body.uffortyfive,
                    uffortysix:req.body.uffortysix,
                    uffortyseven:req.body.uffortyseven,
                    uffortyeight:req.body.uffortyeight,
                    uffortynine:req.body.uffortynine,
                    uffifty:req.body.uffifty,
                    uffiftyone:req.body.uffiftyone,
                    uffiftytwo:req.body.uffiftytwo,
                    feremark:req.body.feremark,
                  
                });
                const resisaveddata =await residata.save();
                    req.files.business.map((cv, ind, arr)=>{
                    req.files.business[ind].caseid=req.body.caseid;
                    req.files.business[ind].fecode=req.decoded.id;
                    req.files.business[ind].reportid=resisaveddata._id;
                    req.files.business[ind].image=`images/uploads/cases/uploads/${req.decoded.adminid}/physicalcases/business/${datefolder}/${arr[ind].filename}`;
                    });
                    officeimagesModel.insertMany(req.files.business);
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'4',fedonedate:new Date(),});
            }
        });
        return res.status(200).json({ success: 'Case Completed' });
      }catch(err){
        return res.status(500).json({ errors: err });
      }  
});

// fe employment
router.post("/employment", verifyToken, upload.fields([{ name: 'signature', maxCount: 1 },{ name: 'employment', maxCount: 14 }]),body('caseid').not().isEmpty().withMessage('caseid Required'), body('bankID').not().isEmpty().withMessage('bankID Required'), async function(req, res, next){
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    
     const olddata = await officeverificationmodel.find({'caseid': req.body.caseid, 'fename': req.decoded.id, 'adminid': req.decoded.adminid});
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await officeverificationmodel.findByIdAndDelete(olddata._id);
            const imgolddata = await officeimagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await officeimagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                return res.status(500).json({ errors: err });
            }
            else{
                const residata = new officeverificationmodel({ 
                    leadid: docs.leadid,
                    caseid: docs._id,
                    ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                    applicantemail: docs.applicantemail,
                    presentaddress: docs.presentaddress,
                    applicantname: docs.applicantname,
                    contact: docs.contact,
                    officename: docs.officename,
                    officeaddress: docs.permanentaddress,
                    landmark: docs.permanentaddress,
                    co_applicantname: docs.co_applicantname,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                    city: docs.city,
                    adminid: docs.adminid,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    formtype: docs.formtype,
                    fename: req.decoded.fename,
                    feid: req.decoded.id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven: req.body.ufeleven,
                    uftwelve: req.body.uftwelve,
                    ufthirteen: req.body.ufthirteen,
                    uffourteen: req.body.uffourteen,
                    uffifteen: req.body.uffifteen,
                    ufsixteen: req.body.ufsixteen,
                    ufseventeen: req.body.ufseventeen,
                    ufeighteen: req.body.ufeighteen,
                    ufnineteen: req.body.ufnineteen,
                    uftwenty: req.body.uftwenty,
                    uftwentyone: req.body.uftwentyone,
                    uftwentytwo: req.body.uftwentytwo,
                    uftwentythree: req.body.uftwentythree,
                    uftwentyfour: req.body.uftwentyfour,
                    uftwentyfive: req.body.uftwentyfive,
                    uftwentysix: req.body.uftwentysix,
                    uftwentyseven: req.body.uftwentyseven,
                    uftwentyeight: req.body.uftwentyeight,
                    uftwentynine: req.body.uftwentynine,
                    ufthirty: req.body.ufthirty,
                    ufthirtyone: req.body.ufthirtyone,
                    ufthirtytwo: req.body.ufthirtytwo,
                    ufthirtythree: req.body.ufthirtythree,
                    ufthirtyfour: req.body.ufthirtyfour,
                    ufthirtyfive: req.body.ufthirtyfive,
                    ufthirtysix: req.body.ufthirtysix,
                    ufthirtyseven: req.body.ufthirtyseven,
                    ufthirtyeight: req.body.ufthirtyeight,
                    ufthirtynine: req.body.ufthirtynine,
                    ufforty: req.body.ufforty,
                    uffortyone: req.body.uffortyone,
                    uffortytwo: req.body.uffortytwo,
                    uffortythree: req.body.uffortythree,
                    uffortyfour:req.body.uffortyfour,
                    uffortyfive:req.body.uffortyfive,
                    uffortysix:req.body.uffortysix,
                    uffortyseven:req.body.uffortyseven,
                    uffortyeight:req.body.uffortyeight,
                    uffortynine:req.body.uffortynine,
                    uffifty:req.body.uffifty,
                    uffiftyone:req.body.uffiftyone,
                    uffiftytwo:req.body.uffiftytwo,
                    feremark:req.body.feremark,
                
                });
                const resisaveddata =await residata.save();
                    req.files.employment.map((cv, ind, arr)=>{
                    req.files.employment[ind].caseid=req.body.caseid;
                    req.files.employment[ind].fecode=req.decoded.id;
                    req.files.employment[ind].reportid=resisaveddata._id;
                    req.files.employment[ind].image=`images/uploads/cases/uploads/${req.decoded.adminid}/physicalcases/employment/${datefolder}/${arr[ind].filename}`;
                    });
                    officeimagesModel.insertMany(req.files.employment);
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'4',fedonedate:new Date(),});
            }
        });
        return res.status(200).json({ success: 'Case Completed' });
      }catch(err){
        return res.status(500).json({ errors: err });
      }  
});

// fe bankstatement
router.post("/bankstatement", verifyToken, upload.fields([{ name: 'signature', maxCount: 1 },{ name: 'bankstatement', maxCount: 14 }]),body('caseid').not().isEmpty().withMessage('caseid Required'), body('bankID').not().isEmpty().withMessage('bankID Required'), async function(req, res, next){
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    
     const olddata = await bankstatementverificationmodel.find({'caseid': req.body.caseid, 'fename': req.decoded.id, 'adminid': req.decoded.adminid});
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await bankstatementverificationmodel.findByIdAndDelete(olddata._id);
            const imgolddata = await otherimagesimagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await otherimagesimagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                return res.status(500).json({ errors: err });
            }
            else{
                const residata = new bankstatementverificationmodel({ 
                    leadid: docs.leadid,
                    caseid: docs._id,
                    ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                    applicantemail: docs.applicantemail,
                    applicantname: docs.applicantname,
                    contact: docs.contact,
                    officename: docs.officename,
                    statementyear: docs.statementyear,
                    applicantbankname: docs.applicantbankname,
                    applicantbankaddress: docs.applicantbankaddress,
                    totalincome: docs.totalincome,
                    permanentaddress: docs.permanentaddress,
                    landmark: docs.permanentaddress,
                    city: docs.city,
                    co_applicantname: docs.co_applicantname,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                    adminid: docs.adminid,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    formtype: docs.formtype,
                    fename: req.decoded.fename,
                    feid: req.decoded.id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven: req.body.ufeleven,
                    uftwelve: req.body.uftwelve,
                    ufthirteen: req.body.ufthirteen,
                    uffourteen: req.body.uffourteen,
                    uffifteen: req.body.uffifteen,
                    ufsixteen: req.body.ufsixteen,
                    ufseventeen: req.body.ufseventeen,
                    ufeighteen: req.body.ufeighteen,
                    ufnineteen: req.body.ufnineteen,
                    uftwenty: req.body.uftwenty,
                    uftwentyone: req.body.uftwentyone,
                    uftwentytwo: req.body.uftwentytwo,
                    uftwentythree: req.body.uftwentythree,
                    uftwentyfour: req.body.uftwentyfour,
                    uftwentyfive: req.body.uftwentyfive,
                    uftwentysix: req.body.uftwentysix,
                    uftwentyseven: req.body.uftwentyseven,
                    feremark:req.body.feremark,

                });
                const resisaveddata =await residata.save();
                    req.files.bankstatement.map((cv, ind, arr)=>{
                    req.files.bankstatement[ind].caseid=req.body.caseid;
                    req.files.bankstatement[ind].fecode=req.decoded.id;
                    req.files.bankstatement[ind].reportid=resisaveddata._id;
                    req.files.bankstatement[ind].image=`images/uploads/cases/uploads/${req.decoded.adminid}/physicalcases/bankstatement/${datefolder}/${arr[ind].filename}`;
                    });
                    otherimagesimagesModel.insertMany(req.files.bankstatement);
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'4',fedonedate:new Date(),});
            }
        });
        return res.status(200).json({ success: 'Case Completed' });
      }catch(err){
        return res.status(500).json({ errors: err });
      }  
});

// fe salarypayslip
router.post("/salarypayslip", verifyToken, upload.fields([{ name: 'signature', maxCount: 1 },{ name: 'salarypayslip', maxCount: 14 }]),body('caseid').not().isEmpty().withMessage('caseid Required'), body('bankID').not().isEmpty().withMessage('bankID Required'), async function(req, res, next){
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    
     const olddata = await form16payslipverificationmodel.find({'caseid': req.body.caseid, 'fename': req.decoded.id, 'adminid': req.decoded.adminid});
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await form16payslipverificationmodel.findByIdAndDelete(olddata._id);
            const imgolddata = await otherimagesimagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await otherimagesimagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                return res.status(500).json({ errors: err });
            }
            else{
                const residata = new form16payslipverificationmodel({ 
                    leadid: docs.leadid,
                    caseid: docs._id,
                    ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                    co_applicantname: docs.co_applicantname,
                    applicantemail: docs.applicantemail,
                    applicantname: docs.applicantname,
                    contact: docs.contact,
                    landmark: docs.grosstotal,
                    totalincome: docs.totalincome,
                    officename: docs.officename,
                    statementyear:docs.statementyear,
                    statementyeartwo:docs.statementyeartwo,
                    statementyearthree:docs.statementyearthree,
                    permanentaddress: docs.permanentaddress,
                    adminid: docs.adminid,
                    location: docs.location,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                   
                    city: docs.city,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    formtype: docs.formtype,
                    fename: req.decoded.fename,
                    feid: req.decoded.id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven: req.body.ufeleven,
                    uftwelve: req.body.uftwelve,
                    ufthirteen: req.body.ufthirteen,
                    uffourteen: req.body.uffourteen,
                    uffifteen: req.body.uffifteen,
                    ufsixteen: req.body.ufsixteen,
                    ufseventeen: req.body.ufseventeen,
                    ufeighteen: req.body.ufeighteen,
                    ufnineteen: req.body.ufnineteen,
                    uftwenty: req.body.uftwenty,
                    uftwentyone: req.body.uftwentyone,
                    uftwentytwo: req.body.uftwentytwo,
                    uftwentythree: req.body.uftwentythree,
                    uftwentyfour: req.body.uftwentyfour,
                    uftwentyfive: req.body.uftwentyfive,
                    uftwentysix: req.body.uftwentysix,
                    uftwentyseven: req.body.uftwentyseven,
                    uftwentyeight:req.body.uftwentyeight,
                    uftwentynine:req.body.uftwentynine,
                    ufthirty:req.body.ufthirty,
                    feremark:req.body.feremark,
                    
                });
                const resisaveddata =await residata.save();
                    req.files.salarypayslip.map((cv, ind, arr)=>{
                    req.files.salarypayslip[ind].caseid=req.body.caseid;
                    req.files.salarypayslip[ind].fecode=req.decoded.id;
                    req.files.salarypayslip[ind].reportid=resisaveddata._id;
                    req.files.salarypayslip[ind].image=`images/uploads/cases/uploads/${req.decoded.adminid}/physicalcases/salarypayslip/${datefolder}/${arr[ind].filename}`;
                    });
                    otherimagesimagesModel.insertMany(req.files.salarypayslip);
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'4',fedonedate:new Date(),});
            }
        });
        return res.status(200).json({ success: 'Case Completed' });
      }catch(err){
        return res.status(500).json({ errors: err });
      }  
});

// fe salarypayslip
router.post("/form16", verifyToken, upload.fields([{ name: 'signature', maxCount: 1 },{ name: 'form16', maxCount: 14 }]),body('caseid').not().isEmpty().withMessage('caseid Required'), body('bankID').not().isEmpty().withMessage('bankID Required'), async function(req, res, next){
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    
     const olddata = await form16payslipverificationmodel.find({'caseid': req.body.caseid, 'fename': req.decoded.id, 'adminid': req.decoded.adminid});
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await form16payslipverificationmodel.findByIdAndDelete(olddata._id);
            const imgolddata = await otherimagesimagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await otherimagesimagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                return res.status(500).json({ errors: err });
            }
            else{
                const residata = new form16payslipverificationmodel({ 
                    leadid: docs.leadid,
                    caseid: docs._id,
                    ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                    co_applicantname: docs.co_applicantname,
                    applicantemail: docs.applicantemail,
                    applicantname: docs.applicantname,
                    contact: docs.contact,
                    landmark: docs.grosstotal,
                    totalincome: docs.totalincome,
                    officename: docs.officename,
                    statementyear:docs.statementyear,
                    statementyeartwo:docs.statementyeartwo,
                    statementyearthree:docs.statementyearthree,
                    permanentaddress: docs.permanentaddress,
                    adminid: docs.adminid,
                    location: docs.location,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                   
                    city: docs.city,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    formtype: docs.formtype,
                    fename: req.decoded.fename,
                    feid: req.decoded.id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven: req.body.ufeleven,
                    uftwelve: req.body.uftwelve,
                    ufthirteen: req.body.ufthirteen,
                    uffourteen: req.body.uffourteen,
                    uffifteen: req.body.uffifteen,
                    ufsixteen: req.body.ufsixteen,
                    ufseventeen: req.body.ufseventeen,
                    ufeighteen: req.body.ufeighteen,
                    ufnineteen: req.body.ufnineteen,
                    uftwenty: req.body.uftwenty,
                    uftwentyone: req.body.uftwentyone,
                    uftwentytwo: req.body.uftwentytwo,
                    uftwentythree: req.body.uftwentythree,
                    uftwentyfour: req.body.uftwentyfour,
                    uftwentyfive: req.body.uftwentyfive,
                    uftwentysix: req.body.uftwentysix,
                    uftwentyseven: req.body.uftwentyseven,
                    uftwentyeight:req.body.uftwentyeight,
                    uftwentynine:req.body.uftwentynine,
                    ufthirty:req.body.ufthirty,
                    feremark:req.body.feremark,
                    
                });
                const resisaveddata =await residata.save();
                    req.files.form16.map((cv, ind, arr)=>{
                    req.files.form16[ind].caseid=req.body.caseid;
                    req.files.form16[ind].fecode=req.decoded.id;
                    req.files.form16[ind].reportid=resisaveddata._id;
                    req.files.form16[ind].image=`images/uploads/cases/uploads/${req.decoded.adminid}/physicalcases/form16/${datefolder}/${arr[ind].filename}`;
                    });
                    otherimagesimagesModel.insertMany(req.files.form16);
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'4',fedonedate:new Date(),});
            }
        });
        return res.status(200).json({ success: 'Case Completed' });
      }catch(err){
        return res.status(500).json({ errors: err });
      }  
});

// fe business
router.post("/AssetVerificationCarLoan", verifyToken, upload.fields([{ name: 'signature', maxCount: 1 },{ name: 'AssetVerificationCarLoan', maxCount: 14 }]),body('caseid').not().isEmpty().withMessage('caseid Required'), body('bankID').not().isEmpty().withMessage('bankID Required'), async function(req, res, next){
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    
     const olddata = await officeverificationmodel.find({'caseid': req.body.caseid, 'fename': req.decoded.id, 'adminid': req.decoded.adminid});
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await officeverificationmodel.findByIdAndDelete(olddata._id);
            const imgolddata = await officeimagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await officeimagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                return res.status(500).json({ errors: err });
            }
            else{
                const residata = new officeverificationmodel({ 
                    leadid: docs.leadid,
                    caseid: docs._id,
                      ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                  
                    location: docs.location,
               
                    ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                    location: docs.location,
                    applicantemail: docs.applicantemail,
                    applicantname: docs.applicantname,
                    contact: docs.contact,
                    officename: docs.officename,
                    officeaddress: docs.permanentaddress,
                    landmark: docs.permanentaddress,
                    co_applicantname: docs.co_applicantname,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                    city: docs.city,
                    adminid: docs.adminid,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    formtype: docs.formtype,
                    fename: req.decoded.fename,
                    feid: req.decoded.id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven: req.body.ufeleven,
                    uftwelve: req.body.uftwelve,
                    ufthirteen: req.body.ufthirteen,
                    uffourteen: req.body.uffourteen,
                    uffifteen: req.body.uffifteen,
                    ufsixteen: req.body.ufsixteen,
                    ufseventeen: req.body.ufseventeen,
                    ufeighteen: req.body.ufeighteen,
                    ufnineteen: req.body.ufnineteen,
                    uftwenty: req.body.uftwenty,
                    uftwentyone: req.body.uftwentyone,
                    uftwentytwo: req.body.uftwentytwo,
                    uftwentythree: req.body.uftwentythree,
                    uftwentyfour: req.body.uftwentyfour,
                    uftwentyfive: req.body.uftwentyfive,
                    uftwentysix: req.body.uftwentysix,
                    uftwentyseven: req.body.uftwentyseven,
                    uftwentyeight: req.body.uftwentyeight,
                    uftwentynine: req.body.uftwentynine,
                    ufthirty: req.body.ufthirty,
                    ufthirtyone: req.body.ufthirtyone,
                    ufthirtytwo: req.body.ufthirtytwo,
                    ufthirtythree: req.body.ufthirtythree,
                    ufthirtyfour: req.body.ufthirtyfour,
                    ufthirtyfive: req.body.ufthirtyfive,
                    ufthirtysix: req.body.ufthirtysix,
                    ufthirtyseven: req.body.ufthirtyseven,
                    ufthirtyeight: req.body.ufthirtyeight,
                    ufthirtynine: req.body.ufthirtynine,
                    ufforty: req.body.ufforty,
                    uffortyone: req.body.uffortyone,
                    uffortytwo: req.body.uffortytwo,
                    uffortythree: req.body.uffortythree,
                    uffortyfour:req.body.uffortyfour,
                    uffortyfive:req.body.uffortyfive,
                    uffortysix:req.body.uffortysix,
                    uffortyseven:req.body.uffortyseven,
                    uffortyeight:req.body.uffortyeight,
                    uffortynine:req.body.uffortynine,
                    uffifty:req.body.uffifty,
                    uffiftyone:req.body.uffiftyone,
                    uffiftytwo:req.body.uffiftytwo,
                    feremark:req.body.feremark,
                  
                });
                const resisaveddata =await residata.save();
                    req.files.AssetVerificationCarLoan.map((cv, ind, arr)=>{
                    req.files.AssetVerificationCarLoan[ind].caseid=req.body.caseid;
                    req.files.AssetVerificationCarLoan[ind].fecode=req.decoded.id;
                    req.files.AssetVerificationCarLoan[ind].reportid=resisaveddata._id;
                    req.files.AssetVerificationCarLoan[ind].image=`images/uploads/cases/uploads/${req.decoded.adminid}/physicalcases/AssetVerificationCarLoan/${datefolder}/${arr[ind].filename}`;
                    });
                    officeimagesModel.insertMany(req.files.business);
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'4',fedonedate:new Date(),});
            }
        });
        return res.status(200).json({ success: 'Case Completed' });
      }catch(err){
        return res.status(500).json({ errors: err });
      }  
});
// fe business
router.post("/AssetVerificationHousing", verifyToken, upload.fields([{ name: 'signature', maxCount: 1 },{ name: 'AssetVerificationHousing', maxCount: 14 }]),body('caseid').not().isEmpty().withMessage('caseid Required'), body('bankID').not().isEmpty().withMessage('bankID Required'), async function(req, res, next){
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    
     const olddata = await officeverificationmodel.find({'caseid': req.body.caseid, 'fename': req.decoded.id, 'adminid': req.decoded.adminid});
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await officeverificationmodel.findByIdAndDelete(olddata._id);
            const imgolddata = await officeimagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await officeimagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                return res.status(500).json({ errors: err });
            }
            else{
                const residata = new officeverificationmodel({ 
                    leadid: docs.leadid,
                    caseid: docs._id,
                      ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                  
                    location: docs.location,
               
                    applicantname: docs.applicantname,
                    contact: docs.contact,
                   officename: docs.officename,
                    officeaddress: docs.permanentaddress,
                    landmark: docs.permanentaddress,
                    co_applicantname: docs.co_applicantname,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                    city: docs.city,
                    adminid: docs.adminid,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    formtype: docs.formtype,
                    fename: req.decoded.fename,
                    feid: req.decoded.id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven: req.body.ufeleven,
                    uftwelve: req.body.uftwelve,
                    ufthirteen: req.body.ufthirteen,
                    uffourteen: req.body.uffourteen,
                    uffifteen: req.body.uffifteen,
                    ufsixteen: req.body.ufsixteen,
                    ufseventeen: req.body.ufseventeen,
                    ufeighteen: req.body.ufeighteen,
                    ufnineteen: req.body.ufnineteen,
                    uftwenty: req.body.uftwenty,
                    uftwentyone: req.body.uftwentyone,
                    uftwentytwo: req.body.uftwentytwo,
                    uftwentythree: req.body.uftwentythree,
                    uftwentyfour: req.body.uftwentyfour,
                    uftwentyfive: req.body.uftwentyfive,
                    uftwentysix: req.body.uftwentysix,
                    uftwentyseven: req.body.uftwentyseven,
                    uftwentyeight: req.body.uftwentyeight,
                    uftwentynine: req.body.uftwentynine,
                    ufthirty: req.body.ufthirty,
                    ufthirtyone: req.body.ufthirtyone,
                    ufthirtytwo: req.body.ufthirtytwo,
                    ufthirtythree: req.body.ufthirtythree,
                    ufthirtyfour: req.body.ufthirtyfour,
                    ufthirtyfive: req.body.ufthirtyfive,
                    ufthirtysix: req.body.ufthirtysix,
                    ufthirtyseven: req.body.ufthirtyseven,
                    ufthirtyeight: req.body.ufthirtyeight,
                    ufthirtynine: req.body.ufthirtynine,
                    ufforty: req.body.ufforty,
                    uffortyone: req.body.uffortyone,
                    uffortytwo: req.body.uffortytwo,
                    uffortythree: req.body.uffortythree,
                    uffortyfour:req.body.uffortyfour,
                    uffortyfive:req.body.uffortyfive,
                    uffortysix:req.body.uffortysix,
                    uffortyseven:req.body.uffortyseven,
                    uffortyeight:req.body.uffortyeight,
                    uffortynine:req.body.uffortynine,
                    uffifty:req.body.uffifty,
                    uffiftyone:req.body.uffiftyone,
                    uffiftytwo:req.body.uffiftytwo,
                    feremark:req.body.feremark,
                  
                });
                const resisaveddata =await residata.save();
                    req.files.AssetVerificationHousing.map((cv, ind, arr)=>{
                    req.files.AssetVerificationHousing[ind].caseid=req.body.caseid;
                    req.files.AssetVerificationHousing[ind].fecode=req.decoded.id;
                    req.files.AssetVerificationHousing[ind].reportid=resisaveddata._id;
                    req.files.AssetVerificationHousing[ind].image=`images/uploads/cases/uploads/${req.decoded.adminid}/physicalcases/AssetVerificationHousing/${datefolder}/${arr[ind].filename}`;
                    });
                    officeimagesModel.insertMany(req.files.business);
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'4',fedonedate:new Date(),});
            }
        });
        return res.status(200).json({ success: 'Case Completed' });
      }catch(err){
        return res.status(500).json({ errors: err });
      }  
});
// fe business
router.post("/Builder", verifyToken, upload.fields([{ name: 'signature', maxCount: 1 },{ name: 'Builder', maxCount: 14 }]),body('caseid').not().isEmpty().withMessage('caseid Required'), body('bankID').not().isEmpty().withMessage('bankID Required'), async function(req, res, next){
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    
     const olddata = await officeverificationmodel.find({'caseid': req.body.caseid, 'fename': req.decoded.id, 'adminid': req.decoded.adminid});
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await officeverificationmodel.findByIdAndDelete(olddata._id);
            const imgolddata = await officeimagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await officeimagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                return res.status(500).json({ errors: err });
            }
            else{
                const residata = new officeverificationmodel({ 
                    leadid: docs.leadid,
                    caseid: docs._id,
                      ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                  
                    location: docs.location,
               
                    applicantname: docs.applicantname,
                    contact: docs.contact,
                   officename: docs.officename,
                    officeaddress: docs.permanentaddress,
                    landmark: docs.permanentaddress,
                    co_applicantname: docs.co_applicantname,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                    city: docs.city,
                    adminid: docs.adminid,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    formtype: docs.formtype,
                    fename: req.decoded.fename,
                    feid: req.decoded.id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven: req.body.ufeleven,
                    uftwelve: req.body.uftwelve,
                    ufthirteen: req.body.ufthirteen,
                    uffourteen: req.body.uffourteen,
                    uffifteen: req.body.uffifteen,
                    ufsixteen: req.body.ufsixteen,
                    ufseventeen: req.body.ufseventeen,
                    ufeighteen: req.body.ufeighteen,
                    ufnineteen: req.body.ufnineteen,
                    uftwenty: req.body.uftwenty,
                    uftwentyone: req.body.uftwentyone,
                    uftwentytwo: req.body.uftwentytwo,
                    uftwentythree: req.body.uftwentythree,
                    uftwentyfour: req.body.uftwentyfour,
                    uftwentyfive: req.body.uftwentyfive,
                    uftwentysix: req.body.uftwentysix,
                    uftwentyseven: req.body.uftwentyseven,
                    uftwentyeight: req.body.uftwentyeight,
                    uftwentynine: req.body.uftwentynine,
                    ufthirty: req.body.ufthirty,
                    ufthirtyone: req.body.ufthirtyone,
                    ufthirtytwo: req.body.ufthirtytwo,
                    ufthirtythree: req.body.ufthirtythree,
                    ufthirtyfour: req.body.ufthirtyfour,
                    ufthirtyfive: req.body.ufthirtyfive,
                    ufthirtysix: req.body.ufthirtysix,
                    ufthirtyseven: req.body.ufthirtyseven,
                    ufthirtyeight: req.body.ufthirtyeight,
                    ufthirtynine: req.body.ufthirtynine,
                    ufforty: req.body.ufforty,
                    uffortyone: req.body.uffortyone,
                    uffortytwo: req.body.uffortytwo,
                    uffortythree: req.body.uffortythree,
                    uffortyfour:req.body.uffortyfour,
                    uffortyfive:req.body.uffortyfive,
                    uffortysix:req.body.uffortysix,
                    uffortyseven:req.body.uffortyseven,
                    uffortyeight:req.body.uffortyeight,
                    uffortynine:req.body.uffortynine,
                    uffifty:req.body.uffifty,
                    uffiftyone:req.body.uffiftyone,
                    uffiftytwo:req.body.uffiftytwo,
                    feremark:req.body.feremark,
                  
                });
                const resisaveddata =await residata.save();
                    req.files.Builder.map((cv, ind, arr)=>{
                    req.files.Builder[ind].caseid=req.body.caseid;
                    req.files.Builder[ind].fecode=req.decoded.id;
                    req.files.Builder[ind].reportid=resisaveddata._id;
                    req.files.Builder[ind].image=`images/uploads/cases/uploads/${req.decoded.adminid}/physicalcases/Builder/${datefolder}/${arr[ind].filename}`;
                    });
                    officeimagesModel.insertMany(req.files.business);
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'4',fedonedate:new Date(),});
            }
        });
        return res.status(200).json({ success: 'Case Completed' });
      }catch(err){
        return res.status(500).json({ errors: err });
      }  
});
// fe business
router.post("/CarSubDealer", verifyToken, upload.fields([{ name: 'signature', maxCount: 1 },{ name: 'CarSubDealer', maxCount: 14 }]),body('caseid').not().isEmpty().withMessage('caseid Required'), body('bankID').not().isEmpty().withMessage('bankID Required'), async function(req, res, next){
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    
     const olddata = await officeverificationmodel.find({'caseid': req.body.caseid, 'fename': req.decoded.id, 'adminid': req.decoded.adminid});
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await officeverificationmodel.findByIdAndDelete(olddata._id);
            const imgolddata = await officeimagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await officeimagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                return res.status(500).json({ errors: err });
            }
            else{
                const residata = new officeverificationmodel({ 
                    leadid: docs.leadid,
                    caseid: docs._id,
                      ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                  
                    location: docs.location,
               
                    applicantname: docs.applicantname,
                    contact: docs.contact,
                   officename: docs.officename,
                    officeaddress: docs.permanentaddress,
                    landmark: docs.permanentaddress,
                    co_applicantname: docs.co_applicantname,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                    city: docs.city,
                    adminid: docs.adminid,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    formtype: docs.formtype,
                    fename: req.decoded.fename,
                    feid: req.decoded.id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven: req.body.ufeleven,
                    uftwelve: req.body.uftwelve,
                    ufthirteen: req.body.ufthirteen,
                    uffourteen: req.body.uffourteen,
                    uffifteen: req.body.uffifteen,
                    ufsixteen: req.body.ufsixteen,
                    ufseventeen: req.body.ufseventeen,
                    ufeighteen: req.body.ufeighteen,
                    ufnineteen: req.body.ufnineteen,
                    uftwenty: req.body.uftwenty,
                    uftwentyone: req.body.uftwentyone,
                    uftwentytwo: req.body.uftwentytwo,
                    uftwentythree: req.body.uftwentythree,
                    uftwentyfour: req.body.uftwentyfour,
                    uftwentyfive: req.body.uftwentyfive,
                    uftwentysix: req.body.uftwentysix,
                    uftwentyseven: req.body.uftwentyseven,
                    uftwentyeight: req.body.uftwentyeight,
                    uftwentynine: req.body.uftwentynine,
                    ufthirty: req.body.ufthirty,
                    ufthirtyone: req.body.ufthirtyone,
                    ufthirtytwo: req.body.ufthirtytwo,
                    ufthirtythree: req.body.ufthirtythree,
                    ufthirtyfour: req.body.ufthirtyfour,
                    ufthirtyfive: req.body.ufthirtyfive,
                    ufthirtysix: req.body.ufthirtysix,
                    ufthirtyseven: req.body.ufthirtyseven,
                    ufthirtyeight: req.body.ufthirtyeight,
                    ufthirtynine: req.body.ufthirtynine,
                    ufforty: req.body.ufforty,
                    uffortyone: req.body.uffortyone,
                    uffortytwo: req.body.uffortytwo,
                    uffortythree: req.body.uffortythree,
                    uffortyfour:req.body.uffortyfour,
                    uffortyfive:req.body.uffortyfive,
                    uffortysix:req.body.uffortysix,
                    uffortyseven:req.body.uffortyseven,
                    uffortyeight:req.body.uffortyeight,
                    uffortynine:req.body.uffortynine,
                    uffifty:req.body.uffifty,
                    uffiftyone:req.body.uffiftyone,
                    uffiftytwo:req.body.uffiftytwo,
                    feremark:req.body.feremark,
                  
                });
                const resisaveddata =await residata.save();
                    req.files.CarSubDealer.map((cv, ind, arr)=>{
                    req.files.CarSubDealer[ind].caseid=req.body.caseid;
                    req.files.CarSubDealer[ind].fecode=req.decoded.id;
                    req.files.CarSubDealer[ind].reportid=resisaveddata._id;
                    req.files.CarSubDealer[ind].image=`images/uploads/cases/uploads/${req.decoded.adminid}/physicalcases/CarSubDealer/${datefolder}/${arr[ind].filename}`;
                    });
                    officeimagesModel.insertMany(req.files.business);
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'4',fedonedate:new Date(),});
            }
        });
        return res.status(200).json({ success: 'Case Completed' });
      }catch(err){
        return res.status(500).json({ errors: err });
      }  
});
// fe business
router.post("/CarDealer", verifyToken, upload.fields([{ name: 'signature', maxCount: 1 },{ name: 'CarDealer', maxCount: 14 }]),body('caseid').not().isEmpty().withMessage('caseid Required'), body('bankID').not().isEmpty().withMessage('bankID Required'), async function(req, res, next){
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    
     const olddata = await officeverificationmodel.find({'caseid': req.body.caseid, 'fename': req.decoded.id, 'adminid': req.decoded.adminid});
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await officeverificationmodel.findByIdAndDelete(olddata._id);
            const imgolddata = await officeimagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await officeimagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
    const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                return res.status(500).json({ errors: err });
            }
            else{
                const residata = new officeverificationmodel({ 
                    leadid: docs.leadid,
                    
                    ddaid: docs.ddaid,
                    guarantorname: docs.guarantorname,
                  
                    location: docs.location,
               
                    
                    caseid: docs._id,
                    applicantname: docs.applicantname,
                    contact: docs.contact,
                    officename: docs.officename,
                    applicantemail: docs.applicantemail,
                    officeaddress: docs.permanentaddress,
                    landmark: docs.permanentaddress,
                    co_applicantname: docs.co_applicantname,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                    city: docs.city,
                    adminid: docs.adminid,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    formtype: docs.formtype,
                    fename: req.decoded.fename,
                    feid: req.decoded.id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven: req.body.ufeleven,
                    uftwelve: req.body.uftwelve,
                    ufthirteen: req.body.ufthirteen,
                    uffourteen: req.body.uffourteen,
                    uffifteen: req.body.uffifteen,
                    ufsixteen: req.body.ufsixteen,
                    ufseventeen: req.body.ufseventeen,
                    ufeighteen: req.body.ufeighteen,
                    ufnineteen: req.body.ufnineteen,
                    uftwenty: req.body.uftwenty,
                    uftwentyone: req.body.uftwentyone,
                    uftwentytwo: req.body.uftwentytwo,
                    uftwentythree: req.body.uftwentythree,
                    uftwentyfour: req.body.uftwentyfour,
                    uftwentyfive: req.body.uftwentyfive,
                    uftwentysix: req.body.uftwentysix,
                    uftwentyseven: req.body.uftwentyseven,
                    uftwentyeight: req.body.uftwentyeight,
                    uftwentynine: req.body.uftwentynine,
                    ufthirty: req.body.ufthirty,
                    ufthirtyone: req.body.ufthirtyone,
                    ufthirtytwo: req.body.ufthirtytwo,
                    ufthirtythree: req.body.ufthirtythree,
                    ufthirtyfour: req.body.ufthirtyfour,
                    ufthirtyfive: req.body.ufthirtyfive,
                    ufthirtysix: req.body.ufthirtysix,
                    ufthirtyseven: req.body.ufthirtyseven,
                    ufthirtyeight: req.body.ufthirtyeight,
                    ufthirtynine: req.body.ufthirtynine,
                    ufforty: req.body.ufforty,
                    uffortyone: req.body.uffortyone,
                    uffortytwo: req.body.uffortytwo,
                    uffortythree: req.body.uffortythree,
                    uffortyfour:req.body.uffortyfour,
                    uffortyfive:req.body.uffortyfive,
                    uffortysix:req.body.uffortysix,
                    uffortyseven:req.body.uffortyseven,
                    uffortyeight:req.body.uffortyeight,
                    uffortynine:req.body.uffortynine,
                    uffifty:req.body.uffifty,
                    uffiftyone:req.body.uffiftyone,
                    uffiftytwo:req.body.uffiftytwo,
                    feremark:req.body.feremark,
                  
                });
                const resisaveddata =await residata.save();
                    req.files.CarDealer.map((cv, ind, arr)=>{
                    req.files.CarDealer[ind].caseid=req.body.caseid;
                    req.files.CarDealer[ind].fecode=req.decoded.id;
                    req.files.CarDealer[ind].reportid=resisaveddata._id;
                    req.files.CarDealer[ind].image=`images/uploads/cases/uploads/${req.decoded.adminid}/physicalcases/CarDealer/${datefolder}/${arr[ind].filename}`;
                    });
                    officeimagesModel.insertMany(req.files.CarDealer);
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'4',fedonedate:new Date(),});
            }
        });
        return res.status(200).json({ success: 'Case Completed' });
      }catch(err){
        return res.status(500).json({ errors: err });
      }  
});


module.exports = router;
