var createError = require('http-errors');
var express = require('express');
var path = require('path');
var session = require('express-session');
const passport = require('passport');
var flash = require('connect-flash');
var cookieParser = require('cookie-parser');
let jwt = require('jsonwebtoken');
 global.config = require('./config/jwtconfig');
var logger = require('morgan');
var mongoose = require('mongoose');
mongoose.set('strictQuery', true);
var app = express();

// some constant value
const dbUrl = "mongodb://127.0.0.1:27017/vbdigital";
const appAuthCode='4561';

//global Variable
global.imageBaseDir = '/home/sbfasto/verification.srbcomputers.com/public/';

mongoose.connect(dbUrl, {useNewUrlParser:true});
const con= mongoose.connection;
con.on('open', ()=> {
  console.log('Database Connected');
});

// Session configuration
app.use(session({
  secret: 'vbdigital1222frommumbai',
  resave: false,
  saveUninitialized: false
}));

// Initialize Passport
app.use(passport.initialize());
app.use(passport.session());


var homeRouter = require('./controllers/home');
var indexRouter = require('./controllers/index');
var dashboardRouter = require('./controllers/admin/dashboard');
var operationRouter = require('./routes/admin-operation');
var femanagementRouter = require('./routes/admin-fe');
var corporateclientRouter = require('./controllers/admin/corporateclient');
var digitalverificationRouter = require('./controllers/admin/digitalverification');

//physical Verification
var physicalofficeverificationRouter = require('./controllers/admin/physicalverification/office');
var physicalbusinessverificationRouter = require('./controllers/admin/physicalverification/business');
var physicalemploymentverificationRouter = require('./controllers/admin/physicalverification/employment');
var physicalresidenceverificationRouter = require('./controllers/admin/physicalverification/residence');
var physicalbankstatementverificationRouter = require('./controllers/admin/physicalverification/bankstatement');
var physicalsalarypayslipverificationRouter = require('./controllers/admin/physicalverification/salarypayslip');
var physicalitrverificationRouter = require('./controllers/admin/physicalverification/itr');
var physicalteleverificationRouter = require('./controllers/admin/physicalverification/tele');

//end physical verification
var attendencerouter = require('./controllers/admin/attendencecontroller');
//tracking
var trackingRouter = require('./controllers/admin/tracking');
var summaryRouter = require('./controllers/admin/summary');
var pdfRouter = require('./controllers/admin/pdf/index');
//ot
var operationteamRouter = require('./controllers/operation/index');
var hrteamRouter = require('./controllers/hr/index');
var OTRouter = require('./routes/operationteam');
var otcasesRouter = require('./routes/otcasesRouter');
var summaryotRouter =  require('./controllers/operation/summary');

var userAPIRouter = require('./apis/users');
var ApplicantRouter = require('./controllers/applicant');

var FEapiRouter = require('./routes/feroute');
var FEapisubmitRouter = require('./apis/FEverification');



//parser
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// view engine setup
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'ejs');

app.use(logger('dev'));
app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));


// flash session for messages

app.use(flash());

app.all('*',function(req, res, next) {
  res.header("Access-Control-Allow-Origin", "*");
  res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
  next();
});

app.use('/', homeRouter);
app.use('/login', indexRouter);
app.get('/logout', (req, res, next) => {
  req.session.destroy();
  res.redirect('/login');
});

// middleware for route starting from "/auth"
app.use('/auth', function (req, res, next) {
  if (req.isAuthenticated()) {
      res.locals.user = req.user;
    next();
  } else {
    res.redirect('/login');
  }
});

app.use('/auth/dashboard', dashboardRouter);
app.use('/auth/operation', operationRouter);
app.use('/auth/ot/summary', summaryotRouter);
app.use('/auth/hrteam', hrteamRouter);
app.use('/auth/femanagement', femanagementRouter);
app.use('/auth/corporateclient', corporateclientRouter);
app.use('/auth/digitalverification', digitalverificationRouter);
app.use('/auth/physicalverification/office', physicalofficeverificationRouter);
app.use('/auth/physicalverification/business', physicalbusinessverificationRouter);
app.use('/auth/physicalverification/employment', physicalemploymentverificationRouter);
app.use('/auth/physicalverification/residence', physicalresidenceverificationRouter);
app.use('/auth/physicalverification/bankstatement', physicalbankstatementverificationRouter);
app.use('/auth/physicalverification/salarypayslip', physicalsalarypayslipverificationRouter);
app.use('/auth/physicalverification/itr', physicalitrverificationRouter);
app.use('/auth/physicalverification/tele', physicalteleverificationRouter);
app.use('/auth/attendence', attendencerouter);
app.use('/auth/pdf', pdfRouter);
app.use('/auth/tracking', trackingRouter);
app.use('/auth/summary', summaryRouter);
app.use('/superadmin', require('./controllers/superadmin'));
//ot
app.use('/auth/operationteam', operationteamRouter);
app.use('/auth/ot', OTRouter);
app.use('/auth/ot/otcases', otcasesRouter);
//api
app.use('/api/user', userAPIRouter);
app.use('/Digital/Applicant', ApplicantRouter);
app.use('/API/FE/submit', FEapisubmitRouter);
app.use('/API/FE', FEapiRouter);
app.locals.baseURL = "https://verification.srbcomputers.com/";
// catch 404 and forward to error handler
app.use(function(req, res, next) {
  next(createError(404));
});

// error handler
app.use(function(err, req, res, next) {
  // set locals, only providing error in development
  res.locals.message = err.message;
  res.locals.error = req.app.get('env') === 'development' ? err : {};
  // render the error page
  res.status(err.status || 500);
  res.render('error');
});

module.exports = app;