var express = require('express');
var router = express.Router();
var otmodel= require('../../models/User');
var femodel= require('../../models/feteam');
var feattendence= require('../../models/feattendence');
var sessionCheck= require('../../middleware/sessionCheck').isAdmin;
const fs = require('fs');
const schedule = require('node-schedule');
const getDaysInMonth = async (date) => {
  const daysInMonth = new Date(date.getFullYear(), date.getMonth() + 1, 0).getDate();
  return daysInMonth;
};

router.get('/', sessionCheck, async (req, res, next) => {
  const userID = req.user._id;
  const date = new Date();
  const currentYear = date.getFullYear();
  const currentMonth = date.getMonth(); //  months are 0-based
  // ️ Current Month
  const daysInMonth = await getDaysInMonth(new Date(currentYear, currentMonth));

  try {
        const pipeline = [
      {
        $match: {
          createdAt: {
            $gte: new Date(new Date().getFullYear(), new Date().getMonth(), 1),
          },
        },
      },
       {
    $sort: {
      _id: -1, // Replace '_' with the field you want to sort by
    },
  },
 
    ];

    const result = await feattendence.aggregate(pipeline);
    console.log(result);
    res.render('admin/attendence', { title: 'VB-Digital', result, daysInMonth });
  } catch (err) {
    console.error(err);
    res.status(500).send('An error occurred');
  }
});

const updateAttendance = () => {
  const today = new Date();
  today.setHours(23, 59, 59, 999);

  const yesterday = new Date(today);
  yesterday.setDate(yesterday.getDate() - 1);

  const dayBeforeYesterday = new Date(today);
  dayBeforeYesterday.setDate(dayBeforeYesterday.getDate() - 2);

  feattendence.updateMany(
    {
      $and: [
        { tat: { $exists: false } },
        { starttime: { $exists: true, $ne: null } },
        { starttime: { $lte: new Date(Date.now() - 600 * 60 * 1000) } },
        { createdAt: { $gte: dayBeforeYesterday, $lte: today } }
      ]
    },
    {
      $set: {
        tat: 600,
        endtime: new Date(Date.now() + 600 * 60 * 1000)
      }
    }
  ).then(result => {
    console.log(result.modifiedCount + ' documents updated');
  }).catch(error => {
    console.error(error);
  });
};

const job = schedule.scheduleJob('* * * * *', () => {
  console.log('Updating attendance...');
  updateAttendance();
});


module.exports = router;