var express = require('express');
var router = express.Router();
var clientModel= require('../../models/CorporateClients');
var sessionCheck= require('../../middleware/sessionCheck');
const fs = require('fs');

// multer start
const multer = require("multer");
let storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const adminID = req.user._id;
    const dest = imageBaseDir+'images/uploads/clients/'+adminID;
    fs.mkdirSync(dest, { recursive: true })
        cb(null, dest);
  },
  filename: function (req, file, cb) {
    let extArray = file.mimetype.split("/");
    let extension = extArray[extArray.length - 1];
    cb(null, file.fieldname + '-' + Date.now()+ '.' +extension)
  }
});
const upload = multer({ storage: storage });
// multer end

router.get('/',sessionCheck.isAdmin, async function(req, res, next) {
  
  const userID = req.user._id;
  try{
    const viewDatas= await clientModel.find({'adminid':userID}).exec();
    res.render('admin/client/index', { title: 'Client List', viewDatas, getData:null });
  }catch(err){
    console.log('Data Not Fetched');
  }
});

// Create client 
router.get('/create_client',sessionCheck.isAdmin, async function(req, res, next) {
    
    const userID = req.user._id;
    res.render('admin/client/create', { title: 'Create Client', getData:null, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});
});

/* to insert client data */
router.post('/create_client/add',sessionCheck.isAdmin, upload.single('appLogo'), async function(req, res, next) {
 
  
  const userID = req.user._id;
   const url = `images/uploads/clients/${userID}/${req.file.filename}`;
  let sendData= new clientModel({
    BankName: req.body.BankName,
    name: req.body.name,
    password: req.body.password,
    email: req.body.email,
    contact: req.body.contact,
    address: req.body.address,
    adminid: userID,
    formtype: req.body.formtype,
    logo: url,
  })
  try{
    const a1= await sendData.save();
    req.flash('success_msg', 'Successfully Inserted!!');
    res.redirect('/auth/corporateclient');
  }catch(err){
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/corporateclient/create_client');
  }
});

/* to display edit detail data */
router.get('/create_client/edit/:dataId',sessionCheck.isAdmin, async function(req, res, next) {
  let dataId= req.params.dataId;
  
 
  const userID = req.user._id;
  try{
    const getData = await clientModel.findById(dataId).where({'adminid':userID}).exec();
    res.render('admin/client/create', { title: 'Create Admin', getData, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});
  }catch(err){
    console.log('Data Not Fetched ', err);
    res.redirect('/logout');
  }
});

/* to update client data */
router.post('/create_client/update/:dataId',sessionCheck.isAdmin, upload.single('appLogo'), async function(req, res, next) {
  let dataId= req.params.dataId;
  
  const userID = req.user._id;
  try{
    const getData = await clientModel.findById(dataId).where({'adminid':userID}).exec();
    if(typeof req.file === 'undefined'){
          appLogoStr= getData.logo;
    }else{
          appLogoStr=`images/uploads/clients/${userID}/${req.file.filename}`;
          if(getData.logo != '' && getData.logo != null && getData.logo != undefined){
            if (fs.existsSync(imageBaseDir+getData.logo)) {
              fs.unlinkSync(imageBaseDir+getData.logo);
            }
          }
    }
    const a1= await clientModel.findByIdAndUpdate(dataId, {
    BankName: req.body.BankName,
    name: req.body.name,
    password: req.body.password,
    email: req.body.email,
    contact: req.body.contact,
    address: req.body.address,
    formtype: req.body.formtype,
    logo: appLogoStr,
    });
    req.flash('success_msg', 'Successfully Updated!!');
    res.redirect('/auth/corporateclient');
  }catch(err){
    console.log('Data Not Inserted', err);
  }
});

/* Change User Status */
router.get('/update-status/:id',sessionCheck.isAdmin, async function(req, res, next) {
  
  const userID = req.user._id;
  var dataId=req.params.id; 
  try{
    const viewDatas= await clientModel.find({'_id':dataId}).where({'adminid':userID}).exec();
    if(viewDatas.length!=0){
      var statusKey= viewDatas[0].status;
      var newStatusKey='';
      // res.send( statusKey);
      if(statusKey == 'Active'){
        newStatusKey= 'Inactive';
      }else{
        newStatusKey= 'Active';
      }
      const updateData= await clientModel.findOneAndUpdate({'_id':dataId,'adminid':userID}, {'status':newStatusKey});
    }
    res.redirect('/auth/corporateclient');
  }catch(err){
    console.log('Data Not Fetched');
  }
});





module.exports = router;