var express = require('express');
var router = express.Router();
var adminModel= require('../../models/User');
const fs = require('fs');
var sessionCheck= require('../../middleware/sessionCheck').isAdmin;
var verificationModel= require('../../models/physicalverification/caselist');
// multer start
const multer = require("multer");
const  moment = require('moment');

let storage = multer.diskStorage({
  destination: function (req, file, cb) {

    const adminID = req.user._id;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/OT/'+datefolder;
    fs.mkdirSync(dest, { recursive: true })
        cb(null, dest);
  },
  filename: function (req, file, cb) {
    let extArray = file.mimetype.split("/");
    let extension = extArray[extArray.length - 1];
    cb(null, file.fieldname + '-' + Date.now()+ '.' +extension)
  }
});
const upload = multer({ storage: storage });
// multer end

/* GET dashboard page. */
router.get('/',sessionCheck, async function(req, res, next) {
    var month = new Date().getMonth();
    var year = new Date().getFullYear();
    const start = new Date(year, month, 1).setHours(0, 0, 1);
    const end = new Date(year, month + 1, 0).setHours(23, 59, 59);
    const adminID=req.user._id;
    try{
        
        var data ={};
            data.mpending = await verificationModel.find({'adminid':adminID, 'status': { $gt: 0, $lt:6}, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments();
            data.tpending = await verificationModel.find({'adminid':adminID, 'status': { $gt: 0, $lt:6}, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments();
            data.mcomplete = await verificationModel.find({'adminid':adminID, 'status':6, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments();
            data.tcomplete = await verificationModel.find({'adminid':adminID, 'status':6, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments();
            data.mcancel = await verificationModel.find({'adminid':adminID, 'status':7, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments();
            data.tcancel = await verificationModel.find({'adminid':adminID, 'status':7, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments();
            data.mtotal = await verificationModel.find({'adminid':adminID, 'status': { $gt: 0, $lt:7}, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments();
            data.ttotal = await verificationModel.find({'adminid':adminID, 'status': { $gt: 0, $lt:7}, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments();
            
        res.render('admin/dashboard', { title: 'VB-Digital',data:data, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});  
    }catch(err){
        res.render('admin/dashboard', { title: 'VB-Digital',  alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});  
    }
});
router.get('/festates',sessionCheck, async function(req, res, next) {
    var month = new Date().getMonth();
    var year = new Date().getFullYear();
    const start = new Date(new Date(year, month, 1).setHours(0, 0, 1));
    const end = new Date(new Date(year, month + 1, 0).setHours(23, 59, 59));
    const adminID=req.user._id;
    try{
        const data = await verificationModel.aggregate([
            {
            $match:{"adminid" :adminID,'status':{ $gt: 3, $lt:7},'createdAt': { $gt:start, $lt:end},'fename': { $ne: null }}
            },
            {
            $facet: {
              "categorizedBycasecount": [
                {
                  $unwind: "$fename"
                },
                {
                  $sortByCount: "$fename"
                },
                {$limit:5},
              ]
            }
            }
        ]);
         var data_arr = [];
        data[0].categorizedBycasecount.forEach(function(row, index){
        data_arr.push({
            'indexing' : index + 1,
            'name' : row._id,
            'totalcase' : row.count,
            });
        });
    var output = {
            'aaData' : data_arr
        };
    res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
    
});    
router.get('/otstates',sessionCheck, async function(req, res, next) {
     var month = new Date().getMonth();
    var year = new Date().getFullYear();
    const start = new Date(new Date(year, month, 1).setHours(0, 0, 1));
    const end = new Date(new Date(year, month + 1, 0).setHours(23, 59, 59));
    const adminID=req.user._id;
    try{
        const data = await verificationModel.aggregate([
            {
            $match:{'adminid':adminID, 'status':6,'createdAt': { $gt:start, $lt:end},'otname': { $ne: null }}
            },
            {
            $facet: {
              "categorizedBycasecount": [
                {
                  $unwind: "$otname"
                },
                {
                  $sortByCount: "$otname"
                },
                {$limit:5},
              ]
            }
            }
        ]);
  
        var data_arr = [];
        data[0].categorizedBycasecount.forEach(function(row, index){
        data_arr.push({
            'indexing' : index + 1,
            'name' : row._id,
            'totalcase' : row.count,
            });
        });
        
    var output = {
                   
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
    
});   

router.get('/dailycases',sessionCheck, async function(req, res, next) {
     try{
// Define the day labels in descending order from today
const labels = [];
const todayIndex = moment().day(); // Sunday is day 0
for (let i = 0; i < 7; i++) {
  const index = (todayIndex - i + 7) % 7;
  labels.push(['SU', 'MO', 'TU', 'WE', 'TH', 'FR', 'SA'][index]);
}

// Start and end date for the last 7 days
const startDate = moment().subtract(6, 'days').startOf('day').toDate();
const endDate = moment().endOf('day').toDate();

// Mongoose aggregation pipeline
const pipeline = [
  {
    $match: {
      Reciveddate: {
        $gte: startDate,
        $lte: endDate
      },
      adminid:req.user._id,
    }
  },
  {
    $group: {
      _id: {
        year: { $year: '$Reciveddate' },
        month: { $month: '$Reciveddate' },
        day: { $dayOfWeek: '$Reciveddate' }
      },
      count: { $sum: 1 }
    }
  },
  {
    $project: {
      _id: {
        $switch: {
          branches: [
            { case: { $eq: ['$_id.day', 1] }, then: 'SU' },
            { case: { $eq: ['$_id.day', 2] }, then: 'MO' },
            { case: { $eq: ['$_id.day', 3] }, then: 'TU' },
            { case: { $eq: ['$_id.day', 4] }, then: 'WE' },
            { case: { $eq: ['$_id.day', 5] }, then: 'TH' },
            { case: { $eq: ['$_id.day', 6] }, then: 'FR' },
            { case: { $eq: ['$_id.day', 7] }, then: 'SA' }
          ]
        }
      },
      count: 1
    }
  }
];

// Execute the pipeline
verificationModel.aggregate(pipeline)
  .exec((err, result) => {
    if (err) {

    } else {
      // Transform the output into the format you need
      const salesData = labels.map(label => {
        const match = result.find(r => r._id === label);
        return match ? match.count : 0;
      });
      const output = { labels: labels.reverse(), salesData: salesData.reverse() };
 
      res.json(output);
    }
  });
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
    
});  

router.get('/monthcases',sessionCheck, async function(req, res, next) {
 try {
  // Define the month labels in descending order from this month
  const labels = [];
  const labels2 = [];
const thisMonthIndex = moment().month(); // Assume today is in January, so thisMonthIndex = 0
for (let i = 11; i >= 0; i--) {
  const index = (thisMonthIndex - i + 12) % 12;
  labels.push(['J','F','M','A','M','J','J','A','S','O','N','D'][index]);
  labels2.push(['01','02','03','04','05','06','07','08','09','10','11','12'][index]);
}


  // Start and end date for the last 12 months
  const startDate = moment().subtract(11, 'months').startOf('month').toDate();
  const endDate = moment().endOf('month').toDate();

  // Mongoose aggregation pipeline
  const pipeline = [
    {
      $match: {
        Reciveddate: {
          $gte: startDate,
          $lte: endDate
        },
        adminid:req.user._id,
      }
    },
    {
      $group: {
        _id: {
          year: { $year: '$Reciveddate' },
          month: { $month: '$Reciveddate' }
        },
        count: { $sum: 1 }
      }
    },
    {
      $project: {
        _id: {
          $dateToString: {
            format: '%m',
            date: { $dateFromParts: { year: '$_id.year', month: '$_id.month', day: 1 } }
          }
        },
        count: 1
      }
    }
  ];

  // Execute the pipeline
  verificationModel.aggregate(pipeline)
    .exec((err, result) => {
      if (err) {
        console.log(err);
      } else {
     
        // Transform the output into the format you need
        const salesData = labels2.map(label => {
          const match = result.find(r => r._id === label);
          return match ? match.count : 0;
        });
        const output = { labels: labels,labels2: labels2, salesData: salesData };
   
        res.json(output);
      }
    });
} catch (err) {
  console.log('Data Not Fetched Error:' + err);
}

    
});     
/*To get profile data*/
router.get('/profile',sessionCheck, async function(req, res, next) {
    const userID = req.user._id;
    try{
    const userdata = await adminModel.findById(userID).exec();
    res.render('admin/profile', { title: 'VB-Digital',userdata,  alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});
    }catch(err){
      req.flash('error_msg', 'Failed to update!! ' + err);
      res.redirect('/admin/dashboard');
    }
});

/* to update video data */
router.post('/profile/update',sessionCheck, upload.single('adminImage'), async function(req, res, next) {
    const userID = req.user._id;
    try{
      const getData = await adminModel.findById(userID).exec();
    if(typeof req.file === 'undefined'){
          profileimg= getData.adminImage;
        }else{
          profileimg=`images/uploads/cases/uploads/${userID}/OT/${datefolder}/${req.file.filename}`
          if(getData.adminImage != '' && getData.adminImage != null && getData.adminImage != undefined){
            if (fs.existsSync(imageBaseDir+getData.adminImage)) {
              fs.unlinkSync(imageBaseDir+getData.adminImage);
            }
         }
        }
      const a1= await adminModel.findByIdAndUpdate(userID, {
        // username: req.body.username,
        password: req.body.password,
        name: req.body.name,
        // email: req.body.email,
        // contact: req.body.contact,
        address: req.body.address,
        adminImage: profileimg,
      });
      console.log('data update', a1)
      req.flash('success_msg', 'Successfully Updated!!');
      res.redirect('/auth/dashboard/profile');
    }catch(err){
      req.flash('error_msg', 'Failed to update!! ' + err);
      res.redirect('/auth/dashboard/profile');
    }
});

module.exports = router;