var express = require('express');
var router = express.Router();
var EAVerificationModel= require('../../models/EAVerification');
var bank= require('../../models/CorporateClients');
var sessionCheck= require('../../middleware/sessionCheck').isAdmin;
const fs = require('fs');
const excelToJson = require('convert-excel-to-json');
// multer start
const multer = require("multer");

let storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const adminID = req.body.adminID;
    const Bank = req.body.bankID;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/'+Bank+'/digitalexcel/'+datefolder;
    fs.mkdirSync(dest, { recursive: true })
        cb(null, dest);
  },
  filename: function (req, file, cb) {
    let extArray = file.mimetype.split("/");
    let extension = extArray[extArray.length - 1];
    cb(null, file.fieldname + '-' + Date.now()+ '.' +extension)
  }
});
const upload = multer({ storage: storage });

// multer end
router.get('/',sessionCheck, async function(req, res, next){
  try{
    res.render('admin/digitalverification/index', { title: 'Case List', getData:null, page:'Uploaded' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});
router.get('/data',sessionCheck, async function(req, res, next){
    var result = await paginatedResults(req, 1);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'contact' : row.contact,
            'permanentaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'formtype' : row.formtype,
            'action' : '<a href="/auth/digitalverification/delete_case/'+row._id+'" class="btn btn-danger" role="button" title="CANCELLED"><i class="material-icons option-icon">close</i></a>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
});
router.get('/assigned',sessionCheck, async function(req, res, next){
  try{
    res.render('admin/digitalverification/assigned', { title: 'Case List', getData:null, page:'Assigned' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});
router.get('/link_send',sessionCheck, async function(req, res, next){
  try{
    res.render('admin/digitalverification/link_send', { title: 'Case List', getData:null, page:':Lent Send' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});
router.get('/done_by_applicant',sessionCheck, async function(req, res, next){
  try{
    res.render('admin/digitalverification/done_by_applicant', { title: 'Case List', getData:null, page:'Done by Applicant' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});
router.get('/completed',sessionCheck, async function(req, res, next){
  try{
    res.render('admin/digitalverification/completed', { title: 'Case List', getData:null, page:'Completed' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});
router.get('/cancelled',sessionCheck,  async function(req, res, next){
  
  try{
    res.render('admin/digitalverification/cancelled', { title: 'Case List', getData:null, page:'Cancelled' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});
// pagination function
async function paginatedResults(req,status) {
    console.log(status);
    var results = {}
    var adminID=req.user._id;
    var draw = req.query.draw;
    results.draw =draw;
    var startIndex = parseInt(req.query.start);
    var limit = parseInt(req.query.length);
    var order_data = req.query.order;
    const search_value = req.query.search['value'];
    let sortObj = {};
        if (order_data) {
        const column_index = req.query.order[0]['column'];
        const column_name = req.query.columns[column_index]['data'];
        const column_sort_order = req.query.order[0]['dir'];
        sortObj[column_name] = column_sort_order;
        } else {
        sortObj = { _id: 'desc' };
        }
        results.total_records= await EAVerificationModel.find({'adminid':adminID}).countDocuments();
        if(!search_value){
        results.total_filter_records =parseInt(results.total_records);
        results.data = await EAVerificationModel.find({ adminid: adminID},{  _id: 1, applicantname: 1, contact: 1, permanentaddress: 1, permanentpincode: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        }else{
        results.data = await EAVerificationModel.find({ adminid: adminID, $text: {$search: search_value}},{  _id: 1, applicantname: 1, contact: 1, permanentaddress: 1, permanentpincode: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        results.total_filter_records = await EAVerificationModel.find({ adminid: adminID, $text: {$search: search_value}}).countDocuments(); 
        }
    return results;
}
// Create cases 
router.get('/create_case',sessionCheck, async function(req, res, next) {
    const adminID=req.user._id;
    try{
    const viewDatas= await bank.find({'adminid':adminID}, '_id BankName').sort('BankName').exec();
    if(viewDatas == null || viewDatas == ''){
        req.flash('error_msg', 'Please Add Bank!!');
        res.redirect('/auth/corporateclient');
    }
    res.render('admin/digitalverification/create', { title: 'Create Admin', viewDatas,adminID, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});
    }catch(err){
    console.log('Data Not Fetched');
  }
});

/* Download Format*/
router.get('/Download_Format/:adminID/:format',sessionCheck, function(req, res, next){
  const dest = imageBaseDir+'images/uploads/cases/format/digitalformat/'+req.params.format+'n.xlsx';
res.download(dest);
});

/* to insert admin data */
router.post('/create_case/add',sessionCheck, upload.single("uploadfile"), async function(req, res, next) {
    const adminID = req.body.adminID;
    const Bank = req.body.bankID;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/'+Bank+'/digitalexcel/'+datefolder+'/'+req.file.filename;
    const bankname= await bank.findOne({'_id':Bank}, 'BankName _id');
    const excelData = excelToJson({sourceFile: dest,
    sheets:[{
    // Excel Sheet Name
    name: 'Sheet1',
    // Header Row -> be skipped and will not be present at our result object.
    header:{
    rows: 1
    },
    // Mapping columns to keys
    columnToKey: {
    B: 'leadid',
    C: 'applicantname',
    D: 'contact',
    E: 'permanentaddress',
    F: 'permanentpincode',
    G: 'city',
    
    }
    }]
    });
    excelData.Sheet1.map((cv, ind, arr)=>{
    excelData.Sheet1[ind].adminid=adminID;
    excelData.Sheet1[ind].bankid=Bank;
    excelData.Sheet1[ind].bankname=bankname.BankName;
    excelData.Sheet1[ind].uploader=req.user._id;
    excelData.Sheet1[ind].formtype="format1";
    excelData.Sheet1[ind].Reciveddate=req.body.Reciveddate;
    });
  try{
      EAVerificationModel.insertMany(excelData.Sheet1,function(error, docs) {
    if(error){
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/digitalverification/create_case');
    }
   });
    req.flash('success_msg', 'Successfully Inserted!!');
    res.redirect('/auth/digitalverification');
  }catch(err){
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/digitalverification/create_case');
  }
});

module.exports = router;