var feteam= require('../../models/feteam');
var sessionCheck= require('../../middleware/sessionCheck');
const fs = require('fs');

exports.getindex = async (req, res, next) => {
   const userID = req.user._id;
  try{
       const data = await feteam.find({"admin_id": userID}).exec();
    res.render('admin/feteam/index', { title: 'FE List', viewDatas:null, getData:data });
  }catch(err){
    console.log('Data Not Fetched:',err);
  }
};

exports.addfe = async (req, res, next) => {
  const userID = req.user._id;
    const event = new Date();
    const datefolder = event.toDateString();
  const url = `images/uploads/cases/uploads/${userID}/FE/${datefolder}/${req.file.filename}`
  let fedata= new feteam({
    name: req.body.name,
    password: req.body.password,
    email: req.body.email,
    contact: req.body.contact,
    alternative_contact: req.body.alternative_contact,
    address: req.body.address,
    admin_id: userID,
    description: req.body.description,
    profile: url,
  })
  try{
    const a1= await fedata.save();
    req.flash('success_msg', 'Successfully Inserted!!');
    res.redirect('/auth/femanagement/index');
  }catch(err){
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/femanagement/create');
  }
};
exports.updatestatus = async (req, res, next) => {
  const userID = req.user._id;
  var dataId=req.params.id;
  try{
      const viewDatas= await feteam.findOne({'_id':dataId}).where({'admin_id':userID}).exec();
    if(viewDatas){
      var statusKey= viewDatas.status;
      var newStatusKey='';
      if(statusKey == 'Active'){
        newStatusKey= 'Inactive';
      }else{
        newStatusKey= 'Active';
      }
      const updateData= await feteam.findOneAndUpdate({'_id':dataId,'admin_id':userID}, {'status':newStatusKey,'jwttoken':'logout'});
    }
    res.redirect('/auth/femanagement/index');
  }catch(err){
    console.log('Data Not Fetched:',err);
    res.redirect('/logout');
  }
};

exports.edit = async (req, res, next) => {
  let dataId= req.params.id;
  const userID = req.user._id;
  try{
    const getData = await feteam.findById(dataId).where({'admin_id':userID}).exec();
    res.render('admin/feteam/create', { title: 'Create Admin', getData, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});
  }catch(err){
    console.log('Data Not Fetched ', err);
    res.redirect('/logout');
  }
};
exports.update = async (req, res, next) => {
  let dataId= req.params.id;
  const userID = req.user._id;
  const event = new Date();
const datefolder = event.toDateString();
  try{
    var getData = await feteam.findOne({'_id':dataId}).where({'admin_id':userID}).exec();
    if(getData){
        if(!req.files || Object.keys(req.files).length === 0){
          profileimg= getData.profile;
          digitalidimg= getData.digitalid;
    }else{
        if(req.files.profile){
          
          profileimg=`images/uploads/cases/uploads/${userID}/FE/${datefolder}/${req.files.profile[0].filename}`
          if(getData.profile != '' && getData.profile != null && getData.profile != undefined){
            if (fs.existsSync(imageBaseDir+getData.profile)) {
              fs.unlinkSync(imageBaseDir+getData.profile);
            }
         }
        }else{
          profileimg= getData.profile;
        }
        if(req.files.digitalid){
          
          digitalidimg=`images/uploads/cases/uploads/${userID}/FE/${datefolder}/${req.files.digitalid[0].filename}`
          if(getData.digitalid != '' && getData.digitalid != null && getData.digitalid != undefined){
            if (fs.existsSync(imageBaseDir+getData.digitalid)) {
              fs.unlinkSync(imageBaseDir+getData.digitalid);
            }
         }
        }else{
          digitalidimg= getData.digitalid;
        }
    }
    const a1= await feteam.findByIdAndUpdate(dataId, {
    name: req.body.name,
    password: req.body.password,
    email: req.body.email,
    contact: req.body.contact,
    alternative_contact: req.body.alternative_contact,
    address: req.body.address,
    description: req.body.description,
    profile:profileimg,
    digitalid:digitalidimg
    });
    }
    req.flash('success_msg', 'Successfully Updated!!');
    res.redirect('/auth/femanagement/index');
  }catch(err){
    console.log('Data Not Inserted', err);
  }
};
