var express = require('express');
var router = express.Router();
var bank= require('../../../models/CorporateClients');
const sessionCheck= require('../../../middleware/sessionCheck').isAdmin;
var verificationModel= require('../../../models/physicalverification/caselist');
var resiverificationModel= require('../../../models/physicalverification/officecases');
var resiimagesModel= require('../../../models/physicalverification/officeimages');
const fs = require('fs');
const excelToJson = require('convert-excel-to-json');
var feteam= require('../../../models/feteam');
const htmlPdf = require("html-pdf");
const path = require("path");
const ejs = require("ejs");
const moment = require("moment");
// multer start
const multer = require("multer");

let storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const adminID = req.body.adminID;
    const Bank = req.body.bankID;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/'+Bank+'/physicalexcel/business/'+datefolder;
    fs.mkdirSync(dest, { recursive: true })
        cb(null, dest);
  },
  filename: function (req, file, cb) {
    let extArray = file.mimetype.split("/");
    let extension = extArray[extArray.length - 1];
    cb(null, file.fieldname + '-' + Date.now()+ '.' +extension)
  }
});
const upload = multer({ storage: storage });
// multer end
router.get('/',sessionCheck, async function(req, res, next){
  try{
    res.render('admin/physicalverification/business/index', { title: 'Case List', getData:null });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});
router.get('/data',sessionCheck, async function(req, res, next){
   
    var result = await paginatedResults(req, 1);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        console.log(row);
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
           'coapplicantname' : row.co_applicantname,
            'contact' : row.contact,
            'officename' : row.officename,
            'officeaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'formtype' : row.formtype,
            'action' : '<a href="/auth/physicalverification/business/cancele-case/'+row._id+'" class="btn btn-danger" role="button" title="CANCELLED"><i class="material-icons option-icon">close</i></a><a href="/auth/physicalverification/business/assign-case/'+row._id+'" class="btn btn-success" role="button" title="ASSIGN"><i class="material-icons option-icon">move_up</i></a>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
});
async function paginatedResults(req,status) {

    var results = {};
    var adminID=req.user._id;
    var draw = req.query.draw;
    results.draw =draw;
    var startIndex = parseInt(req.query.start);
    var limit = parseInt(req.query.length);
    var order_data = req.query.order;
    const search_value = req.query.search['value'];
    let sortObj = {};
        if (order_data) {
        const column_index = req.query.order[0]['column'];
        const column_name = req.query.columns[column_index]['data'];
        const column_sort_order = req.query.order[0]['dir'];
        sortObj[column_name] = column_sort_order;
        } else {
        sortObj = { _id: 'desc' };
        }
        results.total_records= await verificationModel.find({'adminid':adminID,'status':status,'casetype':'Business'}).countDocuments();
        if(!search_value){
        results.total_filter_records =parseInt(results.total_records);
        results.data = await verificationModel.find({ adminid: adminID,'casetype':'Business',status:status},{  _id: 1, applicantname: 1,officename: 1,co_applicantname: 1, contact: 1, permanentaddress: 1, permanentpincode: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1, fename:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        }else{
        results.data = await verificationModel.find({ adminid: adminID,'casetype':'Business',status:status, $text: {$search: search_value}},{  _id: 1, applicantname: 1,officename: 1,co_applicantname: 1, contact: 1, permanentaddress: 1, permanentpincode: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        results.total_filter_records = await verificationModel.find({ adminid: adminID,'casetype':'Business',status:status, $text: {$search: search_value}}).countDocuments(); 
        }
    return results;
}
async function paginatedassigneddataResults(req,status) {

    var results = {};
    var adminID=req.user._id;
    var draw = req.query.draw;
    results.draw =draw;
    var startIndex = parseInt(req.query.start);
    var limit = parseInt(req.query.length);
    var order_data = req.query.order;
    const search_value = req.query.search['value'];
    let sortObj = {};
        if (order_data) {
        const column_index = req.query.order[0]['column'];
        const column_name = req.query.columns[column_index]['data'];
        const column_sort_order = req.query.order[0]['dir'];
        sortObj[column_name] = column_sort_order;
        } else {
        sortObj = { _id: 'desc' };
        }
        results.total_records= await verificationModel.find({'adminid':adminID,'casetype':'Business',status: { $gt: 1, $lt:4}}).countDocuments();
        if(!search_value){
        results.total_filter_records =parseInt(results.total_records);
        results.data = await verificationModel.find({ adminid: adminID,'casetype':'Business',status: { $gt: 1, $lt:4}},{  _id: 1, applicantname: 1,officename: 1,co_applicantname: 1, contact: 1, permanentaddress: 1, permanentpincode: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1, fename:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        }else{
        results.data = await verificationModel.find({ adminid: adminID,'casetype':'Business',status: { $gt: 1, $lt:4}, $text: {$search: search_value}},{  _id: 1, applicantname: 1,officename: 1,co_applicantname: 1, contact: 1, permanentaddress: 1, permanentpincode: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        results.total_filter_records = await verificationModel.find({ adminid: adminID,'casetype':'Business',status: { $gt: 1, $lt:4}, $text: {$search: search_value}}).countDocuments(); 
        }
    return results;
}

router.get('/assigned',sessionCheck, async function(req, res, next){
  try{
    res.render('admin/physicalverification/business/assigned', { title: 'Case List', getData:null, page:'Assigned' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});
router.get('/assigneddata',sessionCheck, async function(req, res, next){
    var result = await paginatedassigneddataResults(req, 3);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'coapplicantname' : row.co_applicantname,
            'contact' : row.contact,
            'officename' : row.officename,
            'officeaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'fename' : row.fename,
            'action' : '<a href="/auth/physicalverification/business/cancele-case/'+row._id+'" class="btn btn-danger" role="button" title="CANCELLED"><i class="material-icons option-icon">close</i></a><a href="/auth/physicalverification/business/assign-case/'+row._id+'" class="btn btn-success" role="button" title="ASSIGN"><i class="material-icons option-icon">move_up</i></a>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
});
router.get('/done_fe',sessionCheck, async function(req, res, next){
  try{
    res.render('admin/physicalverification/business/done_fe', { title: 'Case List', getData:null, page:':Done By FE' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});
router.get('/done_fedata',sessionCheck, async function(req, res, next){
    var result = await paginatedResults(req, 4);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'coapplicantname' : row.co_applicantname,
            'contact' : row.contact,
            'officename' : row.officename,
            'officeaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'formtype' : row.formtype,
            'action' : '<a href="/auth/physicalverification/business/cancele-case/'+row._id+'" class="btn btn-danger" role="button" title="CANCELLED"><i class="material-icons option-icon">close</i></a><a href="/auth/physicalverification/business/checkdata/'+row._id+'" class="btn btn-success" role="button" title="Data Check"><i class="material-icons option-icon">assignment_turned_in</i></a>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
});
router.get('/done_by_ot',sessionCheck, async function(req, res, next){
  try{
    res.render('admin/physicalverification/business/done_by_ot', { title: 'Case List', getData:null, page:'Done by OT' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});
router.get('/done_by_otdata',sessionCheck, async function(req, res, next){
    var result = await paginatedResults(req, 5);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'coapplicantname' : row.co_applicantname,
            'contact' : row.contact,
            'officename' : row.officename,
            'officeaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'formtype' : row.formtype,
            'action' : '<a href="/auth/physicalverification/business/cancele-case/'+row._id+'" class="btn btn-danger" role="button" title="CANCELLED"><i class="material-icons option-icon">close</i></a>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
});
router.get('/completed',sessionCheck, async function(req, res, next){
  try{
    res.render('admin/physicalverification/business/completed', { title: 'Case List', getData:null, page:'Completed' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});
router.get('/completeddata',sessionCheck, async function(req, res, next){
    var result = await paginatedResults(req, 6);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'coapplicantname' : row.co_applicantname,
            'contact' : row.contact,
            'officename' : row.officename,
            'officeaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'formtype' : row.formtype,
            'action' : '<a href="/auth/physicalverification/business/cancele-case/'+row._id+'" class="btn btn-danger" role="button" title="CANCELLED"><i class="material-icons option-icon">close</i></a>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
});
router.get('/cancelled',sessionCheck,  async function(req, res, next){
  
  try{
    res.render('admin/physicalverification/business/cancelled', { title: 'Case List', getData:null, page:'Cancelled' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});
router.get('/cancelleddata',sessionCheck, async function(req, res, next){
    var result = await paginatedResults(req, 7);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'coapplicantname' : row.co_applicantname,
            'contact' : row.contact,
            'officename' : row.officename,
            'officeaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'formtype' : row.formtype,
            'action' : '<a href="/auth/physicalverification/business/cancele-case/'+row._id+'" class="btn btn-danger" role="button" title="CANCELLED"><i class="material-icons option-icon">close</i></a>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
});
router.get('/cancele-case/:id',sessionCheck,  async function(req, res, next){
  let dataId= req.params.id;
  
  userID=req.user._id;
  try{
     const a1= await verificationModel.findOneAndUpdate({'_id':dataId,'adminid':userID}, {'status':7 });
    res.redirect('back');
  }catch(err){
    console.log('Data Not Fetched');
  }
});
router.get('/assign-case/:id',sessionCheck,  async function(req, res, next){
  let dataId= req.params.id;
  
  userID=req.user._id;
  try{
     const data= await feteam.find({'status':'Active','adminid':userID}).sort({name: 'asc'}).exec();
    res.render('admin/physicalverification/business/assign', { title: 'Case List', getData:data, getId:dataId, page:'Assign' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});
router.post('/assign-case/add',sessionCheck,  async function(req, res, next){
  let dataId= req.body.getId;
  
  userID=req.user._id;
  try{
    const a1= await verificationModel.findOneAndUpdate({'_id':dataId,'adminid':userID}, {'status':2, 'fename':req.body.fename, 'feid':req.body.feid });
    res.redirect('/auth/physicalverification/business/');
  }catch(err){
    console.log('Data Not Fetched');
  }
});

router.get('/checkdata/:id', sessionCheck, async function(req, res, next){
  let dataId= req.params.id;
  
  userID=req.user._id;
  try{
     const data= await resiverificationModel.findOne({'caseid':dataId,'adminid':userID}).exec();
     const image= await resiimagesModel.find({'caseid':dataId,'reportid':data._id}).exec();
    res.render('admin/physicalverification/business/updateform', { title: 'Case List', getData:data, getimage:image, page:'Assign' });
  }catch(err){
    console.log('Data Not Fetched');
  }
});


// Create cases 
router.get('/create_case',sessionCheck, async function(req, res, next) {
    
    const adminID=req.user._id;
    try{
    const viewDatas= await bank.find({'adminid':adminID}, '_id BankName').sort('BankName').exec();
    if(viewDatas == null || viewDatas == ''){
        req.flash('error_msg', 'Please Add Bank!!');
        res.redirect('/auth/physicalverification/business/');
    }
    res.render('admin/physicalverification/business/create', { title: 'Create Admin', viewDatas,adminID, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});
    }catch(err){
    console.log('Data Not Fetched');
  }
});

/* Download Format*/
router.get('/Download_Format/:adminID/:format',sessionCheck, function(req, res, next){
  const dest = imageBaseDir+'images/uploads/cases/format/physicalformat/'+req.params.format+'business.xlsx';
res.download(dest);
});

/* to insert admin data */
router.post('/create_case/add',sessionCheck, upload.single("uploadfile"), async function(req, res, next) {
    const adminID = req.body.adminID;
    const Bank = req.body.bankID;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/'+Bank+'/physicalexcel/business/'+datefolder+'/'+req.file.filename;
    const bankname= await bank.findOne({'_id':Bank}, 'BankName _id');
    const excelData = excelToJson({sourceFile: dest,
    sheets:[{
    // Excel Sheet Name
    name: 'Sheet1',
    // Header Row -> be skipped and will not be present at our result object.
    header:{
    rows: 1
    },
    // Mapping columns to keys
    columnToKey: {
    B: 'leadid',
    C: 'applicantname',
    D: 'co_applicantname',
    E: 'contact',
    F: 'officename',
    G: 'permanentaddress',
    H: 'permanentpincode',
    I: 'city',
    J: 'location'
    
    }
    }]
    });
    excelData.Sheet1.map((cv, ind, arr)=>{
    excelData.Sheet1[ind].adminid=adminID;
    excelData.Sheet1[ind].bankid=Bank;
    excelData.Sheet1[ind].bankname=bankname.BankName;
    excelData.Sheet1[ind].uploader=req.user._id;
    excelData.Sheet1[ind].formtype="format2";
    excelData.Sheet1[ind].casetype="Business";
    excelData.Sheet1[ind].Reciveddate=req.body.Reciveddate;
    });
  try{
      verificationModel.insertMany(excelData.Sheet1,function(error, docs) {
    if(error){
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/physicalverification/business/create_case');
    }
   });
    req.flash('success_msg', 'Successfully Inserted!!');
    res.redirect('/auth/physicalverification/business/');
  }catch(err){
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/physicalverification/business/create_case');
  }
});

router.get('/create_pdf',sessionCheck, async function(req, res, next) {
    try {
        (async () => {
            var fullUrl = req.protocol + '://' + req.get('host');

            let body = req.body;
            let userId = body.user_id;

            let userData = {
                "_id": "6389a5e754d85df90f047bf4",
                "caseid": "63883d804d77c1410b423b99",
                "leadid": "NA",
                "creationDate": "2022-11-30T05:36:00.000Z",
                "address_verified_by_person": "Self",
                "reasonnotconfirmed": "NA",
                "untraceablereason": "NA",
                "untraceablelocality": "NA",
                "resultofcalling": "NA",
                "addressbelong": "NA",
                "conductecat": "Applicant's address",
                "presentvhice": "Na",
                "financed": "Full Time",
                "financername": "Supervisory",
                "financeloanno": "NA",
                "osloan": "NA",
                "employername": "ASCENT CONSULRING SERVICES PVT. LTD",
                "employeraddress": "TOWN CENTER 1, BUILDING 501, 4TH FLOOR, MAROL ANDHERI, ANDHERI-KURLA ROAD, MUMBAI-400059",
                "businessactivity": "NA",
                "deductionok": "NA",
                "taxcalculated": "NA",
                "officename": "ASCENT CONSULRING SERVICES PVT. LTD",
                "officeaddress": "TOWN CENTER 1, BUILDING 501, 4TH FLOOR, MAROL ANDHERI, ANDHERI-KURLA ROAD, MUMBAI-400059",
                "comment_of_exterior": "Good",
                "noofyearsworkedhere": "4 year",
                "transferablejob": "NA",
                "employeeseen": "27 ",
                "premises": "NA",
                "applypreviously": "NA",
                "previousfi": "NA",
                "ease_of_location": "Easy",
                "natureofwork": "Services",
                "candidate_name": "NEETU SINGH",
                "telephoneresi": "9004948584",
                "approxrent": "NA",
                "aproxageofcandi": "NA",
                "approxvalue": "NA",
                "customercontact": "undefined",
                "formno": "No",
                "asset_seen": "NA",
                "applicant_designation": "NA",
                "verified_by_person": "NA",
                "num_of_EDC_terminal": "NA",
                "EDC_acquiring_bank_name": "neetusingh34@gmail.com",
                "nature_business": "Na",
                "alternate_mobile": "41419500",
                "address_tallied": "Yes",
                "identity_proof": "NA",
                "verifiermetby": "Neetu Singh",
                "child": "NA",
                "adult": "No",
                "spousework": "Pvt. Ltd",
                "spouseworkcompney": "Services",
                "ownership": "Rented",
                "areaofpremises": ">1500",
                "nature_of_locality": "Commercial",
                "locality": ">1500",
                "nameplate": ">1500",
                "totalnoofstorybuilding": "Yes",
                "previousemp": "NA",
                "noofyearsprevious": "2002",
                "sector": "Pvt. Ltd",
                "socityboard": "Yes",
                "nearestlandmark1": "Opp Times squre",
                "nearestlandmarktwo": "Opp times squre",
                "status": "Positive",
                "reason": "NA",
                "bankbrance": "02",
                "ourremark": "Our area executive visited on provided address and met Applicant Ms. NEETU SINGH . She has shared office related information and required documents. Applicant is working here  since last 4 years and also confirmed with colleagues.",
                "photoofdoc": "Yes",
                "fe_code": "SBFE0000019",
                "fename": "Ganesh Gaikwad",
                "createdAt": "2022-12-02T07:14:47.240Z",
                "updatedAt": "2022-12-02T09:57:39.189Z",
                "__v": 0,
                "final_adminremark": "Sachin Kumar Soni",
                "finalstatus": "Done -Positive"
            };

            userData.visitedDate = moment(userData.creationDate).format('DD-MM-YYYY');
            userData.visitedTime = moment(userData.creationDate).format('HH:mm:ss');
            userData.signature = `${fullUrl}/signature.png`;

            ejs.renderFile(path.join(__dirname, '../../../', 'templates', 'defaultbusiness.ejs'), userData, {}, function (err, html) {
                if (err) {
                    console.log(err)
                    return res.send({
                        "success": false,
                        "message": err,
                        "data": null
                    })
                }

                // Generate HTML to PDF
                let options = {
                    format: "A4", // allowed units: A3, A4, A5, Legal, Letter, Tabloid
                    orientation: "portrait", // portrait or landscape
                    header: {
                        height: "20px",
                     
                    },
                    footer: {
                        height: "10px",
                    },
                };
                htmlPdf.create(html, options).toStream(async (err, stream) => {
                    if (err) {
                        return res.json({
                            "success": false,
                            "message": "Something went wrong",
                            "data": null,
                            "error": err
                        });
                    } else {
                        res.set("Content-type", "application/pdf");
                        stream.pipe(res);
                    }
                });
            });
        })();
    } catch (err) {
        return res.json({
            "success": false,
            "message": "Something went wrong",
            "data": null
        })
    }
});

module.exports = router;