var targetModel= require('../../models/sales_target');
var bwtargetModel= require('../../models/sales_targetbw');
var sessionCheck= require('../../middleware/sessionCheck');
var clientModel= require('../../models/CorporateClients');
const  moment = require('moment');

exports.getindex = async (req, res, next) => {
   const userID = req.user._id;
  try{
       const data = await targetModel.find({"admin_id": userID}).sort({ tagetdate: -1 }).exec();
    res.render('admin/salestarget/index', { title: 'Sales Target List', viewDatas:null, getData:data });
  }catch(err){
    console.log('Data Not Fetched:',err);
  }
};
exports.addtarget = async (req, res, next) => {
  const userID = req.user._id;

  // Extract month and year from tagetdate
  const tagetDate = new Date(req.body.tagetdate);
  const targetMonth = tagetDate.getMonth();
  const targetYear = tagetDate.getFullYear();

  try {
    // Check if there is already an entry for the same month and year
    const existingData = await targetModel.findOne({
      admin_id: userID,
      name:req.body.name,
      tagetdate: { $gte: new Date(targetYear, targetMonth, 1), $lt: new Date(targetYear, targetMonth + 1, 1) }
    }).exec();

    if (existingData) {
      req.flash('error_msg', 'Target for this month and year already exists!');
      res.redirect('/auth/operation/salestarget/create');
    } else {
      // Create a new entry
      const newData = new targetModel({
        name: req.body.name,
        target: req.body.target,
        tagetdate: req.body.tagetdate,
        admin_id: userID,
      });

      await newData.save();
      req.flash('success_msg', 'Successfully Inserted!!');
      res.redirect('/auth/operation/salestarget/index');
    }
  } catch (err) {
    console.error(err);
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/operation/salestarget/create');
  }
};
exports.edittarget = async (req, res, next) => {
  let dataId= req.params.id;
  const userID = req.user._id;
  try{
    const getData = await targetModel.findById(dataId).where({'admin_id':userID}).exec();
    res.render('admin/salestarget/create', { title: 'update sales', getData, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});
  }catch(err){
    console.log('Data Not Fetched ', err);
    res.redirect('/logout');
  }
};
exports.updatetarget = async (req, res, next) => {
  const userID = req.user._id;
  const dataId=req.params.id;
  try {

    const existingData = await targetModel.findOne({
      admin_id: userID,
      _id:dataId
    }).exec();

    if (existingData) {
     await targetModel.findByIdAndUpdate(dataId, {
    name: req.body.name,
    target: req.body.target,
    });
        req.flash('success_msg', 'Successfully Updates!!');
      res.redirect('/auth/operation/salestarget/index');
    } else {
        req.flash('error_msg', 'Target for User not already exists!');
      res.redirect('/auth/operation/salestarget/index');
    }
  } catch (err) {
    console.error(err);
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/operation/salestarget/create');
  }
};

exports.getindexbw = async (req, res, next) => {
    var salesname = req.params.name;
   const userID = req.user._id;
            var formDate = req.query.formdate;
            var startOfMonth, endOfMonth;
            
            if (formDate) {
                const selectedDate = new Date(formDate);
                  const year = selectedDate.getFullYear();
                  const month = selectedDate.getMonth();
                  startOfMonth = moment({ year, month, day: 1 }).startOf('day');
                  endOfMonth = moment({ year, month, day: 1 }).endOf('month');
            } else {
              const currentDate = moment();
              startOfMonth = currentDate.clone().startOf('month');
              endOfMonth = currentDate.clone().endOf('month');
            }
            startOfMonth = startOfMonth.toDate();
            endOfMonth = endOfMonth.toDate();
            startOfMonth.setHours(0, 0, 0, 0);
            endOfMonth.setHours(23, 59, 59, 999);
            
  try{
      const SalesBanks = await clientModel.find({
  admin_id: userID,
  name: salesname,
}, {
  _id: 1,
}).exec();
const salesBankIds = SalesBanks.map(salesBank => String(salesBank._id));


      const data = await bwtargetModel.find({
    tagetdate: { $gte: startOfMonth, $lte: endOfMonth },
    'bankid': { $in: salesBankIds }
}).sort({ createdAt: -1 }).populate({
    path: 'bankid',
    select: 'BankName name' 
});



    res.render('admin/salestarget/indexbw', { title: 'Sales Target List', viewDatas:null, getData:data, salesname });
  }catch(err){
    console.log('Data Not Fetched:',err);
  }
};
exports.getcreatebw = async (req, res, next) => {
    var salesname = req.params.name;
   const userID = req.user._id;
  try{

       const data = await clientModel.find({"adminid": userID, "name":salesname}).sort({"BankName": 1}).exec();
    res.render('admin/salestarget/createbw', { title: 'Sales Target List', viewDatas:null, getData:data, salesname });
  }catch(err){
    console.log('Data Not Fetched:',err);
  }
};


exports.addtargetbw = async (req, res, next) => {
  const userID = req.user._id;
  const salesname = req.params.name;

  const tagetDate = new Date(req.body.tagetdate);
  const targetMonth = tagetDate.getMonth() + 1; 
  const targetYear = tagetDate.getFullYear();

  try {
    for (const bank of req.body.bank) {
      const existingData = await bwtargetModel.findOne({
        admin_id: userID,
        bankid: bank,
        tagetdate: { $gte: new Date(targetYear, targetMonth - 1, 1), $lt: new Date(targetYear, targetMonth, 1) }
      }).exec();

      if (existingData) {
        req.flash('error_msg', `Target for ${bank} in this month and year already exists!`);
      } else {
        const newData = new bwtargetModel({
          bankid: bank,
          target: req.body.target,
          tagetdate: req.body.tagetdate,
          admin_id: userID,
        });

        await newData.save();
      }
    }

    req.flash('success_msg', 'Successfully Inserted!!');
    res.redirect(`/auth/operation/salestarget/indexbw/${salesname}?formdate=${tagetDate}`);

  } catch (err) {
    console.error(err);
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect(`/auth/operation/salestarget/createbw/${salesname}`);
  }
};

exports.edittargetbw = async (req, res, next) => {
  let dataId= req.params.id;
  const userID = req.user._id;
  try{
    const getData = await bwtargetModel.findById(dataId).where({'admin_id':userID}).exec();
    res.render('admin/salestarget/update', { title: 'update sales', getData, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});
  }catch(err){
    console.log('Data Not Fetched ', err);
    res.redirect('/logout');
  }
};
exports.updatetargetbw = async (req, res, next) => {
  const userID = req.user._id;
  const dataId=req.params.id;
  try {

    const existingData = await bwtargetModel.findOne({
      admin_id: userID,
      _id:dataId
    }).exec();

    if (existingData) {
     await bwtargetModel.findByIdAndUpdate(dataId, {
    
    target: req.body.target,
    });
        req.flash('success_msg', 'Successfully Updates!!');
      res.redirect('/auth/operation/salestarget/index');
    } else {
        req.flash('error_msg', 'Target for User not already exists!');
      res.redirect('/auth/operation/salestarget/index');
    }
  } catch (err) {
    console.error(err);
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/operation/salestarget/create');
  }
};

