var express = require('express');
var router = express.Router();
var bank= require('../../models/CorporateClients');
var UserModel= require('../../models/User');
var verificationModel= require('../../models/physicalverification/caselist');
var sessionCheck= require('../../middleware/sessionCheck').isAdmin;
const fs = require('fs');
const excelToJson = require('convert-excel-to-json');
const  moment = require('moment');
// multer start
const multer = require("multer");

let storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const adminID = req.body.adminID;
    const Bank = req.body.bankID;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/'+Bank+'/physicalexcel/business/'+datefolder;
    fs.mkdirSync(dest, { recursive: true })
        cb(null, dest);
  },
  filename: function (req, file, cb) {
    let extArray = file.mimetype.split("/");
    let extension = extArray[extArray.length - 1];
    cb(null, file.fieldname + '-' + Date.now()+ '.' +extension)
  }
});
const upload = multer({ storage: storage });
// multer end
router.get('/report',sessionCheck, async function(req, res, next){
    
    adminID=req.user.admin_id;
  try{
        var filterfields = {
                    'bankid':"nullc",
                    'casetype':"nullc",
                    'datefrom':"nullc",
                    'dateto':"nullc",
                };
        const viewDatas= await bank.find({'adminid':req.user._id}, '_id BankName').sort('BankName').exec();
        res.render('admin/summary/report', { title: 'Mis Report', getData:viewDatas, veridata:null,filterfields, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')} });
  }catch(err){
    console.log('Data Not Fetched:',err);
  }
});
router.post('/report',sessionCheck, async function(req, res, next){
    
    adminID=req.user._id;
  try{
        var filterfields = {
                    'datefrom': new Date(req.body.datefrom).valueOf(),
                    'dateto': new Date(req.body.dateto).valueOf(),
                    'bankid': req.body.bank,
                    'casetype': req.body.type,
                };
        var start = new Date(req.body.datefrom).setHours(0, 0, 1);
        var end = new Date(req.body.dateto).setHours(23, 59, 59);
        var filter = {
                    'adminid': req.user._id,
                    'Reciveddate': { $gt: start, $lt: end},
                };
        if(req.body.bank !=="nullc"){
            filter["bankid"] = req.body.bank;
        };
        if(req.body.type !=="nullc"){
            filter["casetype"] = req.body.type;
        };
        const veridata = await verificationModel.find(filter).exec();
        const viewDatas= await bank.find({'adminid':req.user._id}, '_id BankName').sort('BankName').exec();
        req.flash('success_msg', 'Data Successfully Filtered!!');
        res.render('admin/summary/report', { title: 'Mis Report', getData:viewDatas, veridata:veridata, filterfields, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')} });
  }catch(err){
    console.log('Data Not Fetched:',err);
  }
});
router.get('/assigncase/:id',sessionCheck, async function(req, res, next){
     let dataId= req.params.id;
      
  userID=req.user._id;
  try{
        const data= await UserModel.find({'status':'Active','admin_id':userID}).sort({name: 'asc'}).exec();
        const veridata = await verificationModel.findById(dataId).exec();
        res.render('admin/summary/assigncase', { title: 'Mis Report', getData:data,veridata:veridata});
  }catch(err){
    console.log('Data Not Fetched:',err);
  }
});
router.post('/assigncase',sessionCheck, async function(req, res, next){
  try{
        const a1= await verificationModel.findOneAndUpdate({'_id':req.body.getId}, { 'otname':req.body.fename, 'otid':req.body.feid,'otchangeremark':req.body.otchangeremark  });
    res.redirect('/auth/summary/report');
  }catch(err){
    console.log('Data Not Fetched:',err);
  }
});
router.get('/daywise_summary',sessionCheck, async function(req, res, next){
  try{
    res.render('admin/summary/daywise_summary', { title: 'Summary', getData:null });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});
router.get('/monthwise_summary',sessionCheck, async function(req, res, next){
   const adminID=req.user._id;
  try{
      const data =  await verificationModel.aggregate([
  {
    $match: {
      Reciveddate: {
        $gte: moment().startOf('month').subtract(2, 'months').toDate(),
        $lte: moment().endOf('month').toDate()
      },
      adminid:adminID,
      status: { $gt: 0, $lt:7},
    }
  },
  {
    $group: {
      _id: {
        bankname: "$bankname",
        month: {
          $dateToString: {
            format: "%Y-%m",
            date: "$Reciveddate"
          }
        }
      },
      count: {
        $sum: 1
      }
    }
  },
  {
    $group: {
      _id: "$_id.bankname",
      counts: {
        $push: {
          count: "$count",
          month: "$_id.month"
        }
      }
    }
  },
  {
    $project: {
      _id: 1,
      counts: 1
    }
  },
  {
    $unwind: "$counts"
  },
  {
    $sort: {
      "_id": 1,
      "counts.month": 1
    }
  },
  {
    $group: {
      _id: "$_id",
      counts: {
        $push: {
          count: "$counts.count",
          month: "$counts.month"
        }
      }
    }
  },
  {
    $project: {
      _id: 1,
      counts: {
        $map: {
          input: [
            moment().startOf('month').subtract(2, 'months').format("YYYY-MM"),
            moment().startOf('month').subtract(1, 'months').format("YYYY-MM"),
            moment().startOf('month').format("YYYY-MM")
          ],
          as: "month",
          in: {
            $cond: [
              {
                $in: ["$$month", "$counts.month"]
              },
              {
                $arrayElemAt: [
                  "$counts",
                  {
                    $indexOfArray: ["$counts.month", "$$month"]
                  }
                ]
              },
              {
                month: "$$month",
                count: 0
              }
            ]
          }
        }
      }
    }
  }
]);

    res.render('admin/summary/monthwise_summary', { title: 'Summary', getData:data });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});
router.get('/bankwise_summary', sessionCheck, async function(req, res, next) {
    const adminID=req.user._id;
  try {
   const startOfMonth = new Date();
startOfMonth.setDate(1);
startOfMonth.setHours(0, 0, 0, 0);

const endOfMonth = new Date();
endOfMonth.setMonth(endOfMonth.getMonth() + 1);
endOfMonth.setDate(0);
endOfMonth.setHours(23, 59, 59, 999);
const pipeline = [
  {
    $match: {
      Reciveddate: {
        $gte: startOfMonth,
        $lte: endOfMonth,
      },
      adminid: adminID,
      status: { $gt: 0, $lt: 7 },
    },
  },
  
];




const result = await verificationModel.aggregate(pipeline);
console.log(result)
    res.render('admin/summary/bankwise_summary', { title: 'Summary', getData: null, result: result });
  } catch (error) {
    console.log(error);
  }
});

router.get('/work_perform_oe',sessionCheck, async function(req, res, next){
       const adminID=req.user._id;
  try{
      const data =  await verificationModel.aggregate([
  {
    $match: {
      Reciveddate: {
        $gte: moment().startOf('month').toDate(),
        $lte: moment().endOf('month').toDate()
      },
      adminid:adminID,
      status: 6,
      fename: {
        $ne: ""
        },
    }
  },
  {
    $group: {
      _id: {
        bankname: "$otname",
        day: {
          $dateToString: {
            format: "%Y-%m-%d",
            date: "$Reciveddate"
          }
        }
      },
      count: {
        $sum: 1
      }
    }
  },
  {
    $group: {
      _id: "$_id.bankname",
      counts: {
        $push: {
          count: "$count",
          day: "$_id.day"
        }
      },
      total: {
        $sum: "$count"
      }
    }
  },
  {
    $project: {
      _id: 1,
      counts: 1,
      total: 1
    }
  },
  {
    $unwind: "$counts"
  },
  {
    $sort: {
      "_id": 1,
      "counts.day": 1
    }
  },
  {
    $group: {
      _id: "$_id",
      counts: {
        $push: {
          count: "$counts.count",
          day: "$counts.day"
        }
      },
      total: {
        $first: "$total"
      }
    }
  },
  {
    $project: {
      _id: 1,
      counts: {
        $map: {
          input: Array.from({ length: moment().daysInMonth() }, (_, i) => moment().startOf('month').add(i, 'days').format("YYYY-MM-DD")),
          as: "day",
          in: {
            $cond: [
              {
                $in: ["$$day", "$counts.day"]
              },
              {
                $arrayElemAt: [
                  "$counts",
                  {
                    $indexOfArray: ["$counts.day", "$$day"]
                  }
                ]
              },
              {
                day: "$$day",
                count: 0
              }
            ]
          }
        }
      },
      total: 1
    }
  }
]);

    res.render('admin/summary/work_perform_oe', { title: 'Summary', getData:data });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});

router.get('/work_perform_fe', sessionCheck, async function(req, res, next) {
  const adminID = req.user._id;
  try {
    const data = await verificationModel.aggregate([
      {
        $match: {
          fedonedate: {
            $gte: moment().startOf('month').toDate(),
            $lte: moment().endOf('month').toDate()
          },
          adminid: adminID,
          status: {
            $gte: 4,
            $lt: 7
          },
          fename: {
              $exists: true,
        $ne: null
        }
        }
      },
      {
        $group: {
          _id: {
            bankname: "$fename",
            day: {
              $dateToString: {
                format: "%Y-%m-%d",
                date: "$fedonedate"
              }
            }
          },
          count: {
            $sum: 1
          }
        }
      },
      {
        $group: {
          _id: "$_id.bankname",
          counts: {
            $push: {
              count: "$count",
              day: "$_id.day"
            }
          },
          total: {
            $sum: "$count"
          }
        }
      },
      {
        $project: {
          _id: 1,
          counts: 1,
          total: 1
        }
      },
      {
        $unwind: "$counts"
      },
      {
        $sort: {
          "_id": 1,
          "counts.day": 1
        }
      },
      {
        $group: {
          _id: "$_id",
          counts: {
            $push: {
              count: "$counts.count",
              day: "$counts.day"
            }
          },
          total: {
            $first: "$total"
          }
        }
      },
      {
        $project: {
          _id: 1,
          counts: {
            $map: {
              input: Array.from({
                length: moment().daysInMonth()
              }, (_, i) => moment().startOf('month').add(i, 'days').format("YYYY-MM-DD")),
              as: "day",
              in: {
                $cond: [{
                    $in: ["$$day", "$counts.day"]
                  },
                  {
                    $arrayElemAt: [
                      "$counts", {
                        $indexOfArray: ["$counts.day", "$$day"]
                      }
                    ]
                  },
                  {
                    day: "$$day",
                    count: 0
                  }
                ]
              }
            }
          },
          total: 1
        }
      }
    ]);
    console.log(data)
    res.render('admin/summary/work_perform_fe', { title: 'Summary', getData:data });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});
router.get('/pending_cases_fe', sessionCheck, async function(req, res, next) {
  const adminID = req.user._id;
  try {
    const data = await verificationModel.aggregate([
      {
        $match: {
          updatedAt: {
            $gte: moment().startOf('month').toDate(),
            $lte: moment().endOf('month').toDate()
          },
          adminid: adminID,
          status: {
            $gte: 2,
            $lt: 4
          },
          feid: {
              $exists: true,
        $ne: null
        }
        }
      },
      {
        $group: {
          _id: {
            bankname: "$fename",
            day: {
              $dateToString: {
                format: "%Y-%m-%d",
                date: "$updatedAt"
              }
            }
          },
          count: {
            $sum: 1
          }
        }
      },
      {
        $group: {
          _id: "$_id.bankname",
          counts: {
            $push: {
              count: "$count",
              day: "$_id.day"
            }
          },
          total: {
            $sum: "$count"
          }
        }
      },
      {
        $project: {
          _id: 1,
          counts: 1,
          total: 1
        }
      },
      {
        $unwind: "$counts"
      },
      {
        $sort: {
          "_id": 1,
          "counts.day": 1
        }
      },
      {
        $group: {
          _id: "$_id",
          counts: {
            $push: {
              count: "$counts.count",
              day: "$counts.day"
            }
          },
          total: {
            $first: "$total"
          }
        }
      },
      {
        $project: {
          _id: 1,
          counts: {
            $map: {
              input: Array.from({
                length: moment().daysInMonth()
              }, (_, i) => moment().startOf('month').add(i, 'days').format("YYYY-MM-DD")),
              as: "day",
              in: {
                $cond: [{
                    $in: ["$$day", "$counts.day"]
                  },
                  {
                    $arrayElemAt: [
                      "$counts", {
                        $indexOfArray: ["$counts.day", "$$day"]
                      }
                    ]
                  },
                  {
                    day: "$$day",
                    count: 0
                  }
                ]
              }
            }
          },
          total: 1
        }
      }
    ]);
    console.log(data)
    res.render('admin/summary/pending_cases_fe', { title: 'Summary', getData:data });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});

module.exports = router;