var express = require('express');
var router = express.Router();
var bank= require('../../models/CorporateClients');
var sessionCheck= require('../../middleware/sessionCheck').isAdmin;
const fs = require('fs');
const excelToJson = require('convert-excel-to-json');
// multer start
const multer = require("multer");

let storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const adminID = req.body.adminID;
    const Bank = req.body.bankID;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/'+Bank+'/physicalexcel/business/'+datefolder;
    fs.mkdirSync(dest, { recursive: true })
        cb(null, dest);
  },
  filename: function (req, file, cb) {
    let extArray = file.mimetype.split("/");
    let extension = extArray[extArray.length - 1];
    cb(null, file.fieldname + '-' + Date.now()+ '.' +extension)
  }
});
const upload = multer({ storage: storage });
// multer end
router.get('/',sessionCheck, async function(req, res, next){
  try{
    res.render('admin/tracking/index', { title: 'FE Tracking', getData:null });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});

module.exports = router;