var express = require('express');
var router = express.Router();
var sessionCheck= require('../../middleware/sessionCheck').isOpration;
var verificationModel= require('../../models/physicalverification/caselist');
var bank= require('../../models/CorporateClients');
var users= require('../../models/User');
const fs = require('fs');

/* GET dashboard page. */
router.get('/',sessionCheck, async function(req, res, next) {
     const currentDate = new Date();
        const currentMonth = currentDate.getMonth();
        const currentYear = currentDate.getFullYear();
        
        var formDate = req.query.formdate;
        var month, year;
        
        if (formDate) {
          month = parseInt(formDate.slice(0, 2));
          year = parseInt(formDate.slice(2, 6));
        } else {
          month = currentMonth;
          year = currentYear;
        }
        
        if (month === 12) {
          year += 1;
          month = 0; // January is month 0 in JavaScript Date objects
        }
        console.log(year);
        console.log(month);
        const start = new Date(year, month, 1).setHours(0, 0, 1);
        const end = new Date(year, month + 1, 0).setHours(23, 59, 59);
        
        console.log(start.toString())
    const adminID=req.user.admin_id;
    try{
        var data ={};
            data.mpending = await verificationModel.find({'adminid':adminID, 'status': { $gt: 0, $lt:6}, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments();
            data.tpending = await verificationModel.find({'adminid':adminID, 'status': { $gt: 0, $lt:6}, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments();
            data.mcomplete = await verificationModel.find({'adminid':adminID, 'status':6, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments();
            data.tcomplete = await verificationModel.find({'adminid':adminID, 'status':6, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments();
            data.mcancel = await verificationModel.find({'adminid':adminID, 'status':7, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments();
            data.tcancel = await verificationModel.find({'adminid':adminID, 'status':7, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments();
            data.mtotal = await verificationModel.find({'adminid':adminID, 'status': { $gt: 0, $lt:7},'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments();
            data.ttotal = await verificationModel.find({'adminid':adminID, 'status': { $gt: 0, $lt:7},'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments();
            
            var type = ["Office", "Business", "Employment","Residence", "itr", "tele", "Bank Statement", "Salary Paysilp", "Form 16", "aadhar", "pan", "voter", "gst", "CarDealer" ];
            var casedata =[];
            await Promise.all(type.map(async (element) => {
                 casedata[element] = {
                    'monthdone':await verificationModel.find({'casetype':element,'adminid':adminID, 'status':6, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todaydone':await verificationModel.find({'casetype':element,'adminid':adminID, 'status':6, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthpending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status': { $gt: 0, $lt:6}, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todaypending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status': { $gt: 0, $lt:6}, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthmailpending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status':5, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todaymailpending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status':5, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthotpending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status':4, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todayotpending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status':4, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthfepending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status': { $gt: 1, $lt:4}, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todayfepending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status': { $gt: 1, $lt:4}, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthunassignpending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status':1, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todayunassignpending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status':1, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthcanclepending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status':7, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todaycanclepending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status':7, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthtotalpending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status': { $gt: 0, $lt:7}, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todaytotalpending':await verificationModel.find({'casetype':element,'adminid':adminID, 'status': { $gt: 0, $lt:7}, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                };
            }));
                casedata["Total"] = {
                    'monthdone':await verificationModel.find({'adminid':adminID, 'status':6, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todaydone':await verificationModel.find({'adminid':adminID, 'status':6, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthpending':await verificationModel.find({'adminid':adminID, 'status': { $gt: 0, $lt:6}, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todaypending':await verificationModel.find({'adminid':adminID, 'status': { $gt: 0, $lt:6}, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthmailpending':await verificationModel.find({'adminid':adminID, 'status':5, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todaymailpending':await verificationModel.find({'adminid':adminID, 'status':5, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthotpending':await verificationModel.find({'adminid':adminID, 'status':4, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todayotpending':await verificationModel.find({'adminid':adminID, 'status':4, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthfepending':await verificationModel.find({'adminid':adminID, 'status': { $gt: 1, $lt:4}, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todayfepending':await verificationModel.find({'adminid':adminID, 'status': { $gt: 1, $lt:4}, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthunassignpending':await verificationModel.find({'adminid':adminID, 'status':1, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todayunassignpending':await verificationModel.find({'adminid':adminID, 'status':1, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthcanclepending':await verificationModel.find({'adminid':adminID, 'status':7, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todaycanclepending':await verificationModel.find({'adminid':adminID, 'status':7, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                    'monthtotalpending':await verificationModel.find({'adminid':adminID, 'status': { $gt: 0, $lt:7}, 'createdAt': { $gt:start.toString(), $lt:end.toString()}}).countDocuments(),
                    'todaytotalpending':await verificationModel.find({'adminid':adminID, 'status': { $gt: 0, $lt:7}, 'createdAt': { $gt:new Date().setHours(0, 0, 0), $lt:new Date().setHours(23, 59, 59)}}).countDocuments(),
                };

        res.render('operation/dashboard', { title: 'VB-Digital', alertMessage:{'success':req.flash('success_msg')}, data:data, casedata});  
    }catch(err){
        res.render('operation/dashboard', { title: 'VB-Digital',  alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});  
    }
});
/*To get profile data*/
router.get('/profile',sessionCheck, async function(req, res, next) {
    userID=req.user._id;
    try{
    const userdata = await users.findById(userID).exec();
    res.render('operation/profile', { title: 'VB-Digital',userdata,  alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});
    }catch(err){
        console.log(err);
    }
});

module.exports = router;