const express = require('express');
const router = express.Router();
const users = require('../models/User');
const passport = require('passport');
const LocalStrategy = require('passport-local').Strategy;
var urlencodedParser = express.urlencoded({ extended: false });

// Configure Passport to use a Local strategy
passport.use(new LocalStrategy(
  async (username, password, done) => {
    try {
      const Data = await users.findOne({ username: username, password: password }).exec();
      if (Data === null || Data === '') {
        return done(null, false, { message: 'Invalid Credentials' });
      } else {
        if (Data.status === 'Inactive') {
          return done(null, false, { message: 'Please Contact Management' });
        } else {
          return done(null, Data);
        }
      }
    } catch (err) {
      return done(err);
    }
  }
));

// Serialize user object to store in the session
passport.serializeUser((user, done) => {
  done(null, user.id);
});

// Deserialize user object from the session
passport.deserializeUser(async (id, done) => {
  try {
    const Data = await users.findById(id).exec();
    done(null, Data);
  } catch (err) {
    done(err);
  }
});

/* GET home page. */
router.get('/', (req, res, next) => {
  res.render('index', { title: 'VB-Digital', errorMsg:''});
});

// POST login page
router.post('/', urlencodedParser, (req, res, next) => {
  passport.authenticate('local', (err, user, info) => {
    if (err) {
      return next(err);
    }
    if (!user) {
      return res.render('index', { title: 'VB-Digital', errorMsg: info.message });
    }

    req.login(user, (err) => {
      if (err) {
        return next(err);
      }

      switch (user.role) {
        case 'Admin':
           
          return res.redirect('/auth/dashboard');
        case 'OT':
          
          return res.redirect('/auth/operationteam');
        case 'HR':
           
          return res.redirect('/auth/hrteam');
        default:
       
          req.logout();
          return res.render('index', { title: 'VB-Digital', errorMsg: 'Unknown role. Please contact support.' });
      }
    });
  })(req, res, next);
});

router.get('/logout', (req, res, next) => {
  req.session.destroy();
  res.redirect('/login');
});

module.exports = router;
