const express = require('express');
const router = express.Router();
const { sendNotificationToDevice } = require('./notificationController');

// Define your API route
router.post('/send-notification', async (req, res) => {
  const firebaseToken = req.body.firebaseToken; // Get the Firebase token from the request body

  try {
    const response = await sendNotificationToDevice(firebaseToken);
    console.log('Successfully sent notification:', response);
    res.status(200).json({ message: 'Notification sent successfully' });
  } catch (error) {
    console.error('Error sending notification:', error);
    res.status(500).json({ error: 'An error occurred while sending the notification' });
  }
});

module.exports = router;
