var verificationModel= require('../../../models/physicalverification/caselist');
var cardcaseModel= require('../../../models/physicalverification/cardcases');
var imagesModel= require('../../../models/physicalverification/otherimages');
var bank= require('../../../models/CorporateClients');
const fs = require('fs');
const excelToJson = require('convert-excel-to-json');
var feteam= require('../../../models/feteam');
const htmlPdf = require("html-pdf");
const path = require("path");
const ejs = require("ejs");
const moment = require("moment");

exports.getindex = async (req, res, next) => {
  try{
    res.render('operation/physical/itr/index', { title: 'Case List', getData:null });
  }catch(err){
    console.log('Data Not Fetched:',err);
  }
};
async function paginatedResults(req,status) {

    var results = {};
    const adminID=req.user.admin_id;
    var draw = req.query.draw;
    results.draw =draw;
    var startIndex = parseInt(req.query.start);
    var limit = parseInt(req.query.length);
    var order_data = req.query.order;
    const search_value = req.query.search['value'];
    let sortObj = {};
        if (order_data) {
        const column_index = req.query.order[0]['column'];
        const column_name = req.query.columns[column_index]['data'];
        const column_sort_order = req.query.order[0]['dir'];
        sortObj[column_name] = column_sort_order;
        } else {
        sortObj = { _id: 'desc' };
        }
        results.total_records= await verificationModel.find({'adminid':adminID,'status':status,'casetype':'itr'}).countDocuments();
        if(!search_value){
        results.total_filter_records =parseInt(results.total_records);
        results.data = await verificationModel.find({ adminid: adminID,'casetype':'itr',status:status},{  _id: 1, applicantname: 1,otname: 1,cardno: 1,location: 1,    totalincome: 1, applicantbankaddress: 1,   statementyear: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1, fename:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        }else{
        results.data = await verificationModel.find({ adminid: adminID,'casetype':'itr',status:status, $text: {$search: search_value}},{  _id: 1, applicantname: 1,otname: 1,cardno: 1,location: 1,    totalincome: 1, applicantbankaddress: 1,   statementyear: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        results.total_filter_records = await verificationModel.find({ adminid: adminID,'casetype':'itr',status:status, $text: {$search: search_value}}).countDocuments(); 
        }
    return results;
}
async function paginatedassigneddataResults(req,status) {

    var results = {};
    const adminID=req.user.admin_id;
    var draw = req.query.draw;
    results.draw =draw;
    var startIndex = parseInt(req.query.start);
    var limit = parseInt(req.query.length);
    var order_data = req.query.order;
    const search_value = req.query.search['value'];
    let sortObj = {};
        if (order_data) {
        const column_index = req.query.order[0]['column'];
        const column_name = req.query.columns[column_index]['data'];
        const column_sort_order = req.query.order[0]['dir'];
        sortObj[column_name] = column_sort_order;
        } else {
        sortObj = { _id: 'desc' };
        }
        results.total_records= await verificationModel.find({'adminid':adminID,'otid':req.user._id, 'casetype':'itr',status: { $gt: 1, $lt:4}}).countDocuments();
        if(!search_value){
        results.total_filter_records =parseInt(results.total_records);
        results.data = await verificationModel.find({ adminid: adminID,'otid':req.user._id,'casetype':'itr',status: { $gt: 1, $lt:4}},{  _id: 1, applicantname: 1,cardno: 1,location: 1,    totalincome: 1, applicantbankaddress: 1,   statementyear: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1, fename:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        }else{
        results.data = await verificationModel.find({ adminid: adminID,'otid':req.user._id,'casetype':'itr',status: { $gt: 1, $lt:4}, $text: {$search: search_value}},{  _id: 1, applicantname: 1,cardno: 1,location: 1,    totalincome: 1, applicantbankaddress: 1,   statementyear: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        results.total_filter_records = await verificationModel.find({ adminid: adminID,'otid':req.user._id,'casetype':'itr',status: { $gt: 1, $lt:4}, $text: {$search: search_value}}).countDocuments(); 
        }
    return results;
}
exports.getdata = async (req, res, next) => {
    var result = await paginatedResults(req, 1);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        console.log(row);
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'cardno' : row.cardno,
            'assesment': row.statementyear,
            'formno': row.applicantbankaddress,
            'acknowldgeno': row.totalincome,
            'city' : row.city,
            'location' : row.location,
            'bankname' : row.bankname,
            'formtype' : row.formtype,
           'action' : '<a href="/auth/ot/itr/assign-case/'+row._id+'" class="btn btn-success" role="button" title="Fill Form"><i class="material-icons option-icon">assignment_turned_in</i></a><a data-toggle="modal" data-target="#exampleModal'+row._id+'" class="btn btn-danger" role="button" title="Cancle Case"><i class="material-icons option-icon">close</i></a><div class="modal fade" id="exampleModal'+row._id+'" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header"><h5 class="modal-title" id="exampleModalLabel">Remark</h5><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></div><form method="post" action="/auth/ot/itr/cancele-case/'+row._id+'"><div class="modal-body"><div class="form-line"><input type="text" name="remark" class="form-control" required></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button><button type="submit" type="submit" value="submit" class="btn btn-primary">Save changes</button></div> </form></div></div></div>'
          });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
};
exports.getassigned = async (req, res, next) => {
  try{
    res.render('operation/physical/itr/assigned', { title: 'Case List', getData:null, page:'Assigned' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};

exports.getassigneddata = async (req, res, next) => {
    var result = await paginatedassigneddataResults(req, 3);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        
        data_arr.push({
           'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'cardno' : row.cardno,
            'assesment': row.statementyear,
            'formno': row.applicantbankaddress,
            'acknowldgeno': row.totalincome,
            'city' : row.city,
            'location' : row.location,
            'bankname' : row.bankname,
            'formtype' : row.formtype,
            'action' : '<a href="/auth/ot/itr/checkdata/'+row._id+'" class="btn btn-success" role="button" title="Fill Form"><i class="material-icons option-icon">assignment_turned_in</i></a><a data-toggle="modal" data-target="#exampleModal'+row._id+'" class="btn btn-danger" role="button" title="Cancle Case"><i class="material-icons option-icon">close</i></a><div class="modal fade" id="exampleModal'+row._id+'" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header"><h5 class="modal-title" id="exampleModalLabel">Remark</h5><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></div><form method="post" action="/auth/ot/itr/cancele-case/'+row._id+'"><div class="modal-body"><div class="form-line"><input type="text" name="remark" class="form-control" required></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button><button type="submit" type="submit" value="submit" class="btn btn-primary">Save changes</button></div> </form></div></div></div>'
         });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
};

exports.getdonebyot = async (req, res, next) => {
  try{
    res.render('operation/physical/itr/done_by_ot', { title: 'Case List', getData:null, page:'Done by OT' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};

exports.getdonebyotdata = async (req, res, next) => {
    var result = await paginatedResults(req, 5);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
             'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'cardno' : row.cardno,
            'assesment': row.statementyear,
            'formno': row.applicantbankaddress,
            'acknowldgeno': row.totalincome,
            'city' : row.city,
            'location' : row.location,
            'bankname' : row.bankname,
            'formtype' : row.formtype,
            'otname'   : row.otname,
             'action' : `<a href="/auth/ot/itr/update/${row._id}" class="btn btn-success" role="button" title="Data Check"><i
        class="material-icons option-icon">assignment_turned_in</i></a><a data-toggle="modal"
    data-target="#exampleModal${row._id}" class="btn btn-success" role="button" title="Data Check"><i
        class="material-icons option-icon">alternate_email</i></a><a data-toggle="modal"
    data-target="#cancleModal${row._id}" class="btn btn-danger" role="button" title="Cancle Case"><i
        class="material-icons option-icon">close</i></a>
<div class="modal fade" id="exampleModal${row._id}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Select Mail Date</h5><button type="button" class="close"
                    data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <form method="post" action="/auth/ot/itr/checkmail/${row._id}">
                <div class="modal-body">
                    <div class="form-line"><input type="email" name="Mailsentto" class="form-control"
                            placeholder="Mail Sent To" required></div>
                    <div class="form-line"><input type="datetime-local" name="Mailsentdate" class="form-control"
                            required></div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary"
                            data-dismiss="modal">Close</button><button type="submit" type="submit" value="submit"
                            class="btn btn-primary">Save changes</button></div>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="cancleModal${row._id}" tabindex="-1" role="dialog" aria-labelledby="cancleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cancleModalLabel">Remark</h5><button type="button" class="close"
                    data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <form method="post" action="/auth/ot/itr/cancele-case/${row._id}">
                <div class="modal-body">
                    <div class="form-line"><input type="text" name="remark" class="form-control" required></div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary"
                            data-dismiss="modal">Close</button><button type="submit" type="submit" value="submit"
                            class="btn btn-primary">Save changes</button> </div>
                </div>
            </form>
        </div>
    </div>
</div>`
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
};
exports.getcompleted = async (req, res, next) => {
  try{
    res.render('operation/physical/itr/completed', { title: 'Case List', getData:null, page:'Completed' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};
exports.getcompleteddata = async (req, res, next) => {
    var result = await paginatedResults(req, 6);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'cardno' : row.cardno,
            'assesment': row.statementyear,
            'formno': row.applicantbankaddress,
            'acknowldgeno': row.totalincome,
            'city' : row.city,
            'location' : row.location,
            'bankname' : row.bankname,
            'formtype' : row.formtype,
            'otname'   : row.otname,
            'action' : '<a href="/auth/ot/itr/create_pdf/'+row._id+'" class="btn btn-success" role="button" title="Data Check"><i class="material-icons option-icon">picture_as_pdf</i></a>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
};
exports.getcancelled = async (req, res, next) => {
  
  try{
    res.render('operation/physical/itr/cancelled', { title: 'Case List', getData:null, page:'Cancelled' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};
exports.removeimages = async (req, res, next) => {
  let dataId= req.params.id;
  
  const userID=req.user.admin_id;
  try{
       var getData = await imagesModel.findOne({'_id':dataId}).exec();
      
         if(getData.image != '' && getData.image != null && getData.image != undefined){
            if (fs.existsSync(imageBaseDir+getData.image)) {
              fs.unlinkSync(imageBaseDir+getData.image);
            }
         }
         var getData = await imagesModel.findOneAndDelete({'_id':dataId}).exec();
    res.redirect('back');
  }catch(err){
    console.log('Data Not Fetched');
  }
};
exports.getcancelleddata = async (req, res, next) => {
    var result = await paginatedResults(req, 7);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'cardno' : row.cardno,
            'assesment': row.statementyear,
            'formno': row.applicantbankaddress,
            'acknowldgeno': row.totalincome,
            'city' : row.city,
            'location' : row.location,
            'bankname' : row.bankname,
            'formtype' : row.formtype,
            'otname'   : row.otname,
            'action' : '<a href="/auth/ot/itr/cancele-case/'+row._id+'" class="btn btn-danger" role="button" title="CANCELLED"><i class="material-icons option-icon">close</i></a>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
};
// Actions
exports.getcancellecasedata = async (req, res, next) => {
  let dataId= req.params.id;
  
  const userID=req.user.admin_id;
  try{
     const a1= await verificationModel.findOneAndUpdate({'_id':dataId,'adminid':userID}, {'casestatus':req.body.remark,'status':7,'cancleby':req.user.name });
    res.redirect('back');
  }catch(err){
    console.log('Data Not Fetched');
  }
};

exports.getassigncaseadddata = async (req, res, next) => {
  let dataId= req.params.id;
  
  const userID=req.user.admin_id;
  try{
    const a1= await verificationModel.findOneAndUpdate({'_id':dataId,'adminid':userID}, {'status':2, 'otname':req.user.name, 'otid':req.user._id });
    res.redirect('/auth/ot/itr/checkdata/'+dataId);
  }catch(err){
    console.log('Data Not Fetched');
  }
};


exports.getfillcheckdata = async (req, res, next) => {
  let dataId= req.params.id;
  
  const userID=req.user.admin_id;
  try{
     const data= await verificationModel.findOne({'_id':dataId,'adminid':userID,'status':2,'otid':req.user._id}).exec();
    res.render('operation/physical/itr/addform', { title: 'Case List', getData:data, getimage:null,  page:'Assign' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};
exports.postcreatecasesadd = async (req, res, next) => {
  let dataId= req.body.id;
  
  const userID=req.user.admin_id;
  const olddata = await cardcaseModel.find({'caseid': req.body.caseid, 'adminid': userID, });
     if(olddata != null && olddata != ''){
         olddata.forEach(async function(olddata){
             await cardcaseModel.findByIdAndDelete(olddata._id);
            const imgolddata = await imagesModel.find({reportid:olddata._id});
                if(imgolddata != null && imgolddata != ''){
                imgolddata.forEach(async function(imgolddata){
                        await imagesModel.findByIdAndDelete(imgolddata._id);
                        if (fs.existsSync(imageBaseDir+imgolddata.filename)) {
                         fs.unlinkSync(imageBaseDir+imgolddata.filename);
                        }
                });
                }
          });
     }
     const event = new Date();
    const datefolder = event.toDateString();
    try{
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                console.log(err);
            }
            else{
                const residata = new cardcaseModel({ 
                    leadid: docs.leadid,
                    caseid: docs._id,
                    
                    ddaid: docs.ddaid,
                    contact: docs.contact,
                    officename: docs.officename,
                    officeaddress: docs.permanentaddress,
                    co_applicantname: docs.co_applicantname,
                    guarantorname: docs.guarantorname,
                    applicantemail: docs.applicantemail,
                    location: docs.location,
                    branchcode: docs.branchcode,
                    typeofloan: docs.typeofloan,
                    city: docs.city,
                    
                    applicantname: docs.applicantname,
                    cardno: docs.cardno,
                    acknowledgeno: docs.totalincome,
                    assesmentyesr: docs.statementyear,
                    formno: docs.applicantbankaddress,
                    grosstotal:docs.grosstotal,
                    adminid: docs.adminid,
                    bankid: docs.bankid,
                    bankname: docs.bankname,
                    formtype: docs.formtype,
                    otname: req.user.name,
                    otid:req.user._id,
                    Reciveddate: docs.Reciveddate,
                    casetype: docs.casetype,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven:req.body.ufeleven,
                    uftwelve:req.body.uftwelve,
                    ufthirteen:req.body.ufthirteen,
                    uffourteen:req.body.uffourteen,
                    uffifteen:req.body.uffifteen,
                    ufsixteen:req.body.ufsixteen,
                    ufseventeen:req.body.ufseventeen,
                    ufeighteen:req.body.ufeighteen,
                    ufnineteen:req.body.ufnineteen,
                    uftwenty:req.body.uftwenty,
                    finalstatus: req.body.finalstatus,
                    finalremark: req.body.finalremark,
                });
                const resisaveddata =await residata.save();
                  if(req.files.itr){
                    req.files.itr.map((cv, ind, arr)=>{
                    req.files.itr[ind].caseid=req.body.caseid;
                    req.files.itr[ind].fecode=req.user._id;
                    req.files.itr[ind].reportid=resisaveddata._id;
                    req.files.itr[ind].image=`images/uploads/cases/uploads/${userID}/physicalcases/itr/${datefolder}/${arr[ind].filename}`;
                    });
                    imagesModel.insertMany(req.files.itr);
                  }
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{ status:'5',fedonedate:new Date(),'casestatus':req.body.finalstatus,'otid':req.user._id, 'otname':req.user.name, 'otdonedate':new Date()});
            }
        });
        res.redirect('/auth/ot/itr/done_by_ot');

  }catch(err){
    console.log('Data Not Fetched');
  }
};
exports.postupdatecasesadd = async (req, res, next) => {
  let dataId= req.body.caseid;
  
  const userID=req.user.admin_id;
     const event = new Date();
    const datefolder = event.toDateString();
    try{
        const a1= await verificationModel.findOne({'_id':dataId,'adminid':userID}, {'otid':1 });
      if(a1.otid !=null && a1.otid != req.user._id){
          res.redirect('back');
      }
     
        verificationModel.findById(req.body.caseid,async function (err, docs) {
            if (err){
                console.log(err);
            }
            else{
                await cardcaseModel.findByIdAndUpdate(req.body.donecaseid,{ 
                    grosstotal:req.body.grosstotal,
                    ufone: req.body.ufone,
                    uftwo: req.body.uftwo,
                    ufthree: req.body.ufthree,
                    uffour: req.body.uffour,
                    uffive: req.body.uffive,
                    ufsix: req.body.ufsix,
                    ufseven: req.body.ufseven,
                    ufeight: req.body.ufeight,
                    ufnine: req.body.ufnine,
                    uften: req.body.uften,
                    ufeleven:req.body.ufeleven,
                    uftwelve:req.body.uftwelve,
                    ufthirteen:req.body.ufthirteen,
                    uffourteen:req.body.uffourteen,
                    uffifteen:req.body.uffifteen,
                    ufsixteen:req.body.ufsixteen,
                    ufseventeen:req.body.ufseventeen,
                    ufeighteen:req.body.ufeighteen,
                    ufnineteen:req.body.ufnineteen,
                    uftwenty:req.body.uftwenty,
                    finalstatus: req.body.finalstatus,
                    finalremark: req.body.finalremark,
                    otname: req.user.name,
                    otid:req.user._id,
                });
                if(req.files.itr){
                    req.files.itr.map((cv, ind, arr)=>{
                    req.files.itr[ind].caseid=req.body.caseid;
                    req.files.itr[ind].fecode=req.user._id;
                    req.files.itr[ind].reportid=req.body.donecaseid;
                    req.files.itr[ind].image=`images/uploads/cases/uploads/${userID}/physicalcases/itr/${datefolder}/${arr[ind].filename}`;
                    });
                    imagesModel.insertMany(req.files.itr);
                }
                    await verificationModel.findByIdAndUpdate(req.body.caseid,{'casestatus':req.body.finalstatus,'status':5,'otid':req.user._id, 'otname':req.user.name, 'otdonedate':new Date()});
            }
        });
    res.redirect('back');
  }catch(err){
    console.log('Data Not Fetched');
  }
};

exports.getupdatecheckdata = async (req, res, next) => {
  let dataId= req.params.id;
  
  const userID=req.user.admin_id;
  try{
       const a1= await verificationModel.findOne({'_id':dataId,'adminid':userID}, {'formtype':1 });
     const data= await cardcaseModel.findOne({'caseid':dataId,'adminid':userID}).exec();
     const image= await imagesModel.find({'caseid':dataId,'reportid':data._id}).exec();
    res.render('operation/physical/itr/updateform'+a1.formtype, { title: 'Case List', getData:data, getimage:null, getimage:image, page:'Assign' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};

// Create cases 
exports.createcase = async (req, res, next) => {
    
    adminID=req.user.admin_id;
    try{
    const viewDatas= await bank.find({'adminid':adminID,'status':'Active'}, '_id BankName').sort('BankName').exec();
    if(viewDatas == null || viewDatas == ''){
        req.flash('error_msg', 'Please Add Bank!!');
        res.redirect('/auth/ot/itr/index');
    }
    res.render('operation/physical/itr/create', { title: 'Create Cases', viewDatas,adminID, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});
    }catch(err){
    console.log('Data Not Fetched');
  }
};

/* Download Format*/
exports.DownloadFormat = async (req, res, next) => {
  const dest = imageBaseDir+'images/uploads/cases/format/physicalformat/'+req.params.format+'itr.xlsx';
res.download(dest);
};

/* to insert admin data */
exports.postcreatecases = async (req, res, next) => {
    const adminID = req.body.adminID;
    const Bank = req.body.bankID;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/'+Bank+'/physicalexcel/itr/'+datefolder+'/'+req.file.filename;
    const bankname= await bank.findOne({'_id':Bank,'adminid':adminID}, 'BankName _id formtype');
    if(bankname == null || bankname == ''){
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/ot/aadhar/create_case');
    }
    const excelData = excelToJson({sourceFile: dest,
    sheets:[{
    // Excel Sheet Name
    name: 'Sheet1',
    // Header Row -> be skipped and will not be present at our result object.
    header:{
    rows: 1
    },
    // Mapping columns to keys
    columnToKey: {
    B: 'leadid',
    C: 'applicantname',
    D: 'cardno',
    E: 'totalincome',
    F: 'statementyear',
    G: 'applicantbankaddress',
    H: 'city',
    I: 'location',
    J: 'branchcode',
    K: 'typeofloan',
    L: 'grosstotal',
    M: 'officename',
    N: 'permanentaddress',
    O: 'co_applicantname',
    P: 'guarantorname',
    Q: 'applicantemail',
    R: 'contact',
    S: 'ddaid',
    
    }
    }]
    });
    excelData.Sheet1.map((cv, ind, arr)=>{
    excelData.Sheet1[ind].adminid=adminID;
    excelData.Sheet1[ind].bankid=Bank;
    excelData.Sheet1[ind].bankname=bankname.BankName;
    excelData.Sheet1[ind].uploader=req.user._id;
    excelData.Sheet1[ind].formtype=bankname.formtype;
    excelData.Sheet1[ind].casetype="itr";
    excelData.Sheet1[ind].Reciveddate=req.body.Reciveddate;
    });
  try{
      verificationModel.insertMany(excelData.Sheet1,function(error, docs) {
    if(error){
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/ot/itr/create_case');
    }
   });
    req.flash('success_msg', 'Successfully Inserted!!');
    res.redirect('/auth/ot/itr/index');
  }catch(err){
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/ot/itr/create_case');
  }
};
exports.getfillcheckmail = async (req, res, next) => {
  let dataId= req.params.id;
  
  const userID=req.user.admin_id;
  try{
    await verificationModel.findOneAndUpdate({'_id':dataId,'adminid':userID}, {'Mailsentto':req.body.Mailsentto,'Mailsentby':req.user.name,'Mailsentdate':req.body.Mailsentdate,'status':6});
    res.redirect('back');
  }catch(err){
    console.log('Data Not Fetched');
  }
};
exports.getcreatepdf = async (req, res, next) => {
    let dataId= req.params.id;
    
  const userID=req.user.admin_id;
    try {
        (async () => {
            var fullUrl = req.protocol + '://' + req.get('host');
            const a1= await verificationModel.findOne({'_id':dataId,'adminid':userID}, {'formtype':1,'Reciveddate':1 });
            let userData = await cardcaseModel.findOne({'caseid':dataId,'adminid':userID}).lean();
            
                let userPDFData = {
                    "leadid": userData.leadid,
                    "applicantname": userData.applicantname,
                    "contact": userData.contact,
                    "officename": userData.officename,
                    "officeaddress": userData.officeaddress,
                    "co_applicantname": userData.co_applicantname,
                    "guarantorname": userData.guarantorname,
                    "applicantemail": userData.applicantemail,
                    "location": userData.location,
                    "city": userData.city,
                    "branchcode": userData.branchcode,
                    "typeofloan": userData.typeofloan,
                    "ddaid": userData.ddaid,
                    "cardno": userData.cardno,
                    "acknowledgeno": userData.acknowledgeno,
                    "assesmentyesr":userData.assesmentyesr,
                    "formno": userData.formno,
                    "bankname": userData.bankname,
                    "otname": userData.otname,
                    "Reciveddate": userData.Reciveddate,
                    "casetype": userData.casetype,
                    "ufone": userData.ufone,
                    "uftwo": userData.uftwo,
                    "ufthree": userData.ufthree,
                    "uffour": userData.uffour,
                    "uffive": userData.uffive,
                    "ufsix": userData.ufsix,
                    "ufseven": userData.ufseven,
                    "ufeight": userData.ufeight,
                    "ufnine": userData.ufnine,
                    "uften": userData.uften,
                    "ufeleven": userData.ufeleven,
                    "uftwelve": userData.uftwelve,
                    "ufthirteen": userData.ufthirteen,
                    "uffourteen": userData.uffourteen,
                    "uffifteen": userData.uffifteen,
                    "ufsixteen": userData.ufsixteen,
                    "ufseventeen": userData.ufseventeen,
                    "ufeighteen": userData.ufeighteen,
                    "ufnineteen": userData.ufnineteen,
                    "uftwenty": userData.uftwenty,
                    "finalstatus": userData.finalstatus,
                    "finalremark": userData.finalremark,
                    "updatedAt": userData.updatedAt,
                    "grosstotal":userData.grosstotal,
                    "otname": userData.otname,
                    "fename": userData.fename,
                };
            
                userPDFData["images"] = await imagesModel.find({'caseid':dataId}).lean();
                userPDFData["images"].forEach(function(c, await){
                    c["finalink"] = `${fullUrl}/${c.image}`;
                    });
                userPDFData["maildate"] = a1.Reciveddate.toLocaleString();
                userPDFData["headernameimage"] = `${fullUrl}/images/logo/SB Express VB2.jpg`;
                userPDFData["headervbimage"] = `${fullUrl}/images/logo/vblogo.jpg`;
                userPDFData["authsignature"] = `${fullUrl}/images/logo/`+a1.formtype+`sign.jpg`;
                userPDFData["signaturetransback"] = `${fullUrl}/images/logo/`+a1.formtype+`signaturetransback.png`;
                
                userPDFData["baseurlforimg"] = `${fullUrl}`;

            ejs.renderFile(path.join(__dirname, '../../../', 'templates/'+a1.formtype, 'itr.ejs'), userPDFData, {}, function (err, html) {
                if (err) {
                    console.log(err)
                    return res.send({
                        "success": false,
                        "message": err,
                        "data": null
                    })
                }
 return res.send(html);
                // Generate HTML to PDF
                let options = {
                    format: "A4", // allowed units: A3, A4, A5, Legal, Letter, Tabloid
                    orientation: "portrait", // portrait or landscape
                    
                };
                htmlPdf.create(html, options).toStream(async (err, stream) => {
                    if (err) {
                        return res.json({
                            "success": false,
                            "message": "Something went wrong",
                            "data": null,
                            "error": err
                        });
                    } else {
                        res.set("Content-type", "application/pdf");
                        stream.pipe(res);
                    }
                });
            });
        })();
    } catch (err) {
        return res.json({
            "success": false,
            "message": "Something went wrong",
            "data": null
        })
    }
};