const firebase = require('firebase-admin');
const serviceAccount = require('../../../config/verificationbazaar-firebase-adminsdk-8xlld-11c7699917.json');

firebase.initializeApp({
  credential: firebase.credential.cert(serviceAccount),
  databaseURL: 'https://console.firebase.google.com/project/verificationbazaar/'
});

function sendNotificationToDevice(firebaseToken) {
  const payload = {
    notification: {
      title: 'New Cases',
      body: 'Check your App for new case',
    }
  };

  const options = {
    priority: 'high',
    timeToLive: 60 * 60 * 24, // 1 day
  };

  return firebase.messaging().sendToDevice(firebaseToken, payload, options);
}

module.exports = { sendNotificationToDevice };
