var verificationModel= require('../../../models/physicalverification/caselist');
var verificationdoneModel= require('../../../models/physicalverification/residencecases');
var imagesModel= require('../../../models/physicalverification/resiimages');
var bank= require('../../../models/CorporateClients');
var feteam= require('../../../models/feteam');
const fs = require('fs');
const excelToJson = require('convert-excel-to-json');
var feteam= require('../../../models/feteam');
const { sendNotificationToDevice } = require('./notificationController');
const htmlPdf = require("html-pdf");

const path = require("path");
const ejs = require("ejs");
const moment = require("moment");

exports.getindex = async (req, res, next) => {
  try{
    res.render('operation/physical/residence/index', { title: 'Case List', getData:null });
  }catch(err){
    console.log('Data Not Fetched:',err);
  }
};
async function paginatedResults(req,status) {

    var results = {};
    const adminID=req.user.admin_id;
    var draw = req.query.draw;
    results.draw =draw;
    var startIndex = parseInt(req.query.start);
    var limit = parseInt(req.query.length);
    var order_data = req.query.order;
    const search_value = req.query.search['value'];
    let sortObj = {};
        if (order_data) {
        const column_index = req.query.order[0]['column'];
        const column_name = req.query.columns[column_index]['data'];
        const column_sort_order = req.query.order[0]['dir'];
        sortObj[column_name] = column_sort_order;
        } else {
        sortObj = { _id: 'desc' };
        }
        results.total_records= await verificationModel.find({'adminid':adminID,'status':status,'casetype':'Residence'}).countDocuments();
        if(!search_value){
        results.total_filter_records =parseInt(results.total_records);
        results.data = await verificationModel.find({ adminid: adminID,'casetype':'Residence',status:status},{  _id: 1, applicantname: 1,officename: 1,co_applicantname: 1,otname:1, contact: 1, permanentaddress: 1, permanentpincode: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1, fename:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        }else{
        results.data = await verificationModel.find({ adminid: adminID,'casetype':'Residence',status:status, $text: {$search: search_value}},{  _id: 1, applicantname: 1,officename: 1,co_applicantname: 1,otname:1, contact: 1, permanentaddress: 1, permanentpincode: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1, fename:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        results.total_filter_records = await verificationModel.find({ adminid: adminID,'casetype':'Residence',status:status, $text: {$search: search_value}}).countDocuments(); 
        }
    return results;
}
async function paginatedassigneddataResults(req,status) {

    var results = {};
    const adminID=req.user.admin_id;
    var draw = req.query.draw;
    results.draw =draw;
    var startIndex = parseInt(req.query.start);
    var limit = parseInt(req.query.length);
    var order_data = req.query.order;
    const search_value = req.query.search['value'];
    let sortObj = {};
        if (order_data) {
        const column_index = req.query.order[0]['column'];
        const column_name = req.query.columns[column_index]['data'];
        const column_sort_order = req.query.order[0]['dir'];
        sortObj[column_name] = column_sort_order;
        } else {
        sortObj = { _id: 'desc' };
        }
        results.total_records= await verificationModel.find({'adminid':adminID,'casetype':'Residence',status: { $gt: 1, $lt:4}}).countDocuments();
        if(!search_value){
        results.total_filter_records =parseInt(results.total_records);
        results.data = await verificationModel.find({ adminid: adminID,'casetype':'Residence',status: { $gt: 1, $lt:4}},{  _id: 1, applicantname: 1,officename: 1,co_applicantname: 1, contact: 1, permanentaddress: 1, permanentpincode: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1, fename:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        }else{
        results.data = await verificationModel.find({ adminid: adminID,'casetype':'Residence',status: { $gt: 1, $lt:4}, $text: {$search: search_value}},{  _id: 1, applicantname: 1,officename: 1,co_applicantname: 1, contact: 1, permanentaddress: 1, permanentpincode: 1, city: 1, bankname: 1, formtype: 1,Reciveddate:1, fename:1 }).sort(sortObj).limit(limit).skip(startIndex).exec();
        results.total_filter_records = await verificationModel.find({ adminid: adminID,'casetype':'Residence',status: { $gt: 1, $lt:4}, $text: {$search: search_value}}).countDocuments(); 
        }
    return results;
}
exports.getdata = async (req, res, next) => {
    var result = await paginatedResults(req, 1);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        console.log(row);
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'contact' : row.contact,
            'permanentaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'formtype' : row.formtype,
            'action' : '<a href="/auth/ot/residence/assign-case/'+row._id+'" class="btn btn-success" role="button" title="ASSIGN"><i class="material-icons option-icon">move_up</i></a><a data-toggle="modal" data-target="#exampleModal'+row._id+'" class="btn btn-danger" role="button" title="Cancle Case"><i class="material-icons option-icon">close</i></a><div class="modal fade" id="exampleModal'+row._id+'" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header"><h5 class="modal-title" id="exampleModalLabel">Remark</h5><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></div><form method="post" action="/auth/ot/residence/cancele-case/'+row._id+'"><div class="modal-body"><div class="form-line"><input type="text" name="remark" class="form-control" required></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button><button type="submit" type="submit" value="submit" class="btn btn-primary">Save changes</button></div> </form></div></div></div>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
};
exports.getassigned = async (req, res, next) => {
  try{
    res.render('operation/physical/residence/assigned', { title: 'Case List', getData:null, page:'Assigned' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};

exports.getassigneddata = async (req, res, next) => {
    var result = await paginatedassigneddataResults(req, 3);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'contact' : row.contact,
            'permanentaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'fename' : row.fename,
            'formtype' : row.formtype,
           'action' : '<a href="/auth/ot/residence/assign-case/'+row._id+'" class="btn btn-success" role="button" title="ASSIGN"><i class="material-icons option-icon">move_up</i></a><a data-toggle="modal" data-target="#exampleModal'+row._id+'" class="btn btn-danger" role="button" title="Cancle Case"><i class="material-icons option-icon">close</i></a><div class="modal fade" id="exampleModal'+row._id+'" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header"><h5 class="modal-title" id="exampleModalLabel">Remark</h5><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></div><form method="post" action="/auth/ot/residence/cancele-case/'+row._id+'"><div class="modal-body"><div class="form-line"><input type="text" name="remark" class="form-control" required></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button><button type="submit" type="submit" value="submit" class="btn btn-primary">Save changes</button></div> </form></div></div></div>'
       });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
};

exports.getdonefe = async (req, res, next) => {
  try{
    res.render('operation/physical/residence/done_fe', { title: 'Case List', getData:null, page:':Done By FE' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};
exports.getdonefedata = async (req, res, next) => {
    var result = await paginatedResults(req, 4);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
             'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'contact' : row.contact,
            'permanentaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'fename' : row.fename,
            'formtype' : row.formtype,
           
            'action' : '<a href="/auth/ot/residence/checkdata/'+row._id+'" class="btn btn-success" role="button" title="Data Check"><i class="material-icons option-icon">assignment_turned_in</i></a><a data-toggle="modal" data-target="#exampleModal'+row._id+'" class="btn btn-danger" role="button" title="Cancle Case"><i class="material-icons option-icon">close</i></a><div class="modal fade" id="exampleModal'+row._id+'" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header"><h5 class="modal-title" id="exampleModalLabel">Remark</h5><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></div><form method="post" action="/auth/ot/residence/cancele-case/'+row._id+'"><div class="modal-body"><div class="form-line"><input type="text" name="remark" class="form-control" required></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button><button type="submit" type="submit" value="submit" class="btn btn-primary">Save changes</button></div> </form></div></div></div>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
};

exports.getdonebyot = async (req, res, next) => {
  try{
    res.render('operation/physical/residence/done_by_ot', { title: 'Case List', getData:null, page:'Done by OT' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};

exports.getdonebyotdata = async (req, res, next) => {
    var result = await paginatedResults(req, 5);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
             'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'contact' : row.contact,
            'permanentaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'fename' : row.fename,
            'formtype' : row.formtype,
            'otname' : row.otname,
             'action' : `<a href="/auth/ot/residence/checkdata/${row._id}" class="btn btn-success" role="button" title="Data Check"><i
    class="material-icons option-icon">assignment_turned_in</i></a><a data-toggle="modal"
  data-target="#exampleModal${row._id}" class="btn btn-success" role="button" title="Data Check"><i
    class="material-icons option-icon">alternate_email</i></a>
    <a data-toggle="modal"
    data-target="#cancleModal${row._id}" class="btn btn-danger" role="button" title="Cancle Case"><i
        class="material-icons option-icon">close</i></a>
<div class="modal fade" id="exampleModal${row._id}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Select Mail Date</h5><button type="button" class="close"
                    data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <form method="post" action="/auth/ot/residence/checkmail/${row._id}">
                <div class="modal-body">
                    <div class="form-line"><input type="email" name="Mailsentto" class="form-control"
                            placeholder="Mail Sent To" required></div>
                    <div class="form-line"><input type="datetime-local" name="Mailsentdate" class="form-control"
                            required></div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary"
                            data-dismiss="modal">Close</button><button type="submit" type="submit" value="submit"
                            class="btn btn-primary">Save changes</button></div>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="cancleModal${row._id}" tabindex="-1" role="dialog" aria-labelledby="cancleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cancleModalLabel">Remark</h5><button type="button" class="close"
                    data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <form method="post" action="/auth/ot/residence/cancele-case/${row._id}">
                <div class="modal-body">
                    <div class="form-line"><input type="text" name="remark" class="form-control" required></div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary"
                            data-dismiss="modal">Close</button><button type="submit" type="submit" value="submit"
                            class="btn btn-primary">Save changes</button> </div>
                </div>
            </form>
        </div>
    </div>
</div>` });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
};
exports.getcompleted = async (req, res, next) => {
  try{
    res.render('operation/physical/residence/completed', { title: 'Case List', getData:null, page:'Completed' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};
exports.getcompleteddata = async (req, res, next) => {
    var result = await paginatedResults(req, 6);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
             'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'contact' : row.contact,
            'permanentaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'fename' : row.fename,
            'formtype' : row.formtype,
            'otname' : row.otname,
            'action' : '<a href="/auth/ot/residence/create_pdf?id='+row._id+'&wollet=9" class="btn btn-success" role="button" title="Data Check" target="_blank"><i class="material-icons option-icon">picture_as_pdf</i></a>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
};
exports.getcancelled = async (req, res, next) => {
  
  try{
    res.render('operation/physical/residence/cancelled', { title: 'Case List', getData:null, page:'Cancelled' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};
exports.getcancelleddata = async (req, res, next) => {
    var result = await paginatedResults(req, 7);
    try{
    var data_arr = [];
    var completedata =result.data;
    completedata.forEach(function(row, index){
        if(!row.co_applicantname){
            row.co_applicantname = 'NA';
        }
        data_arr.push({
            'indexing' : index + 1,
            'Reciveddate' : row.Reciveddate.toLocaleString(),
            'applicantname' : row.applicantname,
            'contact' : row.contact,
            'permanentaddress' : row.permanentaddress,
            'city' : row.city,
            'permanentpincode' : row.permanentpincode,
            'bankname' : row.bankname,
            'fename' : row.fename,
            'formtype' : row.formtype,
            'action' : '<a href="/auth/ot/residence/cancele-case/'+row._id+'" class="btn btn-danger" role="button" title="CANCELLED"><i class="material-icons option-icon">close</i></a>'
        });
    });
    var output = {
                    'title': 'Case List',
                    'getData':null,
                    'draw' : result.draw,
                    'iTotalRecords' : result.total_records,
                    'iTotalDisplayRecords' : result.total_filter_records,
                    'aaData' : data_arr
                };
                res.json(output);
  }catch(err){
    console.log('Data Not Fetched Error:' +err);
  }
};

// Create cases 
exports.createcase = async (req, res, next) => {
    
    const adminID=req.user.admin_id;
    try{
    const viewDatas= await bank.find({'adminid':adminID,'status':'Active'}, '_id BankName').sort('BankName').exec();
    if(viewDatas == null || viewDatas == ''){
        req.flash('error_msg', 'Please Add Bank!!');
        res.redirect('/auth/ot/residence/index');
    }
    res.render('operation/physical/residence/create', { title: 'Create Case', viewDatas,adminID, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')}});
    }catch(err){
    console.log('Data Not Fetched');
  }
};

/* Download Format*/
exports.DownloadFormat = async (req, res, next) => {
  const dest = imageBaseDir+'images/uploads/cases/format/physicalformat/'+req.params.format+'residence.xlsx';
res.download(dest);
};

/* to insert admin data */
exports.postcreatecases = async (req, res, next) => {
    const adminID = req.body.adminID;
    const Bank = req.body.bankID;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/'+Bank+'/physicalexcel/residence/'+datefolder+'/'+req.file.filename;
     const bankname= await bank.findOne({'_id':Bank,'adminid':adminID}, 'BankName _id formtype');
    if(bankname == null || bankname == ''){
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/ot/aadhar/create_case');
    }
    const excelData = excelToJson({sourceFile: dest,
    sheets:[{
    // Excel Sheet Name
    name: 'Sheet1',
    // Header Row -> be skipped and will not be present at our result object.
    header:{
    rows: 1
    },
    // Mapping columns to keys
    columnToKey: {
    B: 'leadid',
    C: 'applicantname',
    D: 'co_applicantname',
    E: 'contact',
    F: 'permanentaddress',
    G: 'permanentpincode',
    H: 'city',
    I: 'location',
    J: 'branchcode',
    K: 'typeofloan',
    L: 'ddaid',
    M: 'guarantorname',
    N: 'applicantemail',
    O: 'presentaddress',
    
    
    }
    }]
    });
    excelData.Sheet1.map((cv, ind, arr)=>{
    excelData.Sheet1[ind].adminid=adminID;
    excelData.Sheet1[ind].bankid=Bank;
    excelData.Sheet1[ind].bankname=bankname.BankName;
    excelData.Sheet1[ind].uploader=req.user._id;
    excelData.Sheet1[ind].formtype=bankname.formtype;
    excelData.Sheet1[ind].casetype="Residence";
    excelData.Sheet1[ind].Reciveddate=req.body.Reciveddate;
    });
  try{
      verificationModel.insertMany(excelData.Sheet1,function(error, docs) {
    if(error){
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/ot/residence/create_case');
    }
   });
    req.flash('success_msg', 'Successfully Inserted!!');
    res.redirect('/auth/ot/residence/index');
  }catch(err){
    req.flash('error_msg', 'Failed To Insert!!');
    res.redirect('/auth/ot/residence/create_case');
  }
};

exports.getcancellecasedata = async (req, res, next) => {
  let dataId= req.params.id;
  
  const userID=req.user.admin_id;
  try{
     const a1= await verificationModel.findOneAndUpdate({'_id':dataId,'adminid':userID}, {'casestatus':req.body.remark,'status':7,'cancleby':req.user.name });
    res.redirect('back');
  }catch(err){
    console.log('Data Not Fetched');
  }
};

exports.getassigncaseadddata = async (req, res, next) => {
  let dataId= req.params.id;
  
  const userID=req.user.admin_id;
  try{
     const data= await feteam.find({'status':'Active','admin_id':userID}).sort({name: 'asc'}).exec();
    res.render('operation/physical/residence/assign', { title: 'Case List', getData:data, getId:dataId, page:'Assign' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};

exports.getassigncaseadddonedata = async (req, res, next) => {
  const dataId = req.body.getId;
  const userID = req.user.admin_id;

  try {
    const a1 = await verificationModel.findOneAndUpdate(
      { '_id': dataId, 'adminid': userID },
      { 'status': 2, 'fename': req.body.fename, 'feid': req.body.feid, 'assignby': req.user._id }
    );

    try {
      const firebaseToken = await feteam.findOne({'_id': req.body.feid}).select('fcmToken');
      if (firebaseToken) {
        const response = await sendNotificationToDevice(firebaseToken.fcmToken);
        console.log('Successfully sent notification:', response);
      } else {
        console.error('FCM Token not found for the selected team member.');
      }
    } catch (error) {
      console.error('Error sending notification:', error);
    }

    res.redirect('/auth/ot/residence/index');
  } catch (err) {
    console.log('Data Not Fetched');
  }
};

exports.getfillcheckdata = async (req, res, next) => {
  let dataId= req.params.id;
  
  const userID=req.user.admin_id;
  try{
      const a1= await verificationModel.findOne({'_id':dataId,'adminid':userID}, {'formtype':1 });
     const data= await verificationdoneModel.findOne({'caseid':dataId,'adminid':userID}).exec();
     const image= await imagesModel.find({'caseid':dataId,'reportid':data._id}).exec();
    res.render('operation/physical/residence/updateform'+a1.formtype, { title: 'Case List', getData:data, getimage:image, page:'Assign' });
  }catch(err){
    console.log('Data Not Fetched');
  }
};
exports.postupdatecasesadd = async (req, res, next) => {
   
  let dataId= req.body.id;
  let caseId= req.body.caseid;
  
  const userID=req.user.admin_id;
  try{
      const a1= await verificationModel.findOne({'_id':caseId,'adminid':userID}, {'otid':1 });
      if(a1.otid !=null && a1.otid != req.user._id){
          res.redirect('back');
      }
      await verificationdoneModel.findByIdAndUpdate(dataId, {
      permanentaddress:req.body.permanentaddress,
      ufone:req.body.ufone,
      uftwo:req.body.uftwo,
      ufthree:req.body.ufthree,
      uffour:req.body.uffour,
      uffive:req.body.uffive,
      ufsix:req.body.ufsix,
      ufseven:req.body.ufseven,
      ufeight:req.body.ufeight,
      ufnine:req.body.ufnine,
      uften:req.body.uften,
      ufeleven:req.body.ufeleven,
      uftwelve:req.body.uftwelve,
      ufthirteen:req.body.ufthirteen,
      uffourteen:req.body.uffourteen,
      uffifteen:req.body.uffifteen,
      ufsixteen:req.body.ufsixteen,
      ufseventeen:req.body.ufseventeen,
      ufeighteen:req.body.ufeighteen,
      ufnineteen:req.body.ufnineteen,
      uftwenty:req.body.uftwenty,
      uftwentyone:req.body.uftwentyone,
      uftwentytwo:req.body.uftwentytwo,
      uftwentythree:req.body.uftwentythree,
      uftwentyfour:req.body.uftwentyfour,
      uftwentyfive:req.body.uftwentyfive,
      uftwentysix:req.body.uftwentysix,
      uftwentyseven:req.body.uftwentyseven,
      uftwentyeight:req.body.uftwentyeight,
      uftwentynine:req.body.uftwentynine,
      ufthirty:req.body.ufthirty,
      ufthirtyone:req.body.ufthirtyone,
      ufthirtytwo:req.body.ufthirtytwo,
      ufthirtythree:req.body.ufthirtythree,
      ufthirtyfour:req.body.ufthirtyfour,
      ufthirtyfive:req.body.ufthirtyfive,
      ufthirtysix:req.body.ufthirtysix,
      ufthirtyseven:req.body.ufthirtyseven,
      ufthirtyeight:req.body.ufthirtyeight,
      ufthirtynine:req.body.ufthirtynine,
      ufforty:req.body.ufforty,
      uffortyone:req.body.uffortyone,
      uffortytwo:req.body.uffortytwo,
      uffortythree:req.body.uffortythree,
      uffortyfour:req.body.uffortyfour,
      uffortyfive:req.body.uffortyfive,
      uffortysix:req.body.uffortysix,
      uffortyseven:req.body.uffortyseven,
      uffortyeight:req.body.uffortyeight,
      uffortynine:req.body.uffortynine,
      uffifty:req.body.uffifty,
      uffiftyone:req.body.uffiftyone,
      uffiftytwo:req.body.uffiftytwo,
     
      uffifty:req.body.uffifty,
      reason1:req.body.reason1,
      reason2:req.body.reason2,
      reason3:req.body.reason3,
      reason4:req.body.reason4,
      reason5:req.body.reason5,
      reason6:req.body.reason6,
      reason7:req.body.reason7,
      finalstatus:req.body.finalstatus,
      finalremark:req.body.finalremark,
      otid:req.user._id,
      otname:req.user.name
      });
      
     await verificationModel.findByIdAndUpdate(req.body.caseid, {'casestatus':req.body.finalstatus,'status':5,'otid':req.user._id, 'otname':req.user.name, 'otdonedate':new Date()});
   
    res.redirect('back');
  }catch(err){
    console.log('Data Not Fetched');
  }
};


exports.getfillcheckmail = async (req, res, next) => {
  let dataId= req.params.id;
  
  const userID=req.user.admin_id;
  try{
    await verificationModel.findOneAndUpdate({'_id':dataId,'adminid':userID}, {'Mailsentto':req.body.Mailsentto,'Mailsentby':req.user.name,'Mailsentdate':req.body.Mailsentdate,'status':6});
    res.redirect('back');
  }catch(err){
    console.log('Data Not Fetched');
  }
};
exports.addimages = async (req, res, next) => {
  
  const userID=req.user.admin_id;
  const event = new Date();
    const datefolder = event.toDateString();
  try{
                    req.files.residence.map((cv, ind, arr)=>{
                    req.files.residence[ind].caseid=req.body.caseid;
                    req.files.residence[ind].fecode=req.user._id;
                    req.files.residence[ind].reportid=req.body.donecaseid;
                    req.files.residence[ind].image=`images/uploads/cases/uploads/${userID}/physicalcases/residence/${datefolder}/${arr[ind].filename}`;
                    });
                    imagesModel.insertMany(req.files.residence);
    res.redirect('back');
  }catch(err){
    console.log('Data Not Fetched');
  }
};
exports.removeimages = async (req, res, next) => {
  let dataId= req.params.id;
  
  const userID=req.user.admin_id;
  try{
       var getData = await imagesModel.findOne({'_id':dataId}).exec();
      
         if(getData.image != '' && getData.image != null && getData.image != undefined){
            if (fs.existsSync(imageBaseDir+getData.image)) {
              fs.unlinkSync(imageBaseDir+getData.image);
            }
         }
         var getData = await imagesModel.findOneAndDelete({'_id':dataId}).exec();
    res.redirect('back');
  }catch(err){
    console.log('Data Not Fetched');
  }
};

exports.getcreatepdf = async (req, res, next) => {
    let dataId= req.query.id;
    let walletphoto= req.query.wollet;
    
  const userID=req.user.admin_id;
    try {
        (async () => {
            var fullUrl = req.protocol + '://' + req.get('host');
            
            const a1= await verificationModel.findOne({'_id':dataId,'adminid':userID}, {'formtype':1,'Reciveddate':1 });
            if(!a1){
              res.redirect('back');  
            }
            let userData = await verificationdoneModel.findOne({'caseid':dataId,'adminid':userID}).lean();
            
            
                 let userPDFData = {
                "leadid": userData.leadid,
                    "walletphoto":walletphoto,
                    "applicantname": userData.applicantname,
                    "contact": userData.contact,
                   "co_applicantname": userData.co_applicantname,
                   "guarantorname": userData.guarantorname,
                   "applicantemail": userData.applicantemail,
                    "permanentaddress": userData.permanentaddress,
                    "branchcode": userData.branchcode,
                    "typeofloan": userData.typeofloan,
                    "location": userData.location,
                    "city": userData.city,
                    "bankname": userData.bankname,
                    "ddaid": userData.ddaid,
                    "presentaddress": userData.presentaddress,
                    "contact": userData.contact,
                    "formtype": userData.formtype,
                    "fename": userData.fename,
                    "feid": userData.feid,
                    "Reciveddate": userData.Reciveddate,
                    "casetype": userData.casetype,
                    "ufone": userData.ufone,
                    "uftwo": userData.uftwo,
                    "ufthree": userData.ufthree,
                    "uffour": userData.uffour,
                    "uffive": userData.uffive,
                    "ufsix": userData.ufsix,
                    "ufseven": userData.ufseven,
                    "ufeight": userData.ufeight,
                    "ufnine": userData.ufnine,
                    "uften": userData.uften,
                    "ufeleven": userData.ufeleven,
                    "uftwelve": userData.uftwelve,
                    "ufthirteen": userData.ufthirteen,
                    "uffourteen": userData.uffourteen,
                    "uffifteen": userData.uffifteen,
                    "ufsixteen": userData.ufsixteen,
                    "ufseventeen": userData.ufseventeen,
                    "ufeighteen": userData.ufeighteen,
                    "ufnineteen": userData.ufnineteen,
                    "uftwenty": userData.uftwenty,
                    "uftwentyone": userData.uftwentyone,
                    "uftwentytwo": userData.uftwentytwo,
                    "uftwentythree": userData.uftwentythree,
                    "uftwentyfour": userData.uftwentyfour,
                    "uftwentyfive": userData.uftwentyfive,
                    "uftwentysix": userData.uftwentysix,
                    "uftwentyseven": userData.uftwentyseven,
                    "uftwentyeight": userData.uftwentyeight,
                    "uftwentynine": userData.uftwentynine,
                    "ufthirty": userData.ufthirty,
                    "ufthirtyone": userData.ufthirtyone,
                    "ufthirtytwo": userData.ufthirtytwo,
                    "ufthirtythree": userData.ufthirtythree,
                    "ufthirtyfour": userData.ufthirtyfour,
                    "ufthirtyfive": userData.ufthirtyfive,
                    "ufthirtysix": userData.ufthirtysix,
                    "ufthirtyseven": userData.ufthirtyseven,
                    "ufthirtyeight": userData.ufthirtyeight,
                    "ufthirtynine": userData.ufthirtynine,
                    "ufforty": userData.ufforty,
                    "uffortyone": userData.uffortyone,
                    "uffortytwo": userData.uffortytwo,
                    "uffortythree": userData.uffortythree,
                    "uffortyfour": userData.uffortyfour,
                    "uffortyfive": userData.uffortyfive,
                    "uffortysix": userData.uffortysix,
                    "uffortyseven": userData.uffortyseven,
                    "uffortyeight": userData.uffortyeight,
                    "uffortynine": userData.uffortynine,
                    "uffifty": userData.uffifty,
                    "feremark":userData.feremark,
                    "updatedAt":userData.updatedAt,
                    "finalstatus":userData.finalstatus,
                    "finalremark":userData.finalremark,
                     "otname":userData.otname,
            };
            
            
                userPDFData["images"] = await imagesModel.find({'caseid':dataId}).lean().exec();
                userPDFData["images"].forEach(function(c, await){
                    c["finalink"] = `${fullUrl}/${c.image}`;
                    });
                userPDFData["maildate"] = a1.Reciveddate.toLocaleString();
                userPDFData["headernameimage"] = `${fullUrl}/images/logo/SB Express VB2.jpg`;
                userPDFData["headervbimage"] = `${fullUrl}/images/logo/vblogo.jpg`;
                userPDFData["authsignature"] = `${fullUrl}/images/logo/`+a1.formtype+`sign.jpg`;
                userPDFData["baseurlforimg"] = `${fullUrl}`;
            ejs.renderFile(path.join(__dirname, '../../../', 'templates/'+a1.formtype, 'residence.ejs'), userPDFData, {}, function (err, html) {
                if (err) {
                    console.log(err)
                    return res.send({
                        "success": false,
                        "message": err,
                        "data": null
                    })
                }
                return res.send(html);

                // Generate HTML to PDF
                let options = {
                    format: "A4", // allowed units: A3, A4, A5, Legal, Letter, Tabloid
                    orientation: "portrait", // portrait or landscape
                    quality: "50",
                    
                };
                htmlPdf.create(html, options).toStream(async (err, stream) => {
                    if (err) {
                        return res.json({
                            "success": false,
                            "message": "Something went wrong",
                            "data": null,
                            "error": err
                        });
                    } else {
                        res.set("Content-type", "application/pdf");
                        stream.pipe(res);
                    }
                });
            });
        })();
    } catch (err) {
        return res.json({
            "success": false,
            "message": "Something went wrong",
            "data": null
        })
    }
};