var verificationModel= require('../../models/physicalverification/caselist');
var bank= require('../../models/CorporateClients');

exports.getmis = async (req, res, next) => {
    
    const adminID=req.user.admin_id;
  try{
        var filterfields = {
                    'bankid':"nullc",
                    'casetype':"nullc",
                    'formatform':"nullc",
                    'datefrom':"nullc",
                    'dateto':"nullc",
                };
        const viewDatas= await bank.find({'adminid':adminID}, '_id BankName').sort('BankName').exec();
        res.render('operation/reports/misreport', { title: 'Mis Report', getData:viewDatas, veridata:null,filterfields, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')} });
  }catch(err){
    console.log('Data Not Fetched:',err);
  }
};
exports.postmis = async (req, res, next) => {
    
    const adminID=req.user.admin_id;
  try{
        var filterfields = {
                    'datefrom': new Date(req.body.datefrom).valueOf(),
                    'dateto': new Date(req.body.dateto).valueOf(),
                    'formatform': req.body.format,
                    'bankid': req.body.bank,
                    'casetype': req.body.type,
                };
        var start = new Date(req.body.datefrom).setHours(0, 0, 1);
        var end = new Date(req.body.dateto).setHours(23, 59, 59);
        var filter = {
                    'adminid': adminID,
                    'Reciveddate': { $gt: start, $lt: end},
                };
        if(req.body.format !=="nullc"){
            filter["formtype"] = req.body.format;
        };
        if(req.body.bank !=="nullc"){
            filter["bankid"] = req.body.bank;
        };
        if(req.body.type !=="nullc"){
            filter["casetype"] = req.body.type;
        };
        const veridata = await verificationModel.find(filter).populate('uploader','name').populate('bankid','name').exec();
        const viewDatas= await bank.find({'adminid':adminID}, '_id BankName').sort('BankName').exec();
        req.flash('success_msg', 'Data Successfully Filtered!!');
        res.render('operation/reports/misreport', { title: 'Mis Report', getData:viewDatas, veridata:veridata, filterfields, alertMessage:{'success':req.flash('success_msg'), 'error':req.flash('error_msg')} });
  }catch(err){
    console.log('Data Not Fetched:',err);
  }
};

exports.reportsearch = async (req, res, next) => {
    try {
        const adminID=req.user.admin_id;
        const draw = req.query.draw;
        const startIndex = parseInt(req.query.start);
        const limit = parseInt(req.query.length);
        const order_data = req.query.order;
        const search_value = req.query.search['value'];
        const sortObj = {};

        if (order_data) {
            const column_index = req.query.order[0]['column'];
            const column_name = req.query.columns[column_index]['data'];
            const column_sort_order = req.query.order[0]['dir'];
            sortObj[column_name] = column_sort_order;
        } else {
            sortObj._id = 'desc';
        }

        const results = await paginatedResults(adminID, draw, startIndex, limit, order_data, search_value, sortObj);

        const output = {
            title: 'Case List',
            getData: null,
            draw: results.draw,
            iTotalRecords: results.total_records,
            iTotalDisplayRecords: results.total_filter_records,
            aaData: results.data,
        };

        res.json(output);
    } catch (err) {
        console.log('Data Not Fetched Error:', err);
    }
};
exports.updatemail = async (req, res, next) => {
    try {
        const tableData = JSON.parse(req.body.tableData);
      const uniqueID = req.body.uniqueid || (await generateUniqueID());
        for (const data of tableData) {
            // Extract the relevant data from the inner array
            const [name, bankName, caseType, dataId] = data;

            // Update the document based on the dataId
            await verificationModel.findOneAndUpdate(
                { '_id': dataId },
                {   'uniqueID':uniqueID,
                    'Mailsentto': req.body.mailto,
                    'Mailsentby': req.user.name,
                    'Mailsentdate': req.body.Mailsentdate,
                    'status': 6
                }
            );
        }
        res.redirect('back');
    } catch (err) {
        console.log('Data Not Fetched:', err);
    }
};

async function paginatedResults(adminID, draw, startIndex, limit, order_data, search_value, sortObj) {
    const results = {
        draw: draw,
        total_records: 0,
        total_filter_records: 0,
        data: [],
    };

    if (!search_value) {
        return results;
    }

    const query = {
        adminid: adminID,
        $or: [
            { applicantname: { $regex: search_value, $options: 'i' } },
            { contact: { $regex: search_value, $options: 'i' } },
            { uniqueID: { $regex: search_value, $options: 'i' } },
        ],
    };

    results.data = await verificationModel.find(query).sort(sortObj).limit(limit).skip(startIndex).exec();
    results.total_records = await verificationModel.countDocuments({ adminid: adminID }); // Count all records
    results.total_filter_records = await verificationModel.countDocuments(query); // Count filtered records

    return results;
}
async function generateUniqueID() {
  const currentDate = new Date();
  const year = currentDate.getFullYear().toString().slice(-2); // Get the last n digits of the year
  const month = (currentDate.getMonth() + 1).toString().padStart(2, '0'); // Get the current month (1-12) and pad with leading zero if necessary

  // Function to generate random characters
  function generateRandomCharacters(length, characters) {
    return Array.from({ length }, () => characters[Math.floor(Math.random() * characters.length)]).join('');
  }

  const randomAlphabets = generateRandomCharacters(2, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ');
  const randomNumbers = generateRandomCharacters(4, '0123456789');

  const uniqueID = year + month + randomAlphabets + randomNumbers;

  return uniqueID;
}
