var express = require('express');
var router = express.Router();
var bank= require('../../models/CorporateClients');
var verificationModel= require('../../models/physicalverification/caselist');
var targetModel= require('../../models/sales_target');
var bwtargetModel= require('../../models/sales_targetbw');
var sessionCheck= require('../../middleware/sessionCheck').isOpration;
const  moment = require('moment');



router.get('/daywise_summary',sessionCheck, async function(req, res, next){
  try{
    res.render('operation/summary/daywise_summary', { title: 'Summary', getData:null });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});
router.get('/monthwise_summary',sessionCheck, async function(req, res, next){
    const adminID=req.user.admin_id;
  try{
      const data =  await verificationModel.aggregate([
  {
    $match: {
      Reciveddate: {
        $gte: moment().startOf('month').subtract(2, 'months').toDate(),
        $lte: moment().endOf('month').toDate()
      },
      adminid:adminID,
      casetype: { $nin: ["tele"] },
      status: { $gt: 0, $lt:7},
    }
  },
  {
    $group: {
      _id: {
        bankname: "$bankname",
        month: {
          $dateToString: {
            format: "%Y-%m",
            date: "$Reciveddate"
          }
        }
      },
      count: {
        $sum: 1
      }
    }
  },
  {
    $group: {
      _id: "$_id.bankname",
      counts: {
        $push: {
          count: "$count",
          month: "$_id.month"
        }
      }
    }
  },
  {
    $project: {
      _id: 1,
      counts: 1
    }
  },
  {
    $unwind: "$counts"
  },
  {
    $sort: {
      "_id": 1,
      "counts.month": 1
    }
  },
  {
    $group: {
      _id: "$_id",
      counts: {
        $push: {
          count: "$counts.count",
          month: "$counts.month"
        }
      }
    }
  },
  {
    $project: {
      _id: 1,
      counts: {
        $map: {
          input: [
            moment().startOf('month').subtract(2, 'months').format("YYYY-MM"),
            moment().startOf('month').subtract(1, 'months').format("YYYY-MM"),
            moment().startOf('month').format("YYYY-MM")
          ],
          as: "month",
          in: {
            $cond: [
              {
                $in: ["$$month", "$counts.month"]
              },
              {
                $arrayElemAt: [
                  "$counts",
                  {
                    $indexOfArray: ["$counts.month", "$$month"]
                  }
                ]
              },
              {
                month: "$$month",
                count: 0
              }
            ]
          }
        }
      }
    }
  }
]);

    res.render('operation/summary/monthwise_summary', { title: 'Summary', getData:data });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});
router.get('/bankwise_summary', sessionCheck, async function(req, res, next) {
 const adminID=req.user.admin_id;
  try {
      
var formDate = req.query.formdate;
var startOfMonth, endOfMonth;

if (formDate) {
    const month = parseInt(formDate.slice(0, 2)); // Months are zero-based in JavaScript Date objects
    const year = parseInt(formDate.slice(2, 6));
  startOfMonth = moment({ year, month, day: 1 }).startOf('day');
  endOfMonth = moment({ year, month, day: 1 }).endOf('month');
} else {
  const currentDate = moment();
  startOfMonth = currentDate.clone().startOf('month');
  endOfMonth = currentDate.clone().endOf('month');
}

// Convert to JavaScript Date objects if necessary
startOfMonth = startOfMonth.toDate();
endOfMonth = endOfMonth.toDate();

// Set hours for the Date objects
startOfMonth.setHours(0, 0, 0, 0);
endOfMonth.setHours(23, 59, 59, 999);
      
var data ={};
data.monthwise = await verificationModel.aggregate([
  {
    $match: {
      Reciveddate: {
        $gte: startOfMonth,
        $lte: endOfMonth
      },
      adminid: adminID,
      casetype: { $nin: ["tele"] },
      status: { $gt: 0, $lt: 8 },
    }
  },
  {
    $group: {
      _id: "$bankname",
      totalCases: {
        $sum: 1
      },
      completedCases: {
        $sum: {
          $cond: [
            { $in: ["$status", [6]] }, 
            1,
            0
          ]
        }
      },
      pendingCases: {
        $sum: {
          $cond: [
            { $in: ["$status", [1, 2, 3, 4, 5]] }, 
            1,
            0
          ]
        }
      },
      mailpendingCases: {
        $sum: {
          $cond: [
            { $in: ["$status", [5]] }, 
            1,
            0
          ]
        }
      },
      otpendingCases: {
        $sum: {
          $cond: [
            { $in: ["$status", [4]] },
            1,
            0
          ]
        }
      },
      fependingCases: {
        $sum: {
          $cond: [
            { $in: ["$status", [ 2, 3]] },
            1,
            0
          ]
        }
      },
      unassignCases: {
        $sum: {
          $cond: [
            { $in: ["$status", [1]] }, 
            1,
            0
          ]
        }
      },
      cancleCases: {
        $sum: {
          $cond: [
            { $in: ["$status", [7]] }, 
            1,
            0
          ]
        }
      }
    }
  },
  {
    $project: {
      _id: 0,
      clientname: "$_id",
      completedCases: 1,
      pendingCases: 1,
      mailpendingCases: 1,
      otpendingCases: 1,
      fependingCases: 1,
      unassignCases: 1,
      cancleCases: 1,
      totalCases: 1
      
    }
  }
]);
data.daywise = await verificationModel.aggregate([
  {
    $match: {
      Reciveddate: {
        $gte: startOfMonth,
        $lte: endOfMonth
      },
      adminid:adminID,
      casetype: { $nin: ["tele"] },
      status: { $gt: 0, $lt: 7 },
    }
  },
  {
    $group: {
      _id: {
        bankname: "$bankname",
        day: {
          $dateToString: {
            format: "%Y-%m-%d",
            date: "$Reciveddate"
          }
        }
      },
      count: {
        $sum: 1
      }
    }
  },
  {
    $group: {
      _id: "$_id.bankname",
      counts: {
        $push: {
          count: "$count",
          day: "$_id.day"
        }
      },
      total: {
        $sum: "$count"
      }
    }
  },
  {
    $project: {
      _id: 1,
      counts: 1,
      total: 1
    }
  },
  {
    $unwind: "$counts"
  },
  {
    $sort: {
      "_id": 1,
      "counts.day": 1
    }
  },
  {
    $group: {
      _id: "$_id",
      counts: {
        $push: {
          count: "$counts.count",
          day: "$counts.day"
        }
      },
      total: {
        $first: "$total"
      }
    }
  },
  {
    $project: {
      _id: 1,
      counts: {
        $map: {
          input: Array.from({ length: moment(endOfMonth).date() }, (_, i) =>moment(startOfMonth).add(i, 'days').format("YYYY-MM-DD")),
          as: "day",
          in: {
            $cond: [
              {
                $in: ["$$day", "$counts.day"]
              },
              {
                $arrayElemAt: [
                  "$counts",
                  {
                    $indexOfArray: ["$counts.day", "$$day"]
                  }
                ]
              },
              {
                day: "$$day",
                count: 0
              }
            ]
          }
        }
      },
      total: 1
    }
  }
]);
    res.render('operation/summary/bankwise_summary', { title: 'Summary', getData: null, result: data });
  } catch (error) {
    console.log(error);
  }
});

router.get('/work_perform_oe',sessionCheck, async function(req, res, next){
 const adminID=req.user.admin_id;
  try{
        var formDate = req.query.formdate;
var startOfMonth, endOfMonth;

if (formDate) {
    const month = parseInt(formDate.slice(0, 2)); // Months are zero-based in JavaScript Date objects
    const year = parseInt(formDate.slice(2, 6));
  startOfMonth = moment({ year, month, day: 1 }).startOf('day');
  endOfMonth = moment({ year, month, day: 1 }).endOf('month');
} else {
  const currentDate = moment();
  startOfMonth = currentDate.clone().startOf('month');
  endOfMonth = currentDate.clone().endOf('month');
}

// Convert to JavaScript Date objects if necessary
startOfMonth = startOfMonth.toDate();
endOfMonth = endOfMonth.toDate();

// Set hours for the Date objects
startOfMonth.setHours(0, 0, 0, 0);
endOfMonth.setHours(23, 59, 59, 999);

      const data =  await verificationModel.aggregate([
  {
    $match: {
      Reciveddate: {
        $gte: startOfMonth,
        $lte: endOfMonth
      },
      adminid:adminID,
      status: 6,
      fename: {
        $ne: ""
        },
    }
  },
  {
    $group: {
      _id: {
        bankname: "$otname",
        day: {
          $dateToString: {
            format: "%Y-%m-%d",
            date: "$Reciveddate"
          }
        }
      },
      count: {
        $sum: 1
      }
    }
  },
  {
    $group: {
      _id: "$_id.bankname",
      counts: {
        $push: {
          count: "$count",
          day: "$_id.day"
        }
      },
      total: {
        $sum: "$count"
      }
    }
  },
  {
    $project: {
      _id: 1,
      counts: 1,
      total: 1
    }
  },
  {
    $unwind: "$counts"
  },
  {
    $sort: {
      "_id": 1,
      "counts.day": 1
    }
  },
  {
    $group: {
      _id: "$_id",
      counts: {
        $push: {
          count: "$counts.count",
          day: "$counts.day"
        }
      },
      total: {
        $first: "$total"
      }
    }
  },
  {
    $project: {
      _id: 1,
      counts: {
        $map: {
          input: Array.from({ length: moment(endOfMonth).date() }, (_, i) =>moment(startOfMonth).add(i, 'days').format("YYYY-MM-DD")),
          as: "day",
          in: {
            $cond: [
              {
                $in: ["$$day", "$counts.day"]
              },
              {
                $arrayElemAt: [
                  "$counts",
                  {
                    $indexOfArray: ["$counts.day", "$$day"]
                  }
                ]
              },
              {
                day: "$$day",
                count: 0
              }
            ]
          }
        }
      },
      total: 1
    }
  }
]);

    res.render('operation/summary/work_perform_oe', { title: 'Summary', getData:data });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});

router.get('/work_perform_fe', sessionCheck, async function(req, res, next) {
 const adminID=req.user.admin_id;
  try {
       var formDate = req.query.formdate;
var startOfMonth, endOfMonth;

if (formDate) {
    const month = parseInt(formDate.slice(0, 2)); // Months are zero-based in JavaScript Date objects
    const year = parseInt(formDate.slice(2, 6));
  startOfMonth = moment({ year, month, day: 1 }).startOf('day');
  endOfMonth = moment({ year, month, day: 1 }).endOf('month');
} else {
  const currentDate = moment();
  startOfMonth = currentDate.clone().startOf('month');
  endOfMonth = currentDate.clone().endOf('month');
}

// Convert to JavaScript Date objects if necessary
startOfMonth = startOfMonth.toDate();
endOfMonth = endOfMonth.toDate();

// Set hours for the Date objects
startOfMonth.setHours(0, 0, 0, 0);
endOfMonth.setHours(23, 59, 59, 999);
    const data = await verificationModel.aggregate([
      {
        $match: {
          fedonedate: {
            $gte:startOfMonth,
            $lte: endOfMonth
          },
          adminid: adminID,
          status: {
            $gte: 4,
            $lt: 7
          },
          fename: {
              $exists: true,
        $ne: null
        }
        }
      },
      {
        $group: {
          _id: {
            bankname: "$fename",
            day: {
              $dateToString: {
                format: "%Y-%m-%d",
                date: "$fedonedate"
              }
            }
          },
          count: {
            $sum: 1
          }
        }
      },
      {
        $group: {
          _id: "$_id.bankname",
          counts: {
            $push: {
              count: "$count",
              day: "$_id.day"
            }
          },
          total: {
            $sum: "$count"
          }
        }
      },
      {
        $project: {
          _id: 1,
          counts: 1,
          total: 1
        }
      },
      {
        $unwind: "$counts"
      },
      {
        $sort: {
          "_id": 1,
          "counts.day": 1
        }
      },
      {
        $group: {
          _id: "$_id",
          counts: {
            $push: {
              count: "$counts.count",
              day: "$counts.day"
            }
          },
          total: {
            $first: "$total"
          }
        }
      },
      {
        $project: {
          _id: 1,
          counts: {
            $map: {
              input: Array.from({ length: moment(endOfMonth).date() }, (_, i) =>moment(startOfMonth).add(i, 'days').format("YYYY-MM-DD")),
              as: "day",
              in: {
                $cond: [{
                    $in: ["$$day", "$counts.day"]
                  },
                  {
                    $arrayElemAt: [
                      "$counts", {
                        $indexOfArray: ["$counts.day", "$$day"]
                      }
                    ]
                  },
                  {
                    day: "$$day",
                    count: 0
                  }
                ]
              }
            }
          },
          total: 1
        }
      }
    ]);
    console.log(data)
    res.render('operation/summary/work_perform_fe', { title: 'Summary', getData:data });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});
router.get('/pending_cases_fe', sessionCheck, async function(req, res, next) {
 const adminID=req.user.admin_id;
  try {
         var formDate = req.query.formdate;
var startOfMonth, endOfMonth;

if (formDate) {
    const month = parseInt(formDate.slice(0, 2)); // Months are zero-based in JavaScript Date objects
    const year = parseInt(formDate.slice(2, 6));
  startOfMonth = moment({ year, month, day: 1 }).startOf('day');
  endOfMonth = moment({ year, month, day: 1 }).endOf('month');
} else {
  const currentDate = moment();
  startOfMonth = currentDate.clone().startOf('month');
  endOfMonth = currentDate.clone().endOf('month');
}

// Convert to JavaScript Date objects if necessary
startOfMonth = startOfMonth.toDate();
endOfMonth = endOfMonth.toDate();

// Set hours for the Date objects
startOfMonth.setHours(0, 0, 0, 0);
endOfMonth.setHours(23, 59, 59, 999);
    const data = await verificationModel.aggregate([
      {
        $match: {
          updatedAt: {
            $gte: startOfMonth,
            $lte: endOfMonth
          },
          adminid: adminID,
          status: {
            $gte: 2,
            $lt: 4
          },
          feid: {
              $exists: true,
        $ne: null
        }
        }
      },
      {
        $group: {
          _id: {
            bankname: "$fename",
            day: {
              $dateToString: {
                format: "%Y-%m-%d",
                date: "$updatedAt"
              }
            }
          },
          count: {
            $sum: 1
          }
        }
      },
      {
        $group: {
          _id: "$_id.bankname",
          counts: {
            $push: {
              count: "$count",
              day: "$_id.day"
            }
          },
          total: {
            $sum: "$count"
          }
        }
      },
      {
        $project: {
          _id: 1,
          counts: 1,
          total: 1
        }
      },
      {
        $unwind: "$counts"
      },
      {
        $sort: {
          "_id": 1,
          "counts.day": 1
        }
      },
      {
        $group: {
          _id: "$_id",
          counts: {
            $push: {
              count: "$counts.count",
              day: "$counts.day"
            }
          },
          total: {
            $first: "$total"
          }
        }
      },
      {
        $project: {
          _id: 1,
          counts: {
            $map: {
              input: Array.from({ length: moment(endOfMonth).date() }, (_, i) =>moment(startOfMonth).add(i, 'days').format("YYYY-MM-DD")),
              as: "day",
              in: {
                $cond: [{
                    $in: ["$$day", "$counts.day"]
                  },
                  {
                    $arrayElemAt: [
                      "$counts", {
                        $indexOfArray: ["$counts.day", "$$day"]
                      }
                    ]
                  },
                  {
                    day: "$$day",
                    count: 0
                  }
                ]
              }
            }
          },
          total: 1
        }
      }
    ]);
    console.log(data)
    res.render('operation/summary/pending_cases_fe', { title: 'Summary', getData:data });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});
router.get('/sales_target',sessionCheck, async function(req, res, next){
     const adminID=req.user.admin_id;
     
              var formDate = req.query.formdate;
var startOfMonth, endOfMonth;

if (formDate) {
    const month = parseInt(formDate.slice(0, 2)); // Months are zero-based in JavaScript Date objects
    const year = parseInt(formDate.slice(2, 6));
  startOfMonth = moment({ year, month, day: 1 }).startOf('day');
  endOfMonth = moment({ year, month, day: 1 }).endOf('month');
} else {
  const currentDate = moment();
  startOfMonth = currentDate.clone().startOf('month');
  endOfMonth = currentDate.clone().endOf('month');
}

// Convert to JavaScript Date objects if necessary
startOfMonth = startOfMonth.toDate();
endOfMonth = endOfMonth.toDate();

// Set hours for the Date objects
startOfMonth.setHours(0, 0, 0, 0);
endOfMonth.setHours(23, 59, 59, 999);
  try{
      
const data = await targetModel.aggregate([
  {
    $match: { 
      admin_id: adminID,
      tagetdate: {
        $gte: startOfMonth,
        $lte: endOfMonth
      }
    }
  },
  {
    $lookup: {
      from: 'CorporateClients',
      localField: 'name',
      foreignField: 'name',
      as: 'bankData'
    }
  },
  {
    $project: {
      _id: 1,
      name: 1,
      target: 1,
      tagetdate: 1,
      admin_id: 1,
      bankarray: '$bankData._id'
    }
  }
]).exec();

await Promise.all(data.map(async (element) => {
  element.verificationCount = await verificationModel.countDocuments({
    "admin_id": adminID,
    "casetype": { $nin: ["tele"] },
    "createdAt": {
      $gte: startOfMonth,
      $lte: endOfMonth
    },
    "bankid": { "$in": element.bankarray }
  });
}));

    res.render('operation/summary/sales_target', { title: 'Summary', getData:data });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});

router.get('/sales_bank/:name',sessionCheck, async function(req, res, next){
    var salesname= req.params.name;
     const adminID=req.user.admin_id;
     
              var formDate = req.query.formdate;
var startOfMonth, endOfMonth;

if (formDate) {
    const month = parseInt(formDate.slice(0, 2)); // Months are zero-based in JavaScript Date objects
    const year = parseInt(formDate.slice(2, 6));
  startOfMonth = moment({ year, month, day: 1 }).startOf('day');
  endOfMonth = moment({ year, month, day: 1 }).endOf('month');
} else {
  const currentDate = moment();
  startOfMonth = currentDate.clone().startOf('month');
  endOfMonth = currentDate.clone().endOf('month');
}

// Convert to JavaScript Date objects if necessary
startOfMonth = startOfMonth.toDate();
endOfMonth = endOfMonth.toDate();

// Set hours for the Date objects
startOfMonth.setHours(0, 0, 0, 0);
endOfMonth.setHours(23, 59, 59, 999);
  try{
      
const data = await bank.find({
  admin_id: adminID,
  name: salesname,
}, {
  _id: 1,
  name: 1,
  BankName: 1,
}).lean().exec();
for (const element of data) {
  element.verificationCount = await verificationModel.countDocuments({
    casetype: { $nin: ["tele"] },
    createdAt: {
      $gte: startOfMonth,
      $lte: endOfMonth
    },
    bankid: element._id
  });
  const banktarget = await bwtargetModel.findOne({
  bankid: element._id,
  createdAt: {
    $gte: startOfMonth,
    $lte: endOfMonth
  },
}, { target: 1, _id: 0 }).exec();

element.banktarget = banktarget ? banktarget.target : 0;

}



    res.render('operation/summary/sales_bank', { title: 'Summary', getData:data, salesname });
  }catch(err){
    console.log('Data Not Fetched Error:'+err);
  }
});


module.exports = router;