 var express = require('express');
 var router = express.Router();
 var jwt = require('jsonwebtoken');
 var feteam= require('../../models/feteam');
 
 router.use(function (req, res, next) {
        var token = req.headers['x-access-token'];
        if (token) {
                jwt.verify(token, global.config.secretKey,
                {
                algorithm: global.config.algorithm
                
                },async function (err, decoded) {
                if (err) {
                        let errordata = {
                        message: err.message,
                        expiredAt: err.expiredAt
                        };
                        // console.log(errordata);
                        return res.status(500).json({
                        message: 'Unauthorized Access'
                        });
                }
                req.decoded = decoded;
                const getData = await feteam.findById(decoded.id,{ jwttoken: 1,}).exec();
                if(token == getData.jwttoken){
                    next(); 
                } else {
                    return res.status(500).json({
                    message: 'Token Mismatch'
                    });  
                }
                
                });
        } else {
                return res.status(500).json({
                message: 'Forbidden Access'
        });
        }
 });
 
 module.exports = router;