const mongoose = require('mongoose');
var uniqueValidator = require('mongoose-unique-validator');

const ClientSchema = new mongoose.Schema({
    BankName: {
        type: String,
        required: true,
        unique: true
    },
    password:{
        type: String,
        required: true
    },
    name: {
        type: String,
        required: true
    },
    email: {
        type: String,
        required: true,
        unique: true
    },
    contact: {
        type: String,
        required: true,
       
    },
    address: {
        type: String,
        required: true
    },
    status: {
        type: String,
        required: true,
        default: 'Active'
    },
    adminid:{
        type: String,
        required: true,
    },
    formtype:{
        type: String,
        required: true,
        default: 'defaultform'
    },
    logo: {
        type: String,
        required: false,
        default: ''
    },
});
ClientSchema.set('timestamps', true);

// Apply the uniqueValidator plugin to userSchema.
ClientSchema.plugin(uniqueValidator);

module.exports = mongoose.model('CorporateClients',ClientSchema,'CorporateClients');