const mongoose = require('mongoose');
var uniqueValidator = require('mongoose-unique-validator');

const UserSchema = new mongoose.Schema({
    username: {
        type: String,
        required: true,
        unique: true
    },
    password:{
        type: String,
        required: true
    },
    name: {
        type: String,
        required: true
    },
    email: {
        type: String,
        required: true,
        unique: true
    },
    contact: {
        type: Number,
        required: true,
        unique: true
    },
    address: {
        type: String,
        required: true
    },
    admin_id: {
        type: String,
        required: false
    },
    admin_name: {
        type: String,
        required: false
    },
    role: {
        type: String,
        required: true,
        default: "OT"
    },
    status: {
        type: String,
        required: true,
        default: 'Active'
    },
    adminImage: {
        type: String,
        required: false,
        default: ''
    },
    
});
UserSchema.set('timestamps', true);

// Apply the uniqueValidator plugin to userSchema.
UserSchema.plugin(uniqueValidator);

module.exports = mongoose.model('User',UserSchema,'User');