const mongoose = require('mongoose');
var uniqueValidator = require('mongoose-unique-validator');

const feteamSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true
    },
    password:{
        type: String,
        required: true
    },
    email: {
        type: String,
        required: true,
        unique: true
    },
    contact: {
        type: Number,
        required: true,
        unique: true
    },
    alternative_contact: {
        type: Number,
        required: false
    },
    address: {
        type: String,
        required: true
    },
    description: {
        type: String,
        required: false
    },
    profile: {
        type: String,
        required: false
    },
    digitalid: {
        type: String,
        required: false
    },
    admin_id: {
        type: String,
        required: true
    },
    status: {
        type: String,
        required: true,
        default: 'Active'
    },
    login: {
        type: String,
        required: true,
        default: 'No'
    },
    jwttoken: {
        type: String,
        required: false
    },
    fcmToken: {
        type: String,
        required: false
    },
    
});
feteamSchema.set('timestamps', true);

// Apply the uniqueValidator plugin to userSchema.
feteamSchema.plugin(uniqueValidator);

module.exports = mongoose.model('feteam',feteamSchema,'feteam');