const mongoose = require('mongoose');

const notificationSchema = new mongoose.Schema({
    title: {
        type: String,
        required: true
    },
    message: {
        type: String,
        required: true,
        default: ''
    },
    addedBy: {
        type: mongoose.ObjectId,
        required: true,
    },
    insertedDateTime: {
        type: String,
        required: true,
    },
    modifiedDateTime: {
        type: String,
        required: false,
        default: ''
    },
})

module.exports = mongoose.model('notificationModel',notificationSchema, 'notifications');