"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveRuntimeExtensions = void 0;
const types_1 = require("@smithy/types");
const asPartial = (t) => t;
const resolveRuntimeExtensions = (runtimeConfig, extensions) => {
    const clientConfiguration = {
        ...asPartial((0, types_1.getDefaultClientConfiguration)(runtimeConfig)),
    };
    extensions.forEach((extension) => extension.configureClient(clientConfiguration));
    return {
        ...runtimeConfig,
        ...(0, types_1.resolveDefaultRuntimeConfig)(clientConfiguration),
    };
};
exports.resolveRuntimeExtensions = resolveRuntimeExtensions;
