import { getDefaultClientConfiguration, resolveDefaultRuntimeConfig } from "@smithy/types";
const asPartial = (t) => t;
export const resolveRuntimeExtensions = (runtimeConfig, extensions) => {
    const clientConfiguration = {
        ...asPartial(getDefaultClientConfiguration(runtimeConfig)),
    };
    extensions.forEach((extension) => extension.configureClient(clientConfiguration));
    return {
        ...runtimeConfig,
        ...resolveDefaultRuntimeConfig(clientConfiguration),
    };
};
