// import express router
const express = require("express");
const router = express.Router();
let verifyToken = require('../middleware/apis/verifytoken');
var sessionCheck= require('../middleware/sessionCheck').isAdmin;

const fs = require('fs');

// multer start
const multer = require("multer");
let storage = multer.diskStorage({
  destination: function (req, file, cb) {
    //   console.log('This is Multer check');
    const adminID = req.user._id;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/FE/'+datefolder;
    fs.mkdirSync(dest, { recursive: true })
        cb(null, dest);
  },
  filename: function (req, file, cb) {
    let extArray = file.mimetype.split("/");
    let extension = extArray[extArray.length - 1];
    cb(null, file.fieldname + '-' + Date.now()+ '.' +extension)
  }
});
const upload = multer({ storage: storage });
// multer end


// import fe controller
var femanagementcontroller = require('../controllers/admin/femanagement');

// get index
router.get("/index",sessionCheck, femanagementcontroller.getindex);
// create
router.get("/create",sessionCheck, function(req, res, next) {
    res.render('admin/feteam/create', { title: 'FE List', viewDatas:null, getData:null });
});
// add fe
router.post("/addfe",sessionCheck, upload.single('profile'), femanagementcontroller.addfe);

/* Change User Status */
router.get("/update-status/:id",sessionCheck, femanagementcontroller.updatestatus);
/* to display edit detail data */
router.get("/edit/:id",sessionCheck, femanagementcontroller.edit );
/* to update client data */
router.post("/update/:id",sessionCheck, upload.fields([{ name: 'profile', maxCount: 1 },{ name: 'digitalid', maxCount: 1 }]), femanagementcontroller.update );

module.exports = router;