// import express router
const express = require("express");
const router = express.Router();
var sessionCheck= require('../middleware/sessionCheck').isAdmin;

const fs = require('fs');

// multer start
const multer = require("multer");
let storage = multer.diskStorage({
  destination: function (req, file, cb) {
    //   console.log('This is Multer check');
    const adminID = req.user._id;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/OT/'+datefolder;
    fs.mkdirSync(dest, { recursive: true })
        cb(null, dest);
  },
  filename: function (req, file, cb) {
    let extArray = file.mimetype.split("/");
    let extension = extArray[extArray.length - 1];
    cb(null, file.fieldname + '-' + Date.now()+ '.' +extension)
  }
});
const upload = multer({ storage: storage });
// multer end


// import fe controller
var operationcontroller = require('./../controllers/admin/operation');
var targetcontroller = require('./../controllers/admin/salestargetcontroller');
// get index
router.get("/index",sessionCheck, operationcontroller.getindex);
// create
router.get("/create",sessionCheck, function(req, res, next) {
    res.render('admin/operation/create', { title: 'FE List', viewDatas:null, getData:null });
});

// add operation
router.post("/addot",sessionCheck, upload.single('profile'), operationcontroller.addot);

/* Change User Status */
router.get("/update-status/:id",sessionCheck, operationcontroller.updatestatus);
/* to display edit detail data */
router.get("/edit/:id",sessionCheck, operationcontroller.edit );
/* to update client data */
router.post("/update/:id",sessionCheck, upload.single('profile'), operationcontroller.update );

// sales target
router.get("/salestarget/index",sessionCheck, targetcontroller.getindex);
router.get("/salestarget/create",sessionCheck, function(req, res, next) {
    res.render('admin/salestarget/create', { title: 'Sales Target List', viewDatas:null, getData:null });
});
router.post("/salestarget/addtarget",sessionCheck, targetcontroller.addtarget);
router.get("/salestarget/indexbw/:name",sessionCheck, targetcontroller.getindexbw);
router.get("/salestarget/createbw/:name",sessionCheck, targetcontroller.getcreatebw);
router.post("/salestarget/addtargetbw/:name",sessionCheck, targetcontroller.addtargetbw);
router.get("/salestarget/editbw/:id",sessionCheck, targetcontroller.edittargetbw);
router.post("/salestarget/updatebw/:id",sessionCheck, targetcontroller.updatetargetbw);
module.exports = router;