// import express router
const express = require("express");
const router = express.Router();
const { body, validationResult } = require('express-validator');
const fs = require('fs');

// multer start
const multer = require("multer");
let storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const adminID = req.decoded.adminid;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/FE/'+datefolder;
    fs.mkdirSync(dest, { recursive: true })
        cb(null, dest);
  },
  filename: function (req, file, cb) {
    let extArray = file.mimetype.split("/");
    let extension = extArray[extArray.length - 1];
    cb(null, file.fieldname + '-' + Date.now()+ '.' +extension)
  }
});
const upload = multer({ storage: storage });
// multer end

let verifyToken = require('../middleware/apis/verifytoken');
// import feauth controller
const FEAPIController = require("../apis/FEauth");
// import feindex controller
const FEindexController = require("../apis/FEindex");

// get version check
router.post("/check", body('version').not().isEmpty().withMessage('Version Required'), FEAPIController.getCheck);

// Login check
router.post("/login",body('fecontact').not().isEmpty().withMessage('fecontact Required'), body('password').not().isEmpty().withMessage('password Required'), FEAPIController.login);

// update token
router.post("/update_token", body('fcmToken').not().isEmpty().withMessage('fcmToken Required'), verifyToken, FEindexController.updatetoken);

// fe profile
router.get("/getprofile", verifyToken, FEindexController.getprofile);

// fe profile
router.post("/updateprofile", verifyToken, upload.single('profile'), FEindexController.updateprofile);

// fe attendencestart
router.post("/attendencestart", verifyToken, upload.single('photo'), FEindexController.attendencestart);

// fe runningattendence
router.get("/runningattendence", verifyToken,  FEindexController.runningattendence);

// fe stopattendence
router.post("/stopattendence", verifyToken, upload.single('photo'), FEindexController.stopattendence);

// fe monthattendence
router.post("/monthattendence", verifyToken, FEindexController.monthattendence);

// fe dashboard
router.post("/dashboard", verifyToken, FEindexController.index);

// fe profile
router.post("/request", verifyToken, FEindexController.request);

// fe profile
router.post("/accept", verifyToken,body('caseid').not().isEmpty().withMessage('caseid Required'), FEindexController.accept);

// fe profile
router.post("/assign", verifyToken, FEindexController.assign);

// fe profile
router.post("/start", verifyToken,body('caseid').not().isEmpty().withMessage('caseid Required'), FEindexController.start);

// fe profile
router.post("/started", verifyToken, FEindexController.started);


// fe profile
router.post("/completecases", verifyToken, FEindexController.completed);


module.exports = router;