// import express router
const express = require("express");
const router = express.Router();
var sessionCheck= require('../middleware/sessionCheck').isOpration;
const fs = require('fs');


// multer start
const multer = require("multer");

let storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const adminID = req.body.adminID;
    const Bank = req.body.bankID;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/'+Bank+'/physicalexcel/'+file.fieldname+'/'+datefolder;
    fs.mkdirSync(dest, { recursive: true })
        cb(null, dest);
  },
  filename: function (req, file, cb) {
    let extArray = file.mimetype.split("/");
    let extension = extArray[extArray.length - 1];
    cb(null, file.fieldname + '-' + Date.now()+ '.' +extension)
  }
});
const upload = multer({ storage: storage });
// multer end

// import controller
var officecontroller = require('../controllers/operation/physical/officecontroller');
var businesscontroller = require('../controllers/operation/physical/businesscontroller');
var employmentcontroller = require('../controllers/operation/physical/employmentcontroller');
var residencecontroller = require('../controllers/operation/physical/residencecontroller');
var salarypayslipcontroller = require('../controllers/operation/physical/salarypayslipcontroller');
var bankstatementcontroller = require('../controllers/operation/physical/bankstatementcontroller');
var aadharcontroller = require('../controllers/operation/physical/aadharcontroller');
var pancontroller = require('../controllers/operation/physical/pancontroller');
var votercontroller = require('../controllers/operation/physical/votercontroller');
var itrcontroller = require('../controllers/operation/physical/itrcontroller');
var gstcontroller = require('../controllers/operation/physical/gstcontroller');
var telecontroller = require('../controllers/operation/physical/telecontroller');
var form16controller = require('../controllers/operation/physical/form16controller');
var form26controller = require('../controllers/operation/physical/form26controller');
var reportcontroller = require('../controllers/operation/reportcontroller');
var CarDealercontroller = require('../controllers/operation/physical/CarDealercontroller');
var CarLoancontroller = require('../controllers/operation/physical/CarLoancontroller');
var Housingcontroller = require('../controllers/operation/physical/Housingcontroller');
// import end

// office
router.get("/office/index",sessionCheck, officecontroller.getindex);
router.get("/office/data",sessionCheck, officecontroller.getdata);
router.get("/office/create_case",sessionCheck, officecontroller.createcase);
router.get("/office/Download_Format/:adminID/:format",sessionCheck, officecontroller.DownloadFormat);
router.get("/office/assigned",sessionCheck, officecontroller.getassigned);
router.get("/office/assigneddata",sessionCheck, officecontroller.getassigneddata);
router.get("/office/done_fe",sessionCheck, officecontroller.getdonefe);
router.get("/office/done_fedata",sessionCheck, officecontroller.getdonefedata);
router.get("/office/done_by_ot",sessionCheck, officecontroller.getdonebyot);
router.get("/office/done_by_otdata",sessionCheck, officecontroller.getdonebyotdata);
router.get("/office/completed",sessionCheck, officecontroller.getcompleted);
router.get("/office/completeddata",sessionCheck, officecontroller.getcompleteddata);
router.get("/office/cancelled",sessionCheck, officecontroller.getcancelled);
router.get("/office/cancelleddata",sessionCheck, officecontroller.getcancelleddata);
router.post("/office/create_case/add",sessionCheck, upload.single("office"), officecontroller.postcreatecases);
router.post("/office/cancele-case/:id",sessionCheck, officecontroller.getcancellecasedata);
router.get("/office/assign-case/:id",sessionCheck, officecontroller.getassigncaseadddata);
router.post("/office/assign-case/add",sessionCheck, officecontroller.getassigncaseadddonedata);
router.get("/office/checkdata/:id",sessionCheck, officecontroller.getfillcheckdata);
router.post("/office/checkmail/:id",sessionCheck, officecontroller.getfillcheckmail);
router.get("/office/create_pdf",sessionCheck, officecontroller.getcreatepdf);
// router.get("/office/update/:id",sessionCheck, officecontroller.getupdatecheckdata);


// office end
// business
router.get("/business/index",sessionCheck, businesscontroller.getindex);
router.get("/business/data",sessionCheck, businesscontroller.getdata);
router.get("/business/create_case",sessionCheck, businesscontroller.createcase);
router.get("/business/Download_Format/:adminID/:format",sessionCheck, businesscontroller.DownloadFormat);
router.get("/business/assigned",sessionCheck, businesscontroller.getassigned);
router.get("/business/assigneddata",sessionCheck, businesscontroller.getassigneddata);
router.get("/business/done_fe",sessionCheck, businesscontroller.getdonefe);
router.get("/business/done_fedata",sessionCheck, businesscontroller.getdonefedata);
router.get("/business/done_by_ot",sessionCheck, businesscontroller.getdonebyot);
router.get("/business/done_by_otdata",sessionCheck, businesscontroller.getdonebyotdata);
router.get("/business/completed",sessionCheck, businesscontroller.getcompleted);
router.get("/business/completeddata",sessionCheck, businesscontroller.getcompleteddata);
router.get("/business/cancelled",sessionCheck, businesscontroller.getcancelled);
router.get("/business/cancelleddata",sessionCheck, businesscontroller.getcancelleddata);
router.post("/business/create_case/add",sessionCheck, upload.single("business"), businesscontroller.postcreatecases);
router.post("/business/cancele-case/:id",sessionCheck, businesscontroller.getcancellecasedata);
router.get("/business/assign-case/:id",sessionCheck, businesscontroller.getassigncaseadddata);
router.post("/business/assign-case/add",sessionCheck, businesscontroller.getassigncaseadddonedata);
router.get("/business/checkdata/:id",sessionCheck, businesscontroller.getfillcheckdata);
router.post("/business/checkmail/:id",sessionCheck, businesscontroller.getfillcheckmail);
router.get("/business/create_pdf",sessionCheck, businesscontroller.getcreatepdf);
// router.get("/business/update/:id",sessionCheck, businesscontroller.getupdatecheckdata);


// business end
// employment
router.get("/employment/index",sessionCheck, employmentcontroller.getindex);
router.get("/employment/data",sessionCheck, employmentcontroller.getdata);
router.get("/employment/create_case",sessionCheck, employmentcontroller.createcase);
router.get("/employment/Download_Format/:adminID/:format",sessionCheck, employmentcontroller.DownloadFormat);
router.get("/employment/assigned",sessionCheck, employmentcontroller.getassigned);
router.get("/employment/assigneddata",sessionCheck, employmentcontroller.getassigneddata);
router.get("/employment/done_fe",sessionCheck, employmentcontroller.getdonefe);
router.get("/employment/done_fedata",sessionCheck, employmentcontroller.getdonefedata);
router.get("/employment/done_by_ot",sessionCheck, employmentcontroller.getdonebyot);
router.get("/employment/done_by_otdata",sessionCheck, employmentcontroller.getdonebyotdata);
router.get("/employment/completed",sessionCheck, employmentcontroller.getcompleted);
router.get("/employment/completeddata",sessionCheck, employmentcontroller.getcompleteddata);
router.get("/employment/cancelled",sessionCheck, employmentcontroller.getcancelled);
router.get("/employment/cancelleddata",sessionCheck, employmentcontroller.getcancelleddata);
router.post("/employment/create_case/add",sessionCheck, upload.single("employment"), employmentcontroller.postcreatecases);
router.post("/employment/cancele-case/:id",sessionCheck, employmentcontroller.getcancellecasedata);
router.get("/employment/assign-case/:id",sessionCheck, employmentcontroller.getassigncaseadddata);
router.post("/employment/assign-case/add",sessionCheck, employmentcontroller.getassigncaseadddonedata);
router.get("/employment/checkdata/:id",sessionCheck, employmentcontroller.getfillcheckdata);
router.post("/employment/checkmail/:id",sessionCheck, employmentcontroller.getfillcheckmail);
router.get("/employment/create_pdf",sessionCheck, employmentcontroller.getcreatepdf);
// router.get("/employment/update/:id",sessionCheck, employmentcontroller.getupdatecheckdata);
// employment end

// residence
router.get("/residence/index",sessionCheck, residencecontroller.getindex);
router.get("/residence/data",sessionCheck, residencecontroller.getdata);
router.get("/residence/create_case",sessionCheck, residencecontroller.createcase);
router.get("/residence/Download_Format/:adminID/:format",sessionCheck, residencecontroller.DownloadFormat);
router.get("/residence/assigned",sessionCheck, residencecontroller.getassigned);
router.get("/residence/assigneddata",sessionCheck, residencecontroller.getassigneddata);
router.get("/residence/done_fe",sessionCheck, residencecontroller.getdonefe);
router.get("/residence/done_fedata",sessionCheck, residencecontroller.getdonefedata);
router.get("/residence/done_by_ot",sessionCheck, residencecontroller.getdonebyot);
router.get("/residence/done_by_otdata",sessionCheck, residencecontroller.getdonebyotdata);
router.get("/residence/completed",sessionCheck, residencecontroller.getcompleted);
router.get("/residence/completeddata",sessionCheck, residencecontroller.getcompleteddata);
router.get("/residence/cancelled",sessionCheck, residencecontroller.getcancelled);
router.get("/residence/cancelleddata",sessionCheck, residencecontroller.getcancelleddata);
router.post("/residence/create_case/add",sessionCheck, upload.single("residence"), residencecontroller.postcreatecases);
router.post("/residence/cancele-case/:id",sessionCheck, residencecontroller.getcancellecasedata);
router.get("/residence/assign-case/:id",sessionCheck, residencecontroller.getassigncaseadddata);
router.post("/residence/assign-case/add",sessionCheck, residencecontroller.getassigncaseadddonedata);
router.get("/residence/checkdata/:id",sessionCheck, residencecontroller.getfillcheckdata);
router.post("/residence/checkmail/:id",sessionCheck, residencecontroller.getfillcheckmail);
router.get("/residence/create_pdf",sessionCheck, residencecontroller.getcreatepdf);
// router.get("/residence/update/:id",sessionCheck, residencecontroller.getupdatecheckdata);
// residence end

// salarypayslip
router.get("/salarypayslip/index",sessionCheck, salarypayslipcontroller.getindex);
router.get("/salarypayslip/data",sessionCheck, salarypayslipcontroller.getdata);
router.get("/salarypayslip/create_case",sessionCheck, salarypayslipcontroller.createcase);
router.get("/salarypayslip/Download_Format/:adminID/:format",sessionCheck, salarypayslipcontroller.DownloadFormat);
router.get("/salarypayslip/assigned",sessionCheck, salarypayslipcontroller.getassigned);
router.get("/salarypayslip/assigneddata",sessionCheck, salarypayslipcontroller.getassigneddata);
router.get("/salarypayslip/done_fe",sessionCheck, salarypayslipcontroller.getdonefe);
router.get("/salarypayslip/done_fedata",sessionCheck, salarypayslipcontroller.getdonefedata);
router.get("/salarypayslip/done_by_ot",sessionCheck, salarypayslipcontroller.getdonebyot);
router.get("/salarypayslip/done_by_otdata",sessionCheck, salarypayslipcontroller.getdonebyotdata);
router.get("/salarypayslip/completed",sessionCheck, salarypayslipcontroller.getcompleted);
router.get("/salarypayslip/completeddata",sessionCheck, salarypayslipcontroller.getcompleteddata);
router.get("/salarypayslip/cancelled",sessionCheck, salarypayslipcontroller.getcancelled);
router.get("/salarypayslip/cancelleddata",sessionCheck, salarypayslipcontroller.getcancelleddata);
router.post("/salarypayslip/create_case/add",sessionCheck, upload.single("salarypayslip"), salarypayslipcontroller.postcreatecases);
router.post("/salarypayslip/cancele-case/:id",sessionCheck, salarypayslipcontroller.getcancellecasedata);
router.get("/salarypayslip/assign-case/:id",sessionCheck, salarypayslipcontroller.getassigncaseadddata);
router.post("/salarypayslip/assign-case/add",sessionCheck, salarypayslipcontroller.getassigncaseadddonedata);
router.get("/salarypayslip/checkdata/:id",sessionCheck, salarypayslipcontroller.getfillcheckdata);
router.post("/salarypayslip/checkmail/:id",sessionCheck, salarypayslipcontroller.getfillcheckmail);
router.get("/salarypayslip/create_pdf/:id",sessionCheck, salarypayslipcontroller.getcreatepdf);
// router.get("/salarypayslip/update/:id",sessionCheck, salarypayslipcontroller.getupdatecheckdata);
// salarypayslip end

// bankstatement
router.get("/bankstatement/index",sessionCheck, bankstatementcontroller.getindex);
router.get("/bankstatement/data",sessionCheck, bankstatementcontroller.getdata);
router.get("/bankstatement/create_case",sessionCheck, bankstatementcontroller.createcase);
router.get("/bankstatement/Download_Format/:adminID/:format",sessionCheck, bankstatementcontroller.DownloadFormat);
router.get("/bankstatement/assigned",sessionCheck, bankstatementcontroller.getassigned);
router.get("/bankstatement/assigneddata",sessionCheck, bankstatementcontroller.getassigneddata);
router.get("/bankstatement/done_fe",sessionCheck, bankstatementcontroller.getdonefe);
router.get("/bankstatement/done_fedata",sessionCheck, bankstatementcontroller.getdonefedata);
router.get("/bankstatement/done_by_ot",sessionCheck, bankstatementcontroller.getdonebyot);
router.get("/bankstatement/done_by_otdata",sessionCheck, bankstatementcontroller.getdonebyotdata);
router.get("/bankstatement/completed",sessionCheck, bankstatementcontroller.getcompleted);
router.get("/bankstatement/completeddata",sessionCheck, bankstatementcontroller.getcompleteddata);
router.get("/bankstatement/cancelled",sessionCheck, bankstatementcontroller.getcancelled);
router.get("/bankstatement/cancelleddata",sessionCheck, bankstatementcontroller.getcancelleddata);
router.post("/bankstatement/create_case/add",sessionCheck, upload.single("bankstatement"), bankstatementcontroller.postcreatecases);
router.post("/bankstatement/cancele-case/:id",sessionCheck, bankstatementcontroller.getcancellecasedata);
router.get("/bankstatement/assign-case/:id",sessionCheck, bankstatementcontroller.getassigncaseadddata);
router.post("/bankstatement/assign-case/add",sessionCheck, bankstatementcontroller.getassigncaseadddonedata);
router.get("/bankstatement/checkdata/:id",sessionCheck, bankstatementcontroller.getfillcheckdata);
router.post("/bankstatement/checkmail/:id",sessionCheck, bankstatementcontroller.getfillcheckmail);
router.get("/bankstatement/create_pdf/:id",sessionCheck, bankstatementcontroller.getcreatepdf);
// router.get("/bankstatement/update/:id",sessionCheck, bankstatementcontroller.getupdatecheckdata);
// bankstatement end

// tele
router.get("/tele/index",sessionCheck, telecontroller.getindex);
router.get("/tele/data",sessionCheck, telecontroller.getdata);
router.get("/tele/create_case",sessionCheck, telecontroller.createcase);
router.get("/tele/Download_Format/:adminID/:format",sessionCheck, telecontroller.DownloadFormat);
router.get("/tele/assigned",sessionCheck, telecontroller.getassigned);
router.get("/tele/assigneddata",sessionCheck, telecontroller.getassigneddata);
router.get("/tele/done_by_ot",sessionCheck, telecontroller.getdonebyot);
router.get("/tele/done_by_otdata",sessionCheck, telecontroller.getdonebyotdata);
router.get("/tele/completed",sessionCheck, telecontroller.getcompleted);
router.get("/tele/completeddata",sessionCheck, telecontroller.getcompleteddata);
router.get("/tele/cancelled",sessionCheck, telecontroller.getcancelled);
router.get("/tele/cancelleddata",sessionCheck, telecontroller.getcancelleddata);
router.post("/tele/create_case/add",sessionCheck, upload.single("tele"), telecontroller.postcreatecases);
router.post("/tele/cancele-case/:id",sessionCheck, telecontroller.getcancellecasedata);
router.get("/tele/assign-case/:id",sessionCheck, telecontroller.getassigncaseadddata);
router.get("/tele/checkdata/:id",sessionCheck, telecontroller.getfillcheckdata);
router.get("/tele/update/:id",sessionCheck, telecontroller.getupdatecheckdata);
router.post("/tele/checkmail/:id",sessionCheck, telecontroller.getfillcheckmail);
router.get("/tele/create_pdf/:id",sessionCheck, telecontroller.getcreatepdf);
// tele end

// form16
router.get("/form16/index",sessionCheck, form16controller.getindex);
router.get("/form16/data",sessionCheck, form16controller.getdata);
router.get("/form16/create_case",sessionCheck, form16controller.createcase);
router.get("/form16/Download_Format/:adminID/:format",sessionCheck, form16controller.DownloadFormat);
router.get("/form16/assigned",sessionCheck, form16controller.getassigned);
router.get("/form16/assigneddata",sessionCheck, form16controller.getassigneddata);
router.get("/form16/done_fe",sessionCheck, form16controller.getdonefe);
router.get("/form16/done_fedata",sessionCheck, form16controller.getdonefedata);
router.get("/form16/done_by_ot",sessionCheck, form16controller.getdonebyot);
router.get("/form16/done_by_otdata",sessionCheck, form16controller.getdonebyotdata);
router.get("/form16/completed",sessionCheck, form16controller.getcompleted);
router.get("/form16/completeddata",sessionCheck, form16controller.getcompleteddata);
router.get("/form16/cancelled",sessionCheck, form16controller.getcancelled);
router.get("/form16/cancelleddata",sessionCheck, form16controller.getcancelleddata);
router.post("/form16/create_case/add",sessionCheck, upload.single("form16"), form16controller.postcreatecases);
router.post("/form16/assign-case/add",sessionCheck, form16controller.getassigncaseadddonedata);
router.post("/form16/cancele-case/:id",sessionCheck, form16controller.getcancellecasedata);
router.get("/form16/assign-case/:id",sessionCheck, form16controller.getassigncaseadddata);
router.get("/form16/checkdata/:id",sessionCheck, form16controller.getfillcheckdata);
router.get("/form16/update/:id",sessionCheck, form16controller.getupdatecheckdata);
router.post("/form16/checkmail/:id",sessionCheck, form16controller.getfillcheckmail);
router.get("/form16/create_pdf/:id",sessionCheck, form16controller.getcreatepdf);
// form16 end

// form16
router.get("/form26/index",sessionCheck, form26controller.getindex);
router.get("/form26/data",sessionCheck, form26controller.getdata);
router.get("/form26/create_case",sessionCheck, form26controller.createcase);
router.get("/form26/Download_Format/:adminID/:format",sessionCheck, form26controller.DownloadFormat);
router.get("/form26/assigned",sessionCheck, form26controller.getassigned);
router.get("/form26/assigneddata",sessionCheck, form26controller.getassigneddata);
router.get("/form26/done_fe",sessionCheck, form26controller.getdonefe);
router.get("/form26/done_fedata",sessionCheck, form26controller.getdonefedata);
router.get("/form26/done_by_ot",sessionCheck, form26controller.getdonebyot);
router.get("/form26/done_by_otdata",sessionCheck, form26controller.getdonebyotdata);
router.get("/form26/completed",sessionCheck, form26controller.getcompleted);
router.get("/form26/completeddata",sessionCheck, form26controller.getcompleteddata);
router.get("/form26/cancelled",sessionCheck, form26controller.getcancelled);
router.get("/form26/cancelleddata",sessionCheck, form26controller.getcancelleddata);
router.post("/form26/create_case/add",sessionCheck, upload.single("form26"), form26controller.postcreatecases);
router.post("/form26/assign-case/add",sessionCheck, form26controller.getassigncaseadddonedata);
router.post("/form26/cancele-case/:id",sessionCheck, form26controller.getcancellecasedata);
router.get("/form26/assign-case/:id",sessionCheck, form26controller.getassigncaseadddata);
router.get("/form26/checkdata/:id",sessionCheck, form26controller.getfillcheckdata);
router.get("/form26/update/:id",sessionCheck, form26controller.getupdatecheckdata);
router.post("/form26/checkmail/:id",sessionCheck, form26controller.getfillcheckmail);
router.get("/form26/create_pdf/:id",sessionCheck, form26controller.getcreatepdf);
// form26 end


// aadhar
router.get("/aadhar/index",sessionCheck, aadharcontroller.getindex);
router.get("/aadhar/data",sessionCheck, aadharcontroller.getdata);
router.get("/aadhar/create_case",sessionCheck, aadharcontroller.createcase);
router.get("/aadhar/Download_Format/:adminID/:format",sessionCheck, aadharcontroller.DownloadFormat);
router.get("/aadhar/assigned",sessionCheck, aadharcontroller.getassigned);
router.get("/aadhar/assigneddata",sessionCheck, aadharcontroller.getassigneddata);
router.get("/aadhar/done_by_ot",sessionCheck, aadharcontroller.getdonebyot);
router.get("/aadhar/done_by_otdata",sessionCheck, aadharcontroller.getdonebyotdata);
router.get("/aadhar/completed",sessionCheck, aadharcontroller.getcompleted);
router.get("/aadhar/completeddata",sessionCheck, aadharcontroller.getcompleteddata);
router.get("/aadhar/cancelled",sessionCheck, aadharcontroller.getcancelled);
router.get("/aadhar/cancelleddata",sessionCheck, aadharcontroller.getcancelleddata);
router.post("/aadhar/create_case/add",sessionCheck, upload.single("aadhar"), aadharcontroller.postcreatecases);
router.post("/aadhar/cancele-case/:id",sessionCheck, aadharcontroller.getcancellecasedata);
router.get("/aadhar/assign-case/:id",sessionCheck, aadharcontroller.getassigncaseadddata);
router.get("/aadhar/checkdata/:id",sessionCheck, aadharcontroller.getfillcheckdata);
router.get("/aadhar/update/:id",sessionCheck, aadharcontroller.getupdatecheckdata);
router.post("/aadhar/checkmail/:id",sessionCheck, aadharcontroller.getfillcheckmail);
router.get("/aadhar/create_pdf/:id",sessionCheck, aadharcontroller.getcreatepdf);
// aadhar end

// pan
router.get("/pan/index",sessionCheck, pancontroller.getindex);
router.get("/pan/data",sessionCheck, pancontroller.getdata);
router.get("/pan/create_case",sessionCheck, pancontroller.createcase);
router.get("/pan/Download_Format/:adminID/:format",sessionCheck, pancontroller.DownloadFormat);
router.get("/pan/assigned",sessionCheck, pancontroller.getassigned);
router.get("/pan/assigneddata",sessionCheck, pancontroller.getassigneddata);
router.get("/pan/done_by_ot",sessionCheck, pancontroller.getdonebyot);
router.get("/pan/done_by_otdata",sessionCheck, pancontroller.getdonebyotdata);
router.get("/pan/completed",sessionCheck, pancontroller.getcompleted);
router.get("/pan/completeddata",sessionCheck, pancontroller.getcompleteddata);
router.get("/pan/cancelled",sessionCheck, pancontroller.getcancelled);
router.get("/pan/cancelleddata",sessionCheck, pancontroller.getcancelleddata);
router.post("/pan/create_case/add",sessionCheck, upload.single("pan"), pancontroller.postcreatecases);
router.post("/pan/cancele-case/:id",sessionCheck, pancontroller.getcancellecasedata);
router.get("/pan/assign-case/:id",sessionCheck, pancontroller.getassigncaseadddata);
router.get("/pan/checkdata/:id",sessionCheck, pancontroller.getfillcheckdata);
router.get("/pan/update/:id",sessionCheck, pancontroller.getupdatecheckdata);
router.post("/pan/checkmail/:id",sessionCheck, pancontroller.getfillcheckmail);
router.get("/pan/create_pdf/:id",sessionCheck, pancontroller.getcreatepdf);
// pan end

// voter
router.get("/voter/index",sessionCheck, votercontroller.getindex);
router.get("/voter/data",sessionCheck, votercontroller.getdata);
router.get("/voter/create_case",sessionCheck, votercontroller.createcase);
router.get("/voter/Download_Format/:adminID/:format",sessionCheck, votercontroller.DownloadFormat);
router.get("/voter/assigned",sessionCheck, votercontroller.getassigned);
router.get("/voter/assigneddata",sessionCheck, votercontroller.getassigneddata);
router.get("/voter/done_by_ot",sessionCheck, votercontroller.getdonebyot);
router.get("/voter/done_by_otdata",sessionCheck, votercontroller.getdonebyotdata);
router.get("/voter/completed",sessionCheck, votercontroller.getcompleted);
router.get("/voter/completeddata",sessionCheck, votercontroller.getcompleteddata);
router.get("/voter/cancelled",sessionCheck, votercontroller.getcancelled);
router.get("/voter/cancelleddata",sessionCheck, votercontroller.getcancelleddata);
router.post("/voter/create_case/add",sessionCheck, upload.single("voter"), votercontroller.postcreatecases);
router.post("/voter/cancele-case/:id",sessionCheck, votercontroller.getcancellecasedata);
router.get("/voter/assign-case/:id",sessionCheck, votercontroller.getassigncaseadddata);
router.get("/voter/checkdata/:id",sessionCheck, votercontroller.getfillcheckdata);
router.get("/voter/update/:id",sessionCheck, votercontroller.getupdatecheckdata);
router.post("/voter/checkmail/:id",sessionCheck, votercontroller.getfillcheckmail);
router.get("/voter/create_pdf/:id",sessionCheck, votercontroller.getcreatepdf);
// voter end
// itr
router.get("/itr/index",sessionCheck, itrcontroller.getindex);
router.get("/itr/data",sessionCheck, itrcontroller.getdata);
router.get("/itr/create_case",sessionCheck, itrcontroller.createcase);
router.get("/itr/Download_Format/:adminID/:format",sessionCheck, itrcontroller.DownloadFormat);
router.get("/itr/assigned",sessionCheck, itrcontroller.getassigned);
router.get("/itr/assigneddata",sessionCheck, itrcontroller.getassigneddata);
router.get("/itr/done_by_ot",sessionCheck, itrcontroller.getdonebyot);
router.get("/itr/done_by_otdata",sessionCheck, itrcontroller.getdonebyotdata);
router.get("/itr/completed",sessionCheck, itrcontroller.getcompleted);
router.get("/itr/completeddata",sessionCheck, itrcontroller.getcompleteddata);
router.get("/itr/cancelled",sessionCheck, itrcontroller.getcancelled);
router.get("/itr/cancelleddata",sessionCheck, itrcontroller.getcancelleddata);
router.post("/itr/create_case/add",sessionCheck, upload.single("itr"), itrcontroller.postcreatecases);
router.post("/itr/cancele-case/:id",sessionCheck, itrcontroller.getcancellecasedata);
router.get("/itr/assign-case/:id",sessionCheck, itrcontroller.getassigncaseadddata);
router.get("/itr/checkdata/:id",sessionCheck, itrcontroller.getfillcheckdata);
router.get("/itr/update/:id",sessionCheck, itrcontroller.getupdatecheckdata);
router.post("/itr/checkmail/:id",sessionCheck, itrcontroller.getfillcheckmail);
router.get("/itr/create_pdf/:id",sessionCheck, itrcontroller.getcreatepdf);
// itr end

// CarDealer
router.get("/CarDealer/index",sessionCheck, CarDealercontroller.getindex);
router.get("/CarDealer/data",sessionCheck, CarDealercontroller.getdata);
router.get("/CarDealer/create_case",sessionCheck, CarDealercontroller.createcase);
router.get("/CarDealer/Download_Format/:adminID/:format",sessionCheck, CarDealercontroller.DownloadFormat);
router.get("/CarDealer/assigned",sessionCheck, CarDealercontroller.getassigned);
router.get("/CarDealer/assigneddata",sessionCheck, CarDealercontroller.getassigneddata);
router.get("/CarDealer/done_fe",sessionCheck, CarDealercontroller.getdonefe);
router.get("/CarDealer/done_fedata",sessionCheck, CarDealercontroller.getdonefedata);
router.get("/CarDealer/done_by_ot",sessionCheck, CarDealercontroller.getdonebyot);
router.get("/CarDealer/done_by_otdata",sessionCheck, CarDealercontroller.getdonebyotdata);
router.get("/CarDealer/completed",sessionCheck, CarDealercontroller.getcompleted);
router.get("/CarDealer/completeddata",sessionCheck, CarDealercontroller.getcompleteddata);
router.get("/CarDealer/cancelled",sessionCheck, CarDealercontroller.getcancelled);
router.get("/CarDealer/cancelleddata",sessionCheck, CarDealercontroller.getcancelleddata);
router.post("/CarDealer/create_case/add",sessionCheck, upload.single("CarDealer"), CarDealercontroller.postcreatecases);
router.post("/CarDealer/cancele-case/:id",sessionCheck, CarDealercontroller.getcancellecasedata);
router.get("/CarDealer/assign-case/:id",sessionCheck, CarDealercontroller.getassigncaseadddata);
router.post("/CarDealer/assign-case/add",sessionCheck, CarDealercontroller.getassigncaseadddonedata);
router.get("/CarDealer/checkdata/:id",sessionCheck, CarDealercontroller.getfillcheckdata);
router.post("/CarDealer/checkmail/:id",sessionCheck, CarDealercontroller.getfillcheckmail);
router.get("/CarDealer/create_pdf/:id",sessionCheck, CarDealercontroller.getcreatepdf);
// router.get("/CarDealer/update/:id",sessionCheck, CarDealercontroller.getupdatecheckdata);
// CarDealer end

// Housing
router.get("/Housing/index",sessionCheck, Housingcontroller.getindex);
router.get("/Housing/data",sessionCheck, Housingcontroller.getdata);
router.get("/Housing/create_case",sessionCheck, Housingcontroller.createcase);
router.get("/Housing/Download_Format/:adminID/:format",sessionCheck, Housingcontroller.DownloadFormat);
router.get("/Housing/assigned",sessionCheck, Housingcontroller.getassigned);
router.get("/Housing/assigneddata",sessionCheck, Housingcontroller.getassigneddata);
router.get("/Housing/done_fe",sessionCheck, Housingcontroller.getdonefe);
router.get("/Housing/done_fedata",sessionCheck, Housingcontroller.getdonefedata);
router.get("/Housing/done_by_ot",sessionCheck, Housingcontroller.getdonebyot);
router.get("/Housing/done_by_otdata",sessionCheck, Housingcontroller.getdonebyotdata);
router.get("/Housing/completed",sessionCheck, Housingcontroller.getcompleted);
router.get("/Housing/completeddata",sessionCheck, Housingcontroller.getcompleteddata);
router.get("/Housing/cancelled",sessionCheck, Housingcontroller.getcancelled);
router.get("/Housing/cancelleddata",sessionCheck, Housingcontroller.getcancelleddata);
router.post("/Housing/create_case/add",sessionCheck, upload.single("Housing"), Housingcontroller.postcreatecases);
router.post("/Housing/cancele-case/:id",sessionCheck, Housingcontroller.getcancellecasedata);
router.get("/Housing/assign-case/:id",sessionCheck, Housingcontroller.getassigncaseadddata);
router.post("/Housing/assign-case/add",sessionCheck, Housingcontroller.getassigncaseadddonedata);
router.get("/Housing/checkdata/:id",sessionCheck, Housingcontroller.getfillcheckdata);
router.post("/Housing/checkmail/:id",sessionCheck, Housingcontroller.getfillcheckmail);
router.get("/Housing/create_pdf/:id",sessionCheck, Housingcontroller.getcreatepdf);
// router.get("/Housing/update/:id",sessionCheck, Housingcontroller.getupdatecheckdata);
// Housing end

// CarLoan
router.get("/CarLoan/index",sessionCheck, CarLoancontroller.getindex);
router.get("/CarLoan/data",sessionCheck, CarLoancontroller.getdata);
router.get("/CarLoan/create_case",sessionCheck, CarLoancontroller.createcase);
router.get("/CarLoan/Download_Format/:adminID/:format",sessionCheck, CarLoancontroller.DownloadFormat);
router.get("/CarLoan/assigned",sessionCheck, CarLoancontroller.getassigned);
router.get("/CarLoan/assigneddata",sessionCheck, CarLoancontroller.getassigneddata);
router.get("/CarLoan/done_fe",sessionCheck, CarLoancontroller.getdonefe);
router.get("/CarLoan/done_fedata",sessionCheck, CarLoancontroller.getdonefedata);
router.get("/CarLoan/done_by_ot",sessionCheck, CarLoancontroller.getdonebyot);
router.get("/CarLoan/done_by_otdata",sessionCheck, CarLoancontroller.getdonebyotdata);
router.get("/CarLoan/completed",sessionCheck, CarLoancontroller.getcompleted);
router.get("/CarLoan/completeddata",sessionCheck, CarLoancontroller.getcompleteddata);
router.get("/CarLoan/cancelled",sessionCheck, CarLoancontroller.getcancelled);
router.get("/CarLoan/cancelleddata",sessionCheck, CarLoancontroller.getcancelleddata);
router.post("/CarLoan/create_case/add",sessionCheck, upload.single("CarLoan"), CarLoancontroller.postcreatecases);
router.post("/CarLoan/cancele-case/:id",sessionCheck, CarLoancontroller.getcancellecasedata);
router.get("/CarLoan/assign-case/:id",sessionCheck, CarLoancontroller.getassigncaseadddata);
router.post("/CarLoan/assign-case/add",sessionCheck, CarLoancontroller.getassigncaseadddonedata);
router.get("/CarLoan/checkdata/:id",sessionCheck, CarLoancontroller.getfillcheckdata);
router.post("/CarLoan/checkmail/:id",sessionCheck, CarLoancontroller.getfillcheckmail);
router.get("/CarLoan/create_pdf/:id",sessionCheck, CarLoancontroller.getcreatepdf);
// router.get("/CarLoan/update/:id",sessionCheck, CarLoancontroller.getupdatecheckdata);
// CarLoan end

// gst
router.get("/gst/index",sessionCheck, gstcontroller.getindex);
router.get("/gst/data",sessionCheck, gstcontroller.getdata);
router.get("/gst/create_case",sessionCheck, gstcontroller.createcase);
router.get("/gst/Download_Format/:adminID/:format",sessionCheck, gstcontroller.DownloadFormat);
router.get("/gst/assigned",sessionCheck, gstcontroller.getassigned);
router.get("/gst/assigneddata",sessionCheck, gstcontroller.getassigneddata);
router.get("/gst/done_by_ot",sessionCheck, gstcontroller.getdonebyot);
router.get("/gst/done_by_otdata",sessionCheck, gstcontroller.getdonebyotdata);
router.get("/gst/completed",sessionCheck, gstcontroller.getcompleted);
router.get("/gst/completeddata",sessionCheck, gstcontroller.getcompleteddata);
router.get("/gst/cancelled",sessionCheck, gstcontroller.getcancelled);
router.get("/gst/cancelleddata",sessionCheck, gstcontroller.getcancelleddata);
router.post("/gst/create_case/add",sessionCheck, upload.single("gst"), gstcontroller.postcreatecases);
router.post("/gst/cancele-case/:id",sessionCheck, gstcontroller.getcancellecasedata);
router.get("/gst/assign-case/:id",sessionCheck, gstcontroller.getassigncaseadddata);
router.get("/gst/checkdata/:id",sessionCheck, gstcontroller.getfillcheckdata);
router.get("/gst/update/:id",sessionCheck, gstcontroller.getupdatecheckdata);
router.post("/gst/checkmail/:id",sessionCheck, gstcontroller.getfillcheckmail);
router.get("/gst/create_pdf/:id",sessionCheck, gstcontroller.getcreatepdf);
// gst end

// report
router.get("/report/misreport",sessionCheck, reportcontroller.getmis);
router.post("/report/misreport",sessionCheck, reportcontroller.postmis);
router.get("/report/reportsearch",sessionCheck, reportcontroller.reportsearch);
router.post("/report/reportmailupdate",sessionCheck, reportcontroller.updatemail);
//report end

module.exports = router;