// import express router
const express = require("express");
const router = express.Router();
let verifyToken = require('../middleware/apis/verifytoken');
var sessionCheck= require('../middleware/sessionCheck').isOpration;
const fs = require('fs');

// multer start
const multer = require("multer");

let storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const adminID = req.user.admin_id;
    const event = new Date();
    const datefolder = event.toDateString();
    const dest = imageBaseDir+'images/uploads/cases/uploads/'+adminID+'/physicalcases/'+file.fieldname+'/'+datefolder;
    fs.mkdirSync(dest, { recursive: true })
        cb(null, dest);
  },
  filename: function (req, file, cb) {
    let extArray = file.mimetype.split("/");
    let extension = extArray[extArray.length - 1];
    cb(null, file.fieldname + '-' + Date.now()+ '.' +extension)
  }
});
const upload = multer({ storage: storage });
// multer end

// import controller
var officecontroller = require('../controllers/operation/physical/officecontroller');
var businesscontroller = require('../controllers/operation/physical/businesscontroller');
var CarDealercontroller = require('../controllers/operation/physical/CarDealercontroller');
var residencecontroller = require('../controllers/operation/physical/residencecontroller');
var salarypayslipcontroller = require('../controllers/operation/physical/salarypayslipcontroller');
var bankstatementcontroller = require('../controllers/operation/physical/bankstatementcontroller');
var aadharcontroller = require('../controllers/operation/physical/aadharcontroller');
var pancontroller = require('../controllers/operation/physical/pancontroller');
var votercontroller = require('../controllers/operation/physical/votercontroller');
var itrcontroller = require('../controllers/operation/physical/itrcontroller');
var gstcontroller = require('../controllers/operation/physical/gstcontroller');
var telecontroller = require('../controllers/operation/physical/telecontroller');
var form16controller = require('../controllers/operation/physical/form16controller');
var form26controller = require('../controllers/operation/physical/form26controller');
var employmentcontroller = require('../controllers/operation/physical/employmentcontroller');
var CarLoancontroller = require('../controllers/operation/physical/CarLoancontroller');
var Housingcontroller = require('../controllers/operation/physical/Housingcontroller');
// import end

//
router.post("/office/updatecase/done",sessionCheck, officecontroller.postupdatecasesadd);
router.post("/office/addimages",sessionCheck, upload.fields([{ name: 'office', maxCount: 10 }]), officecontroller.addimages);
router.get("/office/removeimages/:id",sessionCheck, officecontroller.removeimages);

router.post("/business/updatecase/done",sessionCheck,  businesscontroller.postupdatecasesadd);
router.post("/business/addimages",sessionCheck, upload.fields([{ name: 'business', maxCount: 10 }]), businesscontroller.addimages);
router.get("/business/removeimages/:id",sessionCheck, businesscontroller.removeimages);


router.post("/employment/updatecase/done",sessionCheck, employmentcontroller.postupdatecasesadd);
router.post("/employment/addimages",sessionCheck, upload.fields([{ name: 'employment', maxCount: 10 }]), employmentcontroller.addimages);
router.get("/employment/removeimages/:id",sessionCheck, employmentcontroller.removeimages);

router.post("/CarDealer/updatecase/done",sessionCheck, CarDealercontroller.postupdatecasesadd);
router.post("/CarDealer/addimages",sessionCheck, upload.fields([{ name: 'CarDealer', maxCount: 10 }]), CarDealercontroller.addimages);
router.get("/CarDealer/removeimages/:id",sessionCheck, CarDealercontroller.removeimages);

router.post("/CarLoan/updatecase/done",sessionCheck, CarLoancontroller.postupdatecasesadd);
router.post("/CarLoan/addimages",sessionCheck, upload.fields([{ name: 'CarLoan', maxCount: 10 }]), CarLoancontroller.addimages);
router.get("/CarLoan/removeimages/:id",sessionCheck, CarLoancontroller.removeimages);

router.post("/Housing/updatecase/done",sessionCheck, Housingcontroller.postupdatecasesadd);
router.post("/Housing/addimages",sessionCheck, upload.fields([{ name: 'Housing', maxCount: 10 }]), Housingcontroller.addimages);
router.get("/Housing/removeimages/:id",sessionCheck, Housingcontroller.removeimages);

router.post("/residence/updatecase/done",sessionCheck, residencecontroller.postupdatecasesadd);
router.post("/residence/addimages",sessionCheck, upload.fields([{ name: 'residence', maxCount: 10 }]), residencecontroller.addimages);
router.get("/residence/removeimages/:id",sessionCheck, residencecontroller.removeimages);

router.post("/Salary_Paysilp/updatecase/done",sessionCheck, salarypayslipcontroller.postupdatecasesadd);
router.post("/Salary_Paysilp/addimages",sessionCheck, upload.fields([{ name: 'Salary_Paysilp', maxCount: 10 }]), salarypayslipcontroller.addimages);
router.get("/Salary_Paysilp/removeimages/:id",sessionCheck, salarypayslipcontroller.removeimages);

router.post("/bankstatement/updatecase/done",sessionCheck, bankstatementcontroller.postupdatecasesadd);
router.post("/bankstatement/addimages",sessionCheck, upload.fields([{ name: 'bankstatement', maxCount: 10 }]), bankstatementcontroller.addimages);
router.get("/bankstatement/removeimages/:id",sessionCheck, bankstatementcontroller.removeimages);


// aadhar
router.post("/aadhar/create_case/add",sessionCheck, upload.fields([{ name: 'aadhar', maxCount: 5 }]), aadharcontroller.postcreatecasesadd);
router.post("/aadhar/updatecase/done",sessionCheck, upload.fields([{ name: 'aadhar', maxCount: 5 }]), aadharcontroller.postupdatecasesadd);
router.get("/aadhar/removeimages/:id",sessionCheck, aadharcontroller.removeimages);
// aadhar end
// pan
router.post("/pan/create_case/add",sessionCheck, upload.fields([{ name: 'pan', maxCount: 5 }]), pancontroller.postcreatecasesadd);
router.post("/pan/updatecase/done",sessionCheck, upload.fields([{ name: 'pan', maxCount: 5 }]), pancontroller.postupdatecasesadd);
router.get("/pan/removeimages/:id",sessionCheck, pancontroller.removeimages);

// pan end
// voter
router.post("/voter/create_case/add",sessionCheck, upload.fields([{ name: 'voter', maxCount: 5 }]), votercontroller.postcreatecasesadd);
router.post("/voter/updatecase/done",sessionCheck, upload.fields([{ name: 'voter', maxCount: 5 }]), votercontroller.postupdatecasesadd);
router.get("/voter/removeimages/:id",sessionCheck, votercontroller.removeimages);

// voter end
// gst
router.post("/gst/create_case/add",sessionCheck, upload.fields([{ name: 'gst', maxCount: 5 }]), gstcontroller.postcreatecasesadd);
router.post("/gst/updatecase/done",sessionCheck, upload.fields([{ name: 'gst', maxCount: 5 }]), gstcontroller.postupdatecasesadd);
router.get("/gst/removeimages/:id",sessionCheck, gstcontroller.removeimages);

// gst end

// itr
router.post("/itr/create_case/add",sessionCheck, upload.fields([{ name: 'itr', maxCount: 5 }]), itrcontroller.postcreatecasesadd);
router.post("/itr/updatecase/done",sessionCheck, upload.fields([{ name: 'itr', maxCount: 5 }]), itrcontroller.postupdatecasesadd);
router.get("/itr/removeimages/:id",sessionCheck, itrcontroller.removeimages);

// itr end
// tele
router.post("/tele/create_case/add",sessionCheck, upload.fields([{ name: 'tele', maxCount: 5 }]), telecontroller.postcreatecasesadd);
router.post("/tele/updatecase/done",sessionCheck, upload.fields([{ name: 'tele', maxCount: 5 }]), telecontroller.postupdatecasesadd);
router.get("/tele/removeimages/:id",sessionCheck, telecontroller.removeimages);
// tele end
// form16
router.post("/form16/create_case/add",sessionCheck, upload.fields([{ name: 'form16', maxCount: 5 }]), form16controller.postcreatecasesadd);
router.post("/form16/updatecase/done",sessionCheck, upload.fields([{ name: 'form16', maxCount: 5 }]), form16controller.postupdatecasesadd);
router.get("/form16/removeimages/:id",sessionCheck, form16controller.removeimages);

// form16 end

// form26
router.post("/form26/create_case/add",sessionCheck, upload.fields([{ name: 'form26', maxCount: 5 }]), form26controller.postcreatecasesadd);
router.post("/form26/updatecase/done",sessionCheck, upload.fields([{ name: 'form26', maxCount: 5 }]), form26controller.postupdatecasesadd);
router.get("/form26/removeimages/:id",sessionCheck, form26controller.removeimages);

// form26 end

module.exports = router;